/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.IntegerReader;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.SerializationUtils;

class RunLengthIntegerReader
implements IntegerReader {
    private final InStream input;
    private final boolean signed;
    private final long[] literals = new long[128];
    private int numLiterals = 0;
    private int delta = 0;
    private int used = 0;
    private boolean repeat = false;

    RunLengthIntegerReader(InStream input, boolean signed) throws IOException {
        this.input = input;
        this.signed = signed;
    }

    private void readValues() throws IOException {
        int control = this.input.read();
        if (control == -1) {
            throw new EOFException("Read past end of RLE integer from " + this.input);
        }
        if (control < 128) {
            this.numLiterals = control + 3;
            this.used = 0;
            this.repeat = true;
            this.delta = this.input.read();
            if (this.delta == -1) {
                throw new EOFException("End of stream in RLE Integer from " + this.input);
            }
            this.delta = (byte)(0 + this.delta);
            this.literals[0] = this.signed ? SerializationUtils.readVslong(this.input) : SerializationUtils.readVulong(this.input);
        } else {
            this.repeat = false;
            this.numLiterals = 256 - control;
            this.used = 0;
            for (int i = 0; i < this.numLiterals; ++i) {
                this.literals[i] = this.signed ? SerializationUtils.readVslong(this.input) : SerializationUtils.readVulong(this.input);
            }
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.used != this.numLiterals || this.input.available() > 0;
    }

    @Override
    public long next() throws IOException {
        if (this.used == this.numLiterals) {
            this.readValues();
        }
        long result = this.repeat ? this.literals[0] + (long)(this.used++ * this.delta) : this.literals[this.used++];
        return result;
    }

    @Override
    public void seek(PositionProvider index) throws IOException {
        int consumed;
        this.input.seek(index);
        if (consumed != 0) {
            for (consumed = (int)index.getNext(); consumed > 0; consumed -= this.numLiterals) {
                this.readValues();
                this.used = consumed;
            }
        } else {
            this.used = 0;
            this.numLiterals = 0;
        }
    }

    @Override
    public void skip(long numValues) throws IOException {
        while (numValues > 0L) {
            if (this.used == this.numLiterals) {
                this.readValues();
            }
            long consume = Math.min(numValues, (long)(this.numLiterals - this.used));
            this.used = (int)((long)this.used + consume);
            numValues -= consume;
        }
    }
}

