/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.session.SessionState;

public class PerfLogger {
    public static final String ACQUIRE_READ_WRITE_LOCKS = "acquireReadWriteLocks";
    public static final String COMPILE = "compile";
    public static final String PARSE = "parse";
    public static final String ANALYZE = "semanticAnalyze";
    public static final String DO_AUTHORIZATION = "doAuthorization";
    public static final String DRIVER_EXECUTE = "Driver.execute";
    public static final String INPUT_SUMMARY = "getInputSummary";
    public static final String GET_SPLITS = "getSplits";
    public static final String RUN_TASKS = "runTasks";
    public static final String SERIALIZE_PLAN = "serializePlan";
    public static final String DESERIALIZE_PLAN = "deserializePlan";
    public static final String CLONE_PLAN = "clonePlan";
    public static final String TASK = "task.";
    public static final String RELEASE_LOCKS = "releaseLocks";
    public static final String PRUNE_LISTING = "prune-listing";
    public static final String PARTITION_RETRIEVING = "partition-retrieving";
    public static final String PRE_HOOK = "PreHook.";
    public static final String POST_HOOK = "PostHook.";
    public static final String FAILURE_HOOK = "FailureHook.";
    public static final String DRIVER_RUN = "Driver.run";
    public static final String TIME_TO_SUBMIT = "TimeToSubmit";
    protected static final ThreadLocal<PerfLogger> perfLogger = new ThreadLocal();
    protected final Map<String, Long> startTimes = new HashMap<String, Long>();
    protected final Map<String, Long> endTimes = new HashMap<String, Long>();
    private static final Log LOG = LogFactory.getLog((String)PerfLogger.class.getName());

    public static PerfLogger getPerfLogger() {
        return PerfLogger.getPerfLogger(false);
    }

    public static PerfLogger getPerfLogger(boolean resetPerfLogger) {
        if (SessionState.get() == null) {
            if (perfLogger.get() == null || resetPerfLogger) {
                perfLogger.set(new PerfLogger());
            }
            return perfLogger.get();
        }
        return SessionState.get().getPerfLogger(resetPerfLogger);
    }

    public void PerfLogBegin(Log _log, String method) {
        long startTime = System.currentTimeMillis();
        _log.info((Object)("<PERFLOG method=" + method + ">"));
        this.startTimes.put(method, new Long(startTime));
    }

    public long PerfLogEnd(Log _log, String method) {
        Long startTime = this.startTimes.get(method);
        long endTime = System.currentTimeMillis();
        long duration = -1L;
        this.endTimes.put(method, new Long(endTime));
        StringBuilder sb = new StringBuilder("</PERFLOG method=").append(method);
        if (startTime != null) {
            sb.append(" start=").append(startTime);
        }
        sb.append(" end=").append(endTime);
        if (startTime != null) {
            duration = endTime - startTime;
            sb.append(" duration=").append(duration);
        }
        sb.append(">");
        _log.info((Object)sb);
        return duration;
    }

    public void close(Log _log, QueryPlan queryPlan) {
    }

    public Long getStartTime(String method) {
        return this.startTimes.get(method);
    }

    public Long getEndTime(String method) {
        return this.endTimes.get(method);
    }
}

