/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.formatting;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.MapBuilder;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonMetaDataFormatter
implements MetaDataFormatter {
    private static final Log LOG = LogFactory.getLog(JsonMetaDataFormatter.class);

    private void asJson(OutputStream out, Map<String, Object> data) throws HiveException {
        try {
            new ObjectMapper().writeValue(out, data);
        }
        catch (IOException e) {
            throw new HiveException("Unable to convert to json", e);
        }
    }

    @Override
    public void error(OutputStream out, String msg, int errorCode, String sqlState) throws HiveException {
        this.error(out, msg, errorCode, sqlState, null);
    }

    @Override
    public void error(OutputStream out, String errorMessage, int errorCode, String sqlState, String errorDetail) throws HiveException {
        MapBuilder mb = MapBuilder.create().put("error", errorMessage);
        if (errorDetail != null) {
            mb.put("errorDetail", errorDetail);
        }
        mb.put("errorCode", errorCode);
        if (sqlState != null) {
            mb.put("sqlState", sqlState);
        }
        this.asJson(out, mb.build());
    }

    @Override
    public void showTables(DataOutputStream out, Set<String> tables) throws HiveException {
        this.asJson(out, MapBuilder.create().put("tables", tables).build());
    }

    @Override
    public void describeTable(DataOutputStream out, String colPath, String tableName, Table tbl, Partition part, List<FieldSchema> cols, boolean isFormatted, boolean isExt, boolean isPretty) throws HiveException {
        MapBuilder builder = MapBuilder.create();
        builder.put("columns", this.makeColsUnformatted(cols));
        if (isExt) {
            if (part != null) {
                builder.put("partitionInfo", part.getTPartition());
            } else {
                builder.put("tableInfo", tbl.getTTable());
            }
        }
        this.asJson(out, builder.build());
    }

    private List<Map<String, Object>> makeColsUnformatted(List<FieldSchema> cols) {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        for (FieldSchema col : cols) {
            res.add(this.makeOneColUnformatted(col));
        }
        return res;
    }

    private Map<String, Object> makeOneColUnformatted(FieldSchema col) {
        return MapBuilder.create().put("name", col.getName()).put("type", col.getType()).put("comment", col.getComment()).build();
    }

    @Override
    public void showTableStatus(DataOutputStream out, Hive db, HiveConf conf, List<Table> tbls, Map<String, String> part, Partition par) throws HiveException {
        this.asJson(out, MapBuilder.create().put("tables", this.makeAllTableStatus(db, conf, tbls, part, par)).build());
    }

    private List<Map<String, Object>> makeAllTableStatus(Hive db, HiveConf conf, List<Table> tbls, Map<String, String> part, Partition par) throws HiveException {
        try {
            ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
            for (Table tbl : tbls) {
                res.add(this.makeOneTableStatus(tbl, db, conf, part, par));
            }
            return res;
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private Map<String, Object> makeOneTableStatus(Table tbl, Hive db, HiveConf conf, Map<String, String> part, Partition par) throws HiveException, IOException {
        String tblLoc = null;
        String inputFormattCls = null;
        String outputFormattCls = null;
        if (part != null) {
            if (par != null) {
                if (par.getLocation() != null) {
                    tblLoc = par.getDataLocation().toString();
                }
                inputFormattCls = par.getInputFormatClass().getName();
                outputFormattCls = par.getOutputFormatClass().getName();
            }
        } else {
            if (tbl.getPath() != null) {
                tblLoc = tbl.getDataLocation().toString();
            }
            inputFormattCls = tbl.getInputFormatClass().getName();
            outputFormattCls = tbl.getOutputFormatClass().getName();
        }
        MapBuilder builder = MapBuilder.create();
        builder.put("tableName", tbl.getTableName());
        builder.put("owner", tbl.getOwner());
        builder.put("location", tblLoc);
        builder.put("inputFormat", inputFormattCls);
        builder.put("outputFormat", outputFormattCls);
        builder.put("columns", this.makeColsUnformatted(tbl.getCols()));
        builder.put("partitioned", tbl.isPartitioned());
        if (tbl.isPartitioned()) {
            builder.put("partitionColumns", this.makeColsUnformatted(tbl.getPartCols()));
        }
        this.putFileSystemsStats(builder, this.makeTableStatusLocations(tbl, db, par), conf, tbl.getPath());
        return builder.build();
    }

    private List<Path> makeTableStatusLocations(Table tbl, Hive db, Partition par) throws HiveException {
        Path tblPath = tbl.getPath();
        ArrayList<Path> locations = new ArrayList<Path>();
        if (tbl.isPartitioned()) {
            if (par == null) {
                for (Partition curPart : db.getPartitions(tbl)) {
                    if (curPart.getLocation() == null) continue;
                    locations.add(new Path(curPart.getLocation()));
                }
            } else if (par.getLocation() != null) {
                locations.add(new Path(par.getLocation()));
            }
        } else if (tblPath != null) {
            locations.add(tblPath);
        }
        return locations;
    }

    private void putFileSystemsStats(MapBuilder builder, List<Path> locations, HiveConf conf, Path tblPath) throws IOException {
        long totalFileSize = 0L;
        long maxFileSize = 0L;
        long minFileSize = Long.MAX_VALUE;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        int numOfFiles = 0;
        boolean unknown = false;
        FileSystem fs = tblPath.getFileSystem((Configuration)conf);
        try {
            FileStatus tmpStatus = fs.getFileStatus(tblPath);
            lastAccessTime = ShimLoader.getHadoopShims().getAccessTime(tmpStatus);
            lastUpdateTime = tmpStatus.getModificationTime();
        }
        catch (IOException e) {
            LOG.warn((Object)"Cannot access File System. File System status will be unknown: ", (Throwable)e);
            unknown = true;
        }
        if (!unknown) {
            for (Path loc : locations) {
                try {
                    FileStatus status = fs.getFileStatus(tblPath);
                    FileStatus[] files = fs.listStatus(loc);
                    long accessTime = ShimLoader.getHadoopShims().getAccessTime(status);
                    long updateTime = status.getModificationTime();
                    if (!status.isDir()) continue;
                    if (accessTime > lastAccessTime) {
                        lastAccessTime = accessTime;
                    }
                    if (updateTime > lastUpdateTime) {
                        lastUpdateTime = updateTime;
                    }
                    for (FileStatus currentStatus : files) {
                        if (currentStatus.isDir()) continue;
                        ++numOfFiles;
                        long fileLen = currentStatus.getLen();
                        totalFileSize += fileLen;
                        if (fileLen > maxFileSize) {
                            maxFileSize = fileLen;
                        }
                        if (fileLen < minFileSize) {
                            minFileSize = fileLen;
                        }
                        accessTime = ShimLoader.getHadoopShims().getAccessTime(currentStatus);
                        updateTime = currentStatus.getModificationTime();
                        if (accessTime > lastAccessTime) {
                            lastAccessTime = accessTime;
                        }
                        if (updateTime <= lastUpdateTime) continue;
                        lastUpdateTime = updateTime;
                    }
                }
                catch (IOException e) {
                }
            }
        }
        builder.put("totalNumberFiles", numOfFiles, !unknown).put("totalFileSize", totalFileSize, !unknown).put("maxFileSize", maxFileSize, !unknown).put("minFileSize", numOfFiles > 0 ? minFileSize : 0L, !unknown).put("lastAccessTime", lastAccessTime, !unknown && lastAccessTime >= 0L).put("lastUpdateTime", lastUpdateTime, !unknown);
    }

    @Override
    public void showTablePartitons(DataOutputStream out, List<String> parts) throws HiveException {
        this.asJson(out, MapBuilder.create().put("partitions", this.makeTablePartions(parts)).build());
    }

    private List<Map<String, Object>> makeTablePartions(List<String> parts) throws HiveException {
        try {
            ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
            for (String part : parts) {
                res.add(this.makeOneTablePartition(part));
            }
            return res;
        }
        catch (UnsupportedEncodingException e) {
            throw new HiveException(e);
        }
    }

    private Map<String, Object> makeOneTablePartition(String partIdent) throws UnsupportedEncodingException {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        ArrayList<String> names = new ArrayList<String>();
        String[] arr$ = StringUtils.split(partIdent, "/");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String part;
            String name = part = arr$[i$];
            String val = null;
            String[] kv = StringUtils.split(part, "=", 2);
            if (kv != null) {
                name = kv[0];
                if (kv.length > 1) {
                    val = URLDecoder.decode(kv[1], "UTF-8");
                }
            }
            if (val != null) {
                names.add(name + "='" + val + "'");
            } else {
                names.add(name);
            }
            res.add(MapBuilder.create().put("columnName", name).put("columnValue", val).build());
        }
        return MapBuilder.create().put("name", StringUtils.join(names, ",")).put("values", res).build();
    }

    @Override
    public void showDatabases(DataOutputStream out, List<String> databases) throws HiveException {
        this.asJson(out, MapBuilder.create().put("databases", databases).build());
    }

    @Override
    public void showDatabaseDescription(DataOutputStream out, String database, String comment, String location, Map<String, String> params) throws HiveException {
        if (params == null || params.isEmpty()) {
            this.asJson(out, MapBuilder.create().put("database", database).put("comment", comment).put("location", location).build());
        } else {
            this.asJson(out, MapBuilder.create().put("database", database).put("comment", comment).put("location", location).put("params", params).build());
        }
    }
}

