/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EximUtil {
    private static Log LOG = LogFactory.getLog(EximUtil.class);
    public static final String METADATA_FORMAT_VERSION = "0.1";
    public static final String METADATA_FORMAT_FORWARD_COMPATIBLE_VERSION = null;

    private EximUtil() {
    }

    static URI getValidatedURI(HiveConf conf, String dcPath) throws SemanticException {
        try {
            boolean testMode = conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE);
            URI uri = new Path(dcPath).toUri();
            String scheme = uri.getScheme();
            String authority = uri.getAuthority();
            String path = uri.getPath();
            LOG.debug((Object)("Path before norm :" + path));
            if (!path.startsWith("/")) {
                path = testMode ? new Path(System.getProperty("build.dir.hive"), path).toUri().getPath() : new Path(new Path("/user/" + System.getProperty("user.name")), path).toUri().getPath();
            }
            if (StringUtils.isEmpty(scheme)) {
                scheme = testMode ? "pfile" : "hdfs";
            }
            if (StringUtils.isEmpty(authority)) {
                URI defaultURI = FileSystem.get((Configuration)conf).getUri();
                authority = defaultURI.getAuthority();
            }
            LOG.debug((Object)("Scheme:" + scheme + ", authority:" + authority + ", path:" + path));
            Collection eximSchemes = conf.getStringCollection(HiveConf.ConfVars.HIVE_EXIM_URI_SCHEME_WL.varname);
            if (!eximSchemes.contains(scheme)) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg("only the following file systems accepted for export/import : " + conf.get(HiveConf.ConfVars.HIVE_EXIM_URI_SCHEME_WL.varname)));
            }
            try {
                return new URI(scheme, authority, path, null, null);
            }
            catch (URISyntaxException e) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
            }
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg(), e);
        }
    }

    static void validateTable(Table table) throws SemanticException {
        if (table.isOffline()) {
            throw new SemanticException(ErrorMsg.OFFLINE_TABLE_OR_PARTITION.getMsg(":Table " + table.getTableName()));
        }
        if (table.isView()) {
            throw new SemanticException(ErrorMsg.DML_AGAINST_VIEW.getMsg());
        }
        if (table.isNonNative()) {
            throw new SemanticException(ErrorMsg.EXIM_FOR_NON_NATIVE.getMsg());
        }
    }

    public static String relativeToAbsolutePath(HiveConf conf, String location) throws SemanticException {
        boolean testMode = conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE);
        if (testMode) {
            URI uri = new Path(location).toUri();
            String scheme = uri.getScheme();
            String authority = uri.getAuthority();
            String path = uri.getPath();
            if (!path.startsWith("/")) {
                path = new Path(System.getProperty("build.dir.hive"), path).toUri().getPath();
            }
            if (StringUtils.isEmpty(scheme)) {
                scheme = "pfile";
            }
            try {
                uri = new URI(scheme, authority, path, null, null);
            }
            catch (URISyntaxException e) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
            }
            return uri.toString();
        }
        return location;
    }

    public static void createExportDump(FileSystem fs, Path metadataPath, Table tableHandle, List<Partition> partitions) throws SemanticException, IOException {
        try {
            JSONObject jsonContainer = new JSONObject();
            jsonContainer.put("version", METADATA_FORMAT_VERSION);
            if (METADATA_FORMAT_FORWARD_COMPATIBLE_VERSION != null) {
                jsonContainer.put("fcversion", METADATA_FORMAT_FORWARD_COMPATIBLE_VERSION);
            }
            TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
            try {
                String tableDesc = serializer.toString((TBase)tableHandle.getTTable(), "UTF-8");
                jsonContainer.put("table", tableDesc);
                JSONArray jsonPartitions = new JSONArray();
                if (partitions != null) {
                    for (Partition partition : partitions) {
                        String partDesc = serializer.toString((TBase)partition.getTPartition(), "UTF-8");
                        jsonPartitions.put(partDesc);
                    }
                }
                jsonContainer.put("partitions", jsonPartitions);
            }
            catch (TException e) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg("Exception while serializing the metastore objects"), e);
            }
            FSDataOutputStream out = fs.create(metadataPath);
            out.write(jsonContainer.toString().getBytes("UTF-8"));
            out.close();
        }
        catch (JSONException e) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg("Error in serializing metadata"), e);
        }
    }

    public static Map.Entry<org.apache.hadoop.hive.metastore.api.Table, List<org.apache.hadoop.hive.metastore.api.Partition>> readMetaData(FileSystem fs, Path metadataPath) throws IOException, SemanticException {
        FSDataInputStream mdstream = null;
        try {
            mdstream = fs.open(metadataPath);
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream sb = new ByteArrayOutputStream();
            int read = mdstream.read(buffer);
            while (read != -1) {
                sb.write(buffer, 0, read);
                read = mdstream.read(buffer);
            }
            String md = new String(sb.toByteArray(), "UTF-8");
            JSONObject jsonContainer = new JSONObject(md);
            String version = jsonContainer.getString("version");
            String fcversion = null;
            try {
                fcversion = jsonContainer.getString("fcversion");
            }
            catch (JSONException ignored) {
                // empty catch block
            }
            EximUtil.checkCompatibility(version, fcversion);
            String tableDesc = jsonContainer.getString("table");
            org.apache.hadoop.hive.metastore.api.Table table = new org.apache.hadoop.hive.metastore.api.Table();
            TDeserializer deserializer = new TDeserializer(new TJSONProtocol.Factory());
            deserializer.deserialize((TBase)table, tableDesc, "UTF-8");
            JSONArray jsonPartitions = new JSONArray(jsonContainer.getString("partitions"));
            ArrayList<org.apache.hadoop.hive.metastore.api.Partition> partitionsList = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>(jsonPartitions.length());
            for (int i = 0; i < jsonPartitions.length(); ++i) {
                String partDesc = jsonPartitions.getString(i);
                org.apache.hadoop.hive.metastore.api.Partition partition = new org.apache.hadoop.hive.metastore.api.Partition();
                deserializer.deserialize((TBase)partition, partDesc, "UTF-8");
                partitionsList.add(partition);
            }
            AbstractMap.SimpleEntry<org.apache.hadoop.hive.metastore.api.Table, List<org.apache.hadoop.hive.metastore.api.Partition>> simpleEntry = new AbstractMap.SimpleEntry<org.apache.hadoop.hive.metastore.api.Table, List<org.apache.hadoop.hive.metastore.api.Partition>>(table, partitionsList);
            return simpleEntry;
        }
        catch (JSONException e) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg("Error in serializing metadata"), e);
        }
        catch (TException e) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg("Error in serializing metadata"), e);
        }
        finally {
            if (mdstream != null) {
                mdstream.close();
            }
        }
    }

    private static void checkCompatibility(String version, String fcVersion) throws SemanticException {
        EximUtil.doCheckCompatibility(METADATA_FORMAT_VERSION, version, fcVersion);
    }

    public static void doCheckCompatibility(String currVersion, String version, String fcVersion) throws SemanticException {
        if (version == null) {
            throw new SemanticException(ErrorMsg.INVALID_METADATA.getMsg("Version number missing"));
        }
        StringTokenizer st = new StringTokenizer(version, ".");
        int data_major = Integer.parseInt(st.nextToken());
        StringTokenizer st2 = new StringTokenizer(currVersion, ".");
        int code_major = Integer.parseInt(st2.nextToken());
        int code_minor = Integer.parseInt(st2.nextToken());
        if (code_major > data_major) {
            throw new SemanticException(ErrorMsg.INVALID_METADATA.getMsg("Not backward compatible. Producer version " + version + ", Consumer version " + currVersion));
        }
        if (fcVersion == null || fcVersion.isEmpty()) {
            if (code_major < data_major) {
                throw new SemanticException(ErrorMsg.INVALID_METADATA.getMsg("Not forward compatible.Producer version " + version + ", Consumer version " + currVersion));
            }
        } else {
            StringTokenizer st3 = new StringTokenizer(fcVersion, ".");
            int fc_major = Integer.parseInt(st3.nextToken());
            int fc_minor = Integer.parseInt(st3.nextToken());
            if (fc_major > code_major || fc_major == code_major && fc_minor > code_minor) {
                throw new SemanticException(ErrorMsg.INVALID_METADATA.getMsg("Not forward compatible.Minimum version " + fcVersion + ", Consumer version " + currVersion));
            }
        }
    }

    public static Map<String, String> makePartSpec(List<FieldSchema> partCols, List<String> partVals) {
        TreeMap<String, String> partSpec = new TreeMap<String, String>();
        for (int i = 0; i < partCols.size(); ++i) {
            partSpec.put(partCols.get(i).getName(), partVals.get(i));
        }
        return partSpec;
    }

    public static boolean schemaCompare(List<FieldSchema> newSchema, List<FieldSchema> oldSchema) {
        Iterator<FieldSchema> newColIter = newSchema.iterator();
        for (FieldSchema oldCol : oldSchema) {
            FieldSchema newCol = null;
            if (!newColIter.hasNext()) {
                return false;
            }
            newCol = newColIter.next();
            if (oldCol.getName().equals(newCol.getName()) && oldCol.getType().equals(newCol.getType())) continue;
            return false;
        }
        return !newColIter.hasNext();
    }
}

