/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ParameterizedPrimitiveTypeUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeParams;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class RegexSerDe
extends AbstractSerDe {
    public static final Log LOG = LogFactory.getLog((String)RegexSerDe.class.getName());
    int numColumns;
    String inputRegex;
    Pattern inputPattern;
    StructObjectInspector rowOI;
    List<Object> row;
    List<TypeInfo> columnTypes;
    Object[] outputFields;
    Text outputRowText;
    boolean alreadyLoggedNoMatch = false;
    boolean alreadyLoggedPartialMatch = false;
    long unmatchedRowsCount = 0L;
    long partialMatchedRowsCount = 0L;

    @Override
    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        int c;
        this.inputRegex = tbl.getProperty("input.regex");
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        boolean inputRegexIgnoreCase = "true".equalsIgnoreCase(tbl.getProperty("input.regex.case.insensitive"));
        if (null != tbl.getProperty("output.format.string")) {
            LOG.warn((Object)"output.format.string has been deprecated");
        }
        if (this.inputRegex == null) {
            this.inputPattern = null;
            throw new SerDeException("This table does not have serde property \"input.regex\"!");
        }
        this.inputPattern = Pattern.compile(this.inputRegex, 32 + (inputRegexIgnoreCase ? 2 : 0));
        List<String> columnNames = Arrays.asList(columnNameProperty.split(","));
        this.columnTypes = TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        assert (columnNames.size() == this.columnTypes.size());
        this.numColumns = columnNames.size();
        ArrayList<ObjectInspector> columnOIs = new ArrayList<ObjectInspector>(columnNames.size());
        for (c = 0; c < this.numColumns; ++c) {
            TypeInfo typeInfo = this.columnTypes.get(c);
            String typeName = typeInfo.getTypeName();
            if (typeName.equals("string")) {
                columnOIs.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
                continue;
            }
            if (typeName.equals("tinyint")) {
                columnOIs.add(PrimitiveObjectInspectorFactory.javaByteObjectInspector);
                continue;
            }
            if (typeName.equals("smallint")) {
                columnOIs.add(PrimitiveObjectInspectorFactory.javaShortObjectInspector);
                continue;
            }
            if (typeName.equals("int")) {
                columnOIs.add(PrimitiveObjectInspectorFactory.javaIntObjectInspector);
                continue;
            }
            if (typeName.equals("bigint")) {
                columnOIs.add(PrimitiveObjectInspectorFactory.javaLongObjectInspector);
                continue;
            }
            if (typeName.equals("float")) {
                columnOIs.add(PrimitiveObjectInspectorFactory.javaFloatObjectInspector);
                continue;
            }
            if (typeName.equals("double")) {
                columnOIs.add(PrimitiveObjectInspectorFactory.javaDoubleObjectInspector);
                continue;
            }
            if (typeName.equals("boolean")) {
                columnOIs.add(PrimitiveObjectInspectorFactory.javaBooleanObjectInspector);
                continue;
            }
            if (typeName.equals("timestamp")) {
                columnOIs.add(PrimitiveObjectInspectorFactory.javaTimestampObjectInspector);
                continue;
            }
            if (typeName.equals("date")) {
                columnOIs.add(PrimitiveObjectInspectorFactory.javaDateObjectInspector);
                continue;
            }
            if (typeName.equals("decimal")) {
                columnOIs.add(PrimitiveObjectInspectorFactory.javaHiveDecimalObjectInspector);
                continue;
            }
            if (typeInfo instanceof PrimitiveTypeInfo && ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR) {
                VarcharTypeParams varcharParams = (VarcharTypeParams)ParameterizedPrimitiveTypeUtils.getTypeParamsFromTypeInfo(typeInfo);
                columnOIs.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)typeInfo));
                continue;
            }
            throw new SerDeException(this.getClass().getName() + " doesn't allow column [" + c + "] named " + columnNames.get(c) + " with type " + this.columnTypes.get(c));
        }
        this.rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, columnOIs);
        this.row = new ArrayList<Object>(this.numColumns);
        for (c = 0; c < this.numColumns; ++c) {
            this.row.add(null);
        }
        this.outputFields = new Object[this.numColumns];
        this.outputRowText = new Text();
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowOI;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    @Override
    public Object deserialize(Writable blob) throws SerDeException {
        Text rowText = (Text)blob;
        Matcher m = this.inputPattern.matcher(rowText.toString());
        if (m.groupCount() != this.numColumns) {
            throw new SerDeException("Number of matching groups doesn't match the number of columns");
        }
        if (!m.matches()) {
            ++this.unmatchedRowsCount;
            if (!this.alreadyLoggedNoMatch) {
                LOG.warn((Object)("" + this.unmatchedRowsCount + " unmatched rows are found: " + rowText));
                this.alreadyLoggedNoMatch = true;
            }
            return null;
        }
        for (int c = 0; c < this.numColumns; ++c) {
            try {
                Comparable<Double> d;
                Comparable<Byte> b;
                String t = m.group(c + 1);
                TypeInfo typeInfo = this.columnTypes.get(c);
                String typeName = typeInfo.getTypeName();
                if (typeName.equals("string")) {
                    this.row.set(c, t);
                    continue;
                }
                if (typeName.equals("tinyint")) {
                    b = Byte.valueOf(t);
                    this.row.set(c, b);
                    continue;
                }
                if (typeName.equals("smallint")) {
                    Short s = Short.valueOf(t);
                    this.row.set(c, s);
                    continue;
                }
                if (typeName.equals("int")) {
                    Integer i = Integer.valueOf(t);
                    this.row.set(c, i);
                    continue;
                }
                if (typeName.equals("bigint")) {
                    Long l = Long.valueOf(t);
                    this.row.set(c, l);
                    continue;
                }
                if (typeName.equals("float")) {
                    Float f = Float.valueOf(t);
                    this.row.set(c, f);
                    continue;
                }
                if (typeName.equals("double")) {
                    d = Double.valueOf(t);
                    this.row.set(c, d);
                    continue;
                }
                if (typeName.equals("boolean")) {
                    b = Boolean.valueOf(t);
                    this.row.set(c, b);
                    continue;
                }
                if (typeName.equals("timestamp")) {
                    Timestamp ts = Timestamp.valueOf(t);
                    this.row.set(c, ts);
                    continue;
                }
                if (typeName.equals("date")) {
                    d = Date.valueOf(t);
                    this.row.set(c, d);
                    continue;
                }
                if (typeName.equals("decimal")) {
                    HiveDecimal bd = new HiveDecimal(t);
                    this.row.set(c, bd);
                    continue;
                }
                if (!(typeInfo instanceof PrimitiveTypeInfo) || ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.VARCHAR) continue;
                VarcharTypeParams varcharParams = (VarcharTypeParams)ParameterizedPrimitiveTypeUtils.getTypeParamsFromTypeInfo(typeInfo);
                HiveVarchar hv = new HiveVarchar(t, varcharParams != null ? varcharParams.length : -1);
                this.row.set(c, hv);
                continue;
            }
            catch (RuntimeException e) {
                ++this.partialMatchedRowsCount;
                if (!this.alreadyLoggedPartialMatch) {
                    LOG.warn((Object)("" + this.partialMatchedRowsCount + " partially unmatched rows are found, " + " cannot find group " + c + ": " + rowText));
                    this.alreadyLoggedPartialMatch = true;
                }
                this.row.set(c, null);
            }
        }
        return this.row;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        throw new UnsupportedOperationException("Regex SerDe doesn't support the serialize() method");
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }
}

