/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive;

import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveVarchar;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.AbstractPrimitiveLazyObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ParameterizedPrimitiveTypeUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeParams;

public class LazyHiveVarcharObjectInspector
extends AbstractPrimitiveLazyObjectInspector<HiveVarcharWritable>
implements HiveVarcharObjectInspector {
    public LazyHiveVarcharObjectInspector(PrimitiveObjectInspectorUtils.PrimitiveTypeEntry typeEntry) {
        super(typeEntry);
        if (typeEntry.primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.VARCHAR) {
            throw new RuntimeException("TypeEntry of type varchar expected, got " + (Object)((Object)typeEntry.primitiveCategory));
        }
    }

    @Override
    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        LazyHiveVarchar ret = new LazyHiveVarchar(this);
        ret.setValue((LazyHiveVarchar)o);
        return ret;
    }

    @Override
    public HiveVarchar getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        HiveVarchar ret = ((HiveVarcharWritable)((LazyHiveVarchar)o).getWritableObject()).getHiveVarchar();
        if (!ParameterizedPrimitiveTypeUtils.doesPrimitiveMatchTypeParams(ret, (VarcharTypeParams)this.typeParams)) {
            HiveVarchar newValue = new HiveVarchar(ret, ((VarcharTypeParams)this.typeParams).length);
            return newValue;
        }
        return ret;
    }

    public String toString() {
        return this.getTypeName();
    }
}

