/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ParameterizedPrimitiveTypeUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeParams;

public class WritableHiveVarcharObjectInspector
extends AbstractPrimitiveWritableObjectInspector
implements SettableHiveVarcharObjectInspector {
    private static final Log LOG = LogFactory.getLog(WritableHiveVarcharObjectInspector.class);

    public WritableHiveVarcharObjectInspector(PrimitiveObjectInspectorUtils.PrimitiveTypeEntry typeEntry) {
        super(typeEntry);
        if (typeEntry.primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.VARCHAR) {
            throw new RuntimeException("TypeEntry of type varchar expected, got " + (Object)((Object)typeEntry.primitiveCategory));
        }
    }

    @Override
    public HiveVarchar getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        HiveVarcharWritable writable = (HiveVarcharWritable)o;
        if (this.doesWritableMatchTypeParams(writable)) {
            return writable.getHiveVarchar();
        }
        return this.getPrimitiveWithParams(writable);
    }

    @Override
    public HiveVarcharWritable getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        HiveVarcharWritable writable = (HiveVarcharWritable)o;
        if (this.doesWritableMatchTypeParams((HiveVarcharWritable)o)) {
            return writable;
        }
        return this.getWritableWithParams(writable);
    }

    private HiveVarchar getPrimitiveWithParams(HiveVarcharWritable val) {
        HiveVarchar hv = new HiveVarchar();
        hv.setValue(val.getHiveVarchar(), this.getMaxLength());
        return hv;
    }

    private HiveVarcharWritable getWritableWithParams(HiveVarcharWritable val) {
        HiveVarcharWritable newValue = new HiveVarcharWritable();
        newValue.set(val, this.getMaxLength());
        return newValue;
    }

    private boolean doesWritableMatchTypeParams(HiveVarcharWritable writable) {
        return ParameterizedPrimitiveTypeUtils.doesWritableMatchTypeParams(writable, (VarcharTypeParams)this.typeParams);
    }

    private boolean doesPrimitiveMatchTypeParams(HiveVarchar value) {
        return ParameterizedPrimitiveTypeUtils.doesPrimitiveMatchTypeParams(value, (VarcharTypeParams)this.typeParams);
    }

    @Override
    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        HiveVarcharWritable writable = (HiveVarcharWritable)o;
        if (this.doesWritableMatchTypeParams((HiveVarcharWritable)o)) {
            return new HiveVarcharWritable(writable);
        }
        return this.getWritableWithParams(writable);
    }

    @Override
    public Object set(Object o, HiveVarchar value) {
        HiveVarcharWritable writable = (HiveVarcharWritable)o;
        writable.set(value, this.getMaxLength());
        return o;
    }

    @Override
    public Object set(Object o, String value) {
        HiveVarcharWritable writable = (HiveVarcharWritable)o;
        writable.set(value, this.getMaxLength());
        return o;
    }

    @Override
    public Object create(HiveVarchar value) {
        HiveVarcharWritable ret = new HiveVarcharWritable();
        ret.set(value, this.getMaxLength());
        return ret;
    }

    public int getMaxLength() {
        return this.typeParams != null ? ((VarcharTypeParams)this.typeParams).length : -1;
    }
}

