/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.SkewJoinHandler;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.LongWritable;

public class JoinOperator
extends CommonJoinOperator<JoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient SkewJoinHandler skewJoinKeyContext = null;
    private final transient LongWritable skewjoin_followup_jobs = new LongWritable(0L);

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.initializeChildren(hconf);
        if (this.handleSkewJoin) {
            this.skewJoinKeyContext = new SkewJoinHandler(this);
            this.skewJoinKeyContext.initiliaze(hconf);
            this.skewJoinKeyContext.setSkewJoinJobCounter(this.skewjoin_followup_jobs);
        }
        this.statsMap.put(SkewkeyTableCounter.SKEWJOINFOLLOWUPJOBS.toString(), this.skewjoin_followup_jobs);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            StructObjectInspector inspector;
            this.reportProgress();
            this.lastAlias = this.alias;
            this.alias = (byte)tag;
            if (!this.alias.equals(this.lastAlias)) {
                this.nextSz = this.joinEmitInterval;
            }
            List<Object> nr = this.getFilteredValue(this.alias, row);
            if (this.handleSkewJoin) {
                this.skewJoinKeyContext.handleSkew(tag);
            }
            long sz = this.storage[this.alias].rowCount();
            StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[tag];
            StructField sf = soi.getStructFieldRef(Utilities.ReduceField.KEY.toString());
            List keyObject = (List)soi.getStructFieldData(row, sf);
            if (!(this.alias != this.numAliases - 1 || this.handleSkewJoin && this.skewJoinKeyContext.currBigKeyTag >= 0 || this.hasLeftSemiJoin)) {
                if (sz == (long)this.joinEmitInterval && !this.hasFilter(this.alias.byteValue())) {
                    this.checkAndGenObject();
                    this.storage[this.alias].clearRows();
                }
            } else if (sz == this.nextSz) {
                LOG.info((Object)("table " + this.alias + " has " + sz + " rows for join key " + keyObject));
                this.nextSz = this.getNextSize(this.nextSz);
            }
            if (SerDeUtils.hasAnyNullObject(keyObject, inspector = (StructObjectInspector)sf.getFieldObjectInspector(), this.nullsafes)) {
                this.endGroup();
                this.startGroup();
            }
            this.storage[this.alias].addRow(nr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.JOIN;
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.handleSkewJoin) {
            this.skewJoinKeyContext.close(abort);
        }
        super.closeOp(abort);
    }

    @Override
    public void jobCloseOp(Configuration hconf, boolean success) throws HiveException {
        int numAliases = ((JoinDesc)this.conf).getExprs().size();
        if (((JoinDesc)this.conf).getHandleSkewJoin()) {
            try {
                int j;
                Path specPath;
                int i;
                for (i = 0; i < numAliases; ++i) {
                    specPath = ((JoinDesc)this.conf).getBigKeysDirMap().get((byte)i);
                    this.mvFileToFinalPath(specPath, hconf, success, LOG);
                    for (j = 0; j < numAliases; ++j) {
                        if (j == i) continue;
                        specPath = ((JoinDesc)this.getConf()).getSmallKeysDirMap().get((byte)i).get((byte)j);
                        this.mvFileToFinalPath(specPath, hconf, success, LOG);
                    }
                }
                if (success) {
                    for (i = 0; i < numAliases; ++i) {
                        specPath = ((JoinDesc)this.conf).getBigKeysDirMap().get((byte)i);
                        this.moveUpFiles(specPath, hconf, LOG);
                        for (j = 0; j < numAliases; ++j) {
                            if (j == i) continue;
                            specPath = ((JoinDesc)this.getConf()).getSmallKeysDirMap().get((byte)i).get((byte)j);
                            this.moveUpFiles(specPath, hconf, LOG);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        }
        super.jobCloseOp(hconf, success);
    }

    private void moveUpFiles(Path specPath, Configuration hconf, Log log) throws IOException, HiveException {
        FileStatus[] taskOutputDirs;
        FileSystem fs = specPath.getFileSystem(hconf);
        if (fs.exists(specPath) && (taskOutputDirs = fs.listStatus(specPath)) != null) {
            for (FileStatus dir : taskOutputDirs) {
                Utilities.renameOrMoveFiles(fs, dir.getPath(), specPath);
                fs.delete(dir.getPath(), true);
            }
        }
    }

    private void mvFileToFinalPath(Path specPath, Configuration hconf, boolean success, Log log) throws IOException, HiveException {
        FileSystem fs = specPath.getFileSystem(hconf);
        Path tmpPath = Utilities.toTempPath(specPath);
        Path intermediatePath = new Path(tmpPath.getParent(), tmpPath.getName() + ".intermediate");
        if (success) {
            if (fs.exists(tmpPath)) {
                log.info((Object)("Moving tmp dir: " + tmpPath + " to: " + intermediatePath));
                Utilities.rename(fs, tmpPath, intermediatePath);
                Utilities.removeTempOrDuplicateFiles(fs, intermediatePath);
                log.info((Object)("Moving tmp dir: " + intermediatePath + " to: " + specPath));
                Utilities.renameOrMoveFiles(fs, intermediatePath, specPath);
            }
        } else {
            fs.delete(tmpPath, true);
        }
    }

    @Override
    public void endGroup() throws HiveException {
        if (this.handleSkewJoin && this.skewJoinKeyContext.currBigKeyTag >= 0) {
            try {
                this.skewJoinKeyContext.endGroup();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new HiveException(e);
            }
            return;
        }
        this.checkAndGenObject();
    }

    @Override
    public boolean supportSkewJoinOptimization() {
        return false;
    }

    @Override
    public boolean opAllowedBeforeSortMergeJoin() {
        return false;
    }

    public static enum SkewkeyTableCounter {
        SKEWJOINFOLLOWUPJOBS;

    }
}

