/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.AbstractFileMergeOperator;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcFileKeyWrapper;
import org.apache.hadoop.hive.ql.io.orc.OrcFileValueWrapper;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OrcFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.shims.CombineHiveKey;

public class OrcFileMergeOperator
extends AbstractFileMergeOperator<OrcFileMergeDesc> {
    public static final Log LOG = LogFactory.getLog((String)"OrcFileMergeOperator");
    CompressionKind compression = null;
    long compressBuffSize = 0L;
    OrcFile.Version version;
    int columnCount = 0;
    int rowIndexStride = 0;
    Writer outWriter;
    Path prevPath;
    private Reader reader;
    private FSDataInputStream fdis;

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        Object[] keyValue = (Object[])row;
        this.processKeyValuePairs(keyValue[0], keyValue[1]);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processKeyValuePairs(Object key, Object value) throws HiveException {
        OrcFileValueWrapper v;
        OrcFileKeyWrapper k;
        String filePath;
        block24: {
            filePath = "";
            k = key instanceof CombineHiveKey ? (OrcFileKeyWrapper)((CombineHiveKey)key).getKey() : (OrcFileKeyWrapper)key;
            filePath = k.getInputPath().toUri().getPath();
            this.fixTmpPath(k.getInputPath().getParent());
            v = (OrcFileValueWrapper)value;
            if (this.prevPath == null) {
                this.prevPath = k.getInputPath();
                this.reader = OrcFile.createReader(this.fs, k.getInputPath());
                LOG.info((Object)("ORC merge file input path: " + k.getInputPath()));
            }
            if (this.outWriter == null) {
                this.compression = k.getCompression();
                this.compressBuffSize = k.getCompressBufferSize();
                this.version = k.getVersion();
                this.columnCount = k.getTypes().get(0).getSubtypesCount();
                this.rowIndexStride = k.getRowIndexStride();
                this.outWriter = OrcFile.createWriter(this.outPath, OrcFile.writerOptions((Configuration)this.jc).compress(this.compression).version(this.version).rowIndexStride(this.rowIndexStride).inspector(this.reader.getObjectInspector()));
                LOG.info((Object)("ORC merge file output path: " + this.outPath));
            }
            if (this.checkCompatibility(k)) break block24;
            this.incompatFileSet.add(k.getInputPath());
            if (this.fdis == null) return;
            try {
                this.fdis.close();
                return;
            }
            catch (IOException e) {
                throw new HiveException(String.format("Unable to close file %s", filePath), e);
            }
            finally {
                this.fdis = null;
            }
        }
        if (!k.getInputPath().equals((Object)this.prevPath)) {
            this.reader = OrcFile.createReader(this.fs, k.getInputPath());
        }
        byte[] buffer = new byte[(int)v.getStripeInformation().getLength()];
        this.fdis = this.fs.open(k.getInputPath());
        this.fdis.readFully(v.getStripeInformation().getOffset(), buffer, 0, (int)v.getStripeInformation().getLength());
        this.outWriter.appendStripe(buffer, 0, buffer.length, v.getStripeInformation(), v.getStripeStatistics());
        LOG.info((Object)("Merged stripe from file " + k.getInputPath() + " [ offset : " + v.getStripeInformation().getOffset() + " length: " + v.getStripeInformation().getLength() + " ]"));
        if (v.isLastStripeInFile()) {
            this.outWriter.appendUserMetadata(v.getUserMetadata());
        }
        if (this.fdis == null) return;
        try {
            this.fdis.close();
            return;
        }
        catch (IOException e) {
            throw new HiveException(String.format("Unable to close file %s", filePath), e);
        }
        finally {
            this.fdis = null;
        }
        catch (Throwable e) {
            try {
                this.exception = true;
                this.closeOp(true);
                throw new HiveException(e);
            }
            catch (Throwable throwable) {
                if (this.fdis == null) throw throwable;
                try {
                    this.fdis.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new HiveException(String.format("Unable to close file %s", filePath), e2);
                }
                finally {
                    this.fdis = null;
                }
            }
        }
    }

    private boolean checkCompatibility(OrcFileKeyWrapper k) {
        if (k.getTypes().get(0).getSubtypesCount() != this.columnCount) {
            LOG.info((Object)("Incompatible ORC file merge! Column counts does not match for " + k.getInputPath()));
            return false;
        }
        if (!k.getCompression().equals((Object)this.compression)) {
            LOG.info((Object)("Incompatible ORC file merge! Compression codec does not match for " + k.getInputPath()));
            return false;
        }
        if (k.getCompressBufferSize() != this.compressBuffSize) {
            LOG.info((Object)("Incompatible ORC file merge! Compression buffer size does not match for " + k.getInputPath()));
            return false;
        }
        if (!k.getVersion().equals((Object)this.version)) {
            LOG.info((Object)("Incompatible ORC file merge! Version does not match for " + k.getInputPath()));
            return false;
        }
        if (k.getRowIndexStride() != this.rowIndexStride) {
            LOG.info((Object)("Incompatible ORC file merge! Row index stride does not match for " + k.getInputPath()));
            return false;
        }
        return true;
    }

    @Override
    public OperatorType getType() {
        return OperatorType.ORCFILEMERGE;
    }

    @Override
    public String getName() {
        return OrcFileMergeOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "OFM";
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.outWriter == null) {
            return;
        }
        try {
            if (this.fdis != null) {
                this.fdis.close();
                this.fdis = null;
            }
            this.outWriter.close();
            this.outWriter = null;
        }
        catch (IOException e) {
            throw new HiveException("Unable to close OrcFileMergeOperator", e);
        }
        super.closeOp(abort);
    }
}

