/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class VectorLimitOperator
extends LimitOperator {
    private static final long serialVersionUID = 1L;

    public VectorLimitOperator() {
    }

    public VectorLimitOperator(VectorizationContext vContext, OperatorDesc conf) {
        this.conf = (LimitDesc)conf;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)row;
        if (this.currCount < this.limit) {
            batch.size = Math.min(batch.size, this.limit - this.currCount);
            this.forward(row, this.inputObjInspectors[tag]);
            this.currCount += batch.size;
        } else {
            this.setDone(true);
        }
    }
}

