/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcFactory;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.UnionDesc;

public class GenMRUnion1
implements NodeProcessor {
    private Object processMapOnlyUnion(UnionOperator union, Stack<Node> stack, GenMRProcContext ctx, UnionProcContext uCtx) throws SemanticException {
        Task<? extends Serializable> uTask;
        Task<? extends Serializable> uTask2;
        GenMRProcContext.GenMRUnionCtx uCtxTask = ctx.getUnionTask(union);
        if (uCtxTask != null && (uTask2 = ctx.getUnionTask(union).getUTask()) != null) {
            if (ctx.getCurrTask() != null && ctx.getCurrTask() != uTask2) {
                ctx.getRootTasks().remove(ctx.getCurrTask());
            }
            ctx.setCurrTask(uTask2);
        }
        UnionProcContext.UnionParseContext uPrsCtx = uCtx.getUnionParseContext(union);
        ctx.getMapCurrCtx().put(union, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrAliasId()));
        uCtxTask = ctx.getUnionTask(union);
        if (uCtxTask == null) {
            uCtxTask = new GenMRProcContext.GenMRUnionCtx(ctx.getCurrTask());
            ctx.setUnionTask(union, uCtxTask);
        }
        if (((uTask = ctx.getCurrTask()).getParentTasks() == null || uTask.getParentTasks().isEmpty()) && !ctx.getRootTasks().contains(uTask)) {
            ctx.getRootTasks().add(uTask);
        }
        return true;
    }

    private void processSubQueryUnionCreateIntermediate(Operator<? extends OperatorDesc> parent, Operator<? extends OperatorDesc> child, Task<? extends Serializable> uTask, GenMRProcContext ctx, GenMRProcContext.GenMRUnionCtx uCtxTask) {
        ParseContext parseCtx = ctx.getParseCtx();
        TableDesc tt_desc = PlanUtils.getIntermediateFileTableDesc(PlanUtils.getFieldSchemasFromRowSchema(parent.getSchema(), "temporarycol"));
        Context baseCtx = parseCtx.getContext();
        Path taskTmpDir = baseCtx.getMRTmpPath();
        TableScanOperator tableScanOp = GenMapRedUtils.createTemporaryFile(parent, child, taskTmpDir, tt_desc, parseCtx);
        uCtxTask.addTaskTmpDir(taskTmpDir.toUri().toString());
        uCtxTask.addTTDesc(tt_desc);
        uCtxTask.addListTopOperators(tableScanOp);
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        currTask.addDependentTask(uTask);
        if (ctx.getRootTasks().contains(uTask)) {
            ctx.getRootTasks().remove(uTask);
            if (!ctx.getRootTasks().contains(currTask) && this.shouldBeRootTask(currTask)) {
                ctx.getRootTasks().add(currTask);
            }
        }
    }

    private void processSubQueryUnionMerge(GenMRProcContext ctx, GenMRProcContext.GenMRUnionCtx uCtxTask, UnionOperator union, Stack<Node> stack) throws SemanticException {
        Task<? extends Serializable> uTask = uCtxTask.getUTask();
        ctx.setCurrTask(uTask);
        Operator<? extends OperatorDesc> topOp = ctx.getCurrTopOp();
        if (topOp != null && !ctx.isSeenOp(uTask, topOp)) {
            GenMapRedUtils.setTaskPlan(ctx.getCurrAliasId(), ctx.getCurrTopOp(), uTask, false, ctx);
        }
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        UnionOperator union = (UnionOperator)nd;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        ParseContext parseCtx = ctx.getParseCtx();
        UnionProcContext uCtx = parseCtx.getUCtx();
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        if (((UnionDesc)union.getConf()).isAllInputsInSameReducer()) {
            mapCurrCtx.put((Operator)nd, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrAliasId()));
            return null;
        }
        UnionProcContext.UnionParseContext uPrsCtx = uCtx.getUnionParseContext(union);
        ctx.setCurrUnionOp(union);
        if (uPrsCtx.allMapOnlySubQ()) {
            return this.processMapOnlyUnion(union, stack, ctx, uCtx);
        }
        assert (uPrsCtx != null);
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        int pos = UnionProcFactory.getPositionParent(union, stack);
        Task<? extends Serializable> uTask = null;
        MapredWork uPlan = null;
        GenMRProcContext.GenMRUnionCtx uCtxTask = ctx.getUnionTask(union);
        if (uCtxTask == null) {
            uPlan = GenMapRedUtils.getMapRedWork(parseCtx);
            uTask = TaskFactory.get(uPlan, parseCtx.getConf(), new Task[0]);
            uCtxTask = new GenMRProcContext.GenMRUnionCtx(uTask);
            ctx.setUnionTask(union, uCtxTask);
        } else {
            uTask = uCtxTask.getUTask();
        }
        if (uPrsCtx.getMapOnlySubq(pos) && uPrsCtx.getRootTask(pos)) {
            this.processSubQueryUnionMerge(ctx, uCtxTask, union, stack);
            if (ctx.getRootTasks().contains(currTask)) {
                ctx.getRootTasks().remove(currTask);
            }
        } else {
            if (this.shouldBeRootTask(currTask) && !ctx.getRootTasks().contains(currTask) && (currTask.getParentTasks() == null || currTask.getParentTasks().isEmpty())) {
                ctx.getRootTasks().add(currTask);
            }
            this.processSubQueryUnionCreateIntermediate(union.getParentOperators().get(pos), union, uTask, ctx, uCtxTask);
            ctx.setCurrAliasId(null);
            ctx.setCurrTopOp(null);
            ctx.getOpTaskMap().put(null, uTask);
        }
        ctx.setCurrTask(uTask);
        mapCurrCtx.put((Operator)nd, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), null));
        return true;
    }

    private boolean shouldBeRootTask(Task<? extends Serializable> currTask) {
        return currTask.getParentTasks() == null || currTask.getParentTasks().size() == 0;
    }
}

