/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="greatest", value="_FUNC_(v1, v2, ...) - Returns the greatest value in a list of values", extended="Example:\n  > SELECT _FUNC_(2, 3, 1) FROM src LIMIT 1;\n  3")
public class GenericUDFGreatest
extends GenericUDF {
    private transient ObjectInspector[] argumentOIs;
    private transient GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException(this.getFuncName() + " requires at least 2 arguments, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException(this.getFuncName() + " only takes primitive types, got " + arguments[0].getTypeName());
        }
        this.argumentOIs = arguments;
        this.returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(false);
        for (int i = 0; i < arguments.length; ++i) {
            if (this.returnOIResolver.update(arguments[i])) continue;
            throw new UDFArgumentTypeException(i, "The expressions after " + this.getFuncName() + " should all have the same type: \"" + this.returnOIResolver.get().getTypeName() + "\" is expected but \"" + arguments[i].getTypeName() + "\" is found");
        }
        return this.returnOIResolver.get();
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Comparable maxV = null;
        int maxIndex = 0;
        for (int i = 0; i < arguments.length; ++i) {
            Object ai = arguments[i].get();
            if (ai == null) continue;
            Comparable v = (Comparable)ai;
            if (maxV == null) {
                maxV = v;
                maxIndex = i;
                continue;
            }
            if ((this.isGreatest() ? 1 : -1) * v.compareTo(maxV) <= 0) continue;
            maxV = v;
            maxIndex = i;
        }
        if (maxV != null) {
            return this.returnOIResolver.convertIfNecessary(maxV, this.argumentOIs[maxIndex]);
        }
        return null;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFuncName()).append("(");
        if (children.length > 0) {
            sb.append(children[0]);
            for (int i = 1; i < children.length; ++i) {
                sb.append(",");
                sb.append(children[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getFuncName() {
        return "greatest";
    }

    protected boolean isGreatest() {
        return true;
    }
}

