/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.DirectDecompressionCodec;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.iq80.snappy.Snappy;

class SnappyCodec
implements CompressionCodec,
DirectDecompressionCodec {
    Boolean direct = null;

    SnappyCodec() {
    }

    @Override
    public boolean compress(ByteBuffer in, ByteBuffer out, ByteBuffer overflow) throws IOException {
        int inBytes = in.remaining();
        byte[] compressed = new byte[Snappy.maxCompressedLength(inBytes)];
        int outBytes = Snappy.compress(in.array(), in.arrayOffset() + in.position(), inBytes, compressed, 0);
        if (outBytes < inBytes) {
            int remaining = out.remaining();
            if (remaining >= outBytes) {
                System.arraycopy(compressed, 0, out.array(), out.arrayOffset() + out.position(), outBytes);
                out.position(out.position() + outBytes);
            } else {
                System.arraycopy(compressed, 0, out.array(), out.arrayOffset() + out.position(), remaining);
                out.position(out.limit());
                System.arraycopy(compressed, remaining, overflow.array(), overflow.arrayOffset(), outBytes - remaining);
                overflow.position(outBytes - remaining);
            }
            return true;
        }
        return false;
    }

    @Override
    public void decompress(ByteBuffer in, ByteBuffer out) throws IOException {
        if (in.isDirect() && out.isDirect()) {
            this.directDecompress(in, out);
            return;
        }
        int inOffset = in.position();
        int uncompressLen = Snappy.uncompress(in.array(), in.arrayOffset() + inOffset, in.limit() - inOffset, out.array(), out.arrayOffset() + out.position());
        out.position(uncompressLen + out.position());
        out.flip();
    }

    @Override
    public boolean isAvailable() {
        if (this.direct == null) {
            try {
                this.direct = ShimLoader.getHadoopShims().getDirectDecompressor(HadoopShims.DirectCompressionType.SNAPPY) != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            catch (UnsatisfiedLinkError ule) {
                this.direct = false;
            }
        }
        return this.direct;
    }

    @Override
    public void directDecompress(ByteBuffer in, ByteBuffer out) throws IOException {
        HadoopShims.DirectDecompressorShim decompressShim = ShimLoader.getHadoopShims().getDirectDecompressor(HadoopShims.DirectCompressionType.SNAPPY);
        decompressShim.decompress(in, out);
        out.flip();
    }

    @Override
    public CompressionCodec modify(EnumSet<CompressionCodec.Modifier> modifiers) {
        return this;
    }
}

