/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveSchemaConverter;
import org.apache.hadoop.hive.ql.io.parquet.write.DataWritableWriteSupport;
import org.apache.hadoop.hive.ql.io.parquet.write.ParquetRecordWriterWrapper;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.util.Progressable;
import parquet.hadoop.ParquetOutputFormat;

public class MapredParquetOutputFormat
extends FileOutputFormat<Void, ParquetHiveRecord>
implements HiveOutputFormat<Void, ParquetHiveRecord> {
    private static final Log LOG = LogFactory.getLog(MapredParquetOutputFormat.class);
    protected ParquetOutputFormat<ParquetHiveRecord> realOutputFormat;

    public MapredParquetOutputFormat() {
        this.realOutputFormat = new ParquetOutputFormat(new DataWritableWriteSupport());
    }

    public MapredParquetOutputFormat(OutputFormat<Void, ParquetHiveRecord> mapreduceOutputFormat) {
        this.realOutputFormat = (ParquetOutputFormat)mapreduceOutputFormat;
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        this.realOutputFormat.checkOutputSpecs(ShimLoader.getHadoopShims().getHCatShim().createJobContext((Configuration)job, null));
    }

    public RecordWriter<Void, ParquetHiveRecord> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        throw new RuntimeException("Should never be used");
    }

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jobConf, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        LOG.info((Object)("creating new record writer..." + this));
        String columnNameProperty = tableProperties.getProperty("columns");
        String columnTypeProperty = tableProperties.getProperty("columns.types");
        List<Object> columnNames = columnNameProperty.length() == 0 ? new ArrayList() : Arrays.asList(columnNameProperty.split(","));
        ArrayList<TypeInfo> columnTypes = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        DataWritableWriteSupport.setSchema(HiveSchemaConverter.convert(columnNames, columnTypes), (Configuration)jobConf);
        return this.getParquerRecordWriterWrapper(this.realOutputFormat, jobConf, finalOutPath.toString(), progress, tableProperties);
    }

    protected ParquetRecordWriterWrapper getParquerRecordWriterWrapper(ParquetOutputFormat<ParquetHiveRecord> realOutputFormat, JobConf jobConf, String finalOutPath, Progressable progress, Properties tableProperties) throws IOException {
        return new ParquetRecordWriterWrapper((OutputFormat<Void, ParquetHiveRecord>)realOutputFormat, jobConf, finalOutPath.toString(), progress, tableProperties);
    }
}

