/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client.metrics;

import java.io.Serializable;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hive.spark.client.metrics.InputMetrics;
import org.apache.hive.spark.client.metrics.ShuffleReadMetrics;
import org.apache.hive.spark.client.metrics.ShuffleWriteMetrics;
import org.apache.spark.executor.TaskMetrics;

@InterfaceAudience.Private
public class Metrics
implements Serializable {
    public final long executorDeserializeTime;
    public final long executorRunTime;
    public final long resultSize;
    public final long jvmGCTime;
    public final long resultSerializationTime;
    public final long memoryBytesSpilled;
    public final long diskBytesSpilled;
    public final InputMetrics inputMetrics;
    public final ShuffleReadMetrics shuffleReadMetrics;
    public final ShuffleWriteMetrics shuffleWriteMetrics;

    private Metrics() {
        this(0L, 0L, 0L, 0L, 0L, 0L, 0L, null, null, null);
    }

    public Metrics(long executorDeserializeTime, long executorRunTime, long resultSize, long jvmGCTime, long resultSerializationTime, long memoryBytesSpilled, long diskBytesSpilled, InputMetrics inputMetrics, ShuffleReadMetrics shuffleReadMetrics, ShuffleWriteMetrics shuffleWriteMetrics) {
        this.executorDeserializeTime = executorDeserializeTime;
        this.executorRunTime = executorRunTime;
        this.resultSize = resultSize;
        this.jvmGCTime = jvmGCTime;
        this.resultSerializationTime = resultSerializationTime;
        this.memoryBytesSpilled = memoryBytesSpilled;
        this.diskBytesSpilled = diskBytesSpilled;
        this.inputMetrics = inputMetrics;
        this.shuffleReadMetrics = shuffleReadMetrics;
        this.shuffleWriteMetrics = shuffleWriteMetrics;
    }

    public Metrics(TaskMetrics metrics) {
        this(metrics.executorDeserializeTime(), metrics.executorRunTime(), metrics.resultSize(), metrics.jvmGCTime(), metrics.resultSerializationTime(), metrics.memoryBytesSpilled(), metrics.diskBytesSpilled(), Metrics.optionalInputMetric(metrics), Metrics.optionalShuffleReadMetric(metrics), Metrics.optionalShuffleWriteMetrics(metrics));
    }

    private static InputMetrics optionalInputMetric(TaskMetrics metrics) {
        return metrics.inputMetrics().isDefined() ? new InputMetrics(metrics) : null;
    }

    private static ShuffleReadMetrics optionalShuffleReadMetric(TaskMetrics metrics) {
        return metrics.shuffleReadMetrics().isDefined() ? new ShuffleReadMetrics(metrics) : null;
    }

    private static ShuffleWriteMetrics optionalShuffleWriteMetrics(TaskMetrics metrics) {
        return metrics.shuffleWriteMetrics().isDefined() ? new ShuffleWriteMetrics(metrics) : null;
    }
}

