/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public class IntervalDayTimeScalarAddDateColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private HiveIntervalDayTime value;
    private int outputColumn;
    private Timestamp scratchTimestamp2;
    private DateTimeMath dtm = new DateTimeMath();

    public IntervalDayTimeScalarAddDateColumn(HiveIntervalDayTime value, int colNum, int outputColumn) {
        this.colNum = colNum;
        this.value = value;
        this.outputColumn = outputColumn;
        this.scratchTimestamp2 = new Timestamp(0L);
    }

    public IntervalDayTimeScalarAddDateColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector2.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector2.noNulls;
        outputColVector.isRepeating = inputColVector2.isRepeating;
        int n = batch.size;
        long[] vector2 = inputColVector2.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector2.isRepeating) {
            this.scratchTimestamp2.setTime(DateWritable.daysToMillis((int)vector2[0]));
            this.dtm.add(this.value, this.scratchTimestamp2, outputColVector.getScratchTimestamp());
            outputColVector.setFromScratchTimestamp(0);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColVector2.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.scratchTimestamp2.setTime(DateWritable.daysToMillis((int)vector2[i]));
                    this.dtm.add(this.value, this.scratchTimestamp2, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.scratchTimestamp2.setTime(DateWritable.daysToMillis((int)vector2[i]));
                    this.dtm.add(this.value, this.scratchTimestamp2, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.scratchTimestamp2.setTime(DateWritable.daysToMillis((int)vector2[i]));
                this.dtm.add(this.value, this.scratchTimestamp2, outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(i);
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.scratchTimestamp2.setTime(DateWritable.daysToMillis((int)vector2[i]));
                this.dtm.add(this.value, this.scratchTimestamp2, outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(i);
            }
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
        }
        NullUtil.setNullOutputEntriesColScalar(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "timestamp";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("interval_day_time"), VectorExpressionDescriptor.ArgumentType.getType("date")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

