/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.util.DateTimeMath;

public class IntervalYearMonthScalarAddTimestampColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private HiveIntervalYearMonth value;
    private int outputColumn;
    private DateTimeMath dtm = new DateTimeMath();

    public IntervalYearMonthScalarAddTimestampColumn(long value, int colNum, int outputColumn) {
        this.colNum = colNum;
        this.value = new HiveIntervalYearMonth((int)value);
        this.outputColumn = outputColumn;
    }

    public IntervalYearMonthScalarAddTimestampColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector2 = (TimestampColumnVector)batch.cols[this.colNum];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector2.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector2.noNulls;
        outputColVector.isRepeating = inputColVector2.isRepeating;
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (inputColVector2.isRepeating) {
            this.dtm.add(this.value, inputColVector2.asScratchTimestamp(0), outputColVector.getScratchTimestamp());
            outputColVector.setFromScratchTimestamp(0);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColVector2.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.dtm.add(this.value, inputColVector2.asScratchTimestamp(i), outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.dtm.add(this.value, inputColVector2.asScratchTimestamp(i), outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.dtm.add(this.value, inputColVector2.asScratchTimestamp(i), outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(i);
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.dtm.add(this.value, inputColVector2.asScratchTimestamp(i), outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(i);
            }
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
        }
        NullUtil.setNullOutputEntriesColScalar(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "timestamp";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("interval_year_month"), VectorExpressionDescriptor.ArgumentType.getType("timestamp")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

