/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullRowsInputFormat
implements InputFormat<NullWritable, NullWritable>,
JobConfigurable,
VectorizedInputFormatInterface {
    static final int MAX_ROW = 100;
    static final Logger LOG = LoggerFactory.getLogger((String)NullRowsRecordReader.class.getName());

    public RecordReader<NullWritable, NullWritable> getRecordReader(InputSplit split, JobConf conf, Reporter arg2) throws IOException {
        return new NullRowsRecordReader((Configuration)conf, split);
    }

    public InputSplit[] getSplits(JobConf conf, int arg1) throws IOException {
        String[] paths = conf.getTrimmedStrings("mapreduce.input.fileinputformat.inputdir", (String[])null);
        if (paths == null) {
            throw new IOException("Cannot find path in conf");
        }
        InputSplit[] result = new InputSplit[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            result[i] = new DummyInputSplit(paths[i]);
        }
        return result;
    }

    public void configure(JobConf job) {
        LOG.info("Using null rows input format");
    }

    public static class NullRowsRecordReader
    implements RecordReader {
        private int counter;
        protected final VectorizedRowBatchCtx rbCtx;
        private final boolean[] columnsToIncludeTruncated;
        private final Object[] partitionValues;
        private boolean addPartitionCols = true;

        public NullRowsRecordReader(Configuration conf, InputSplit split) throws IOException {
            boolean isVectorMode = Utilities.getUseVectorizedInputFileFormat(conf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Null record reader in " + (isVectorMode ? "" : "non-") + "vector mode");
            }
            if (isVectorMode) {
                this.rbCtx = Utilities.getVectorizedRowBatchCtx(conf);
                this.columnsToIncludeTruncated = this.rbCtx.getColumnsToIncludeTruncated(conf);
                int partitionColumnCount = this.rbCtx.getPartitionColumnCount();
                if (partitionColumnCount > 0) {
                    this.partitionValues = new Object[partitionColumnCount];
                    VectorizedRowBatchCtx.getPartitionValues(this.rbCtx, conf, (FileSplit)split, this.partitionValues);
                } else {
                    this.partitionValues = null;
                }
            } else {
                this.rbCtx = null;
                this.columnsToIncludeTruncated = null;
                this.partitionValues = null;
            }
        }

        public void close() throws IOException {
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public Object createValue() {
            return this.rbCtx == null ? NullWritable.get() : this.rbCtx.createVectorizedRowBatch(this.columnsToIncludeTruncated);
        }

        public long getPos() throws IOException {
            return this.counter;
        }

        public float getProgress() throws IOException {
            return (float)this.counter / 100.0f;
        }

        public boolean next(Object arg0, Object value) throws IOException {
            if (this.rbCtx != null) {
                if (this.counter >= 100) {
                    return false;
                }
                this.makeNullVrb(value, 100);
                this.counter = 100;
                return true;
            }
            return this.counter++ < 100;
        }

        protected void makeNullVrb(Object value, int size) {
            VectorizedRowBatch vrb = (VectorizedRowBatch)value;
            if (this.addPartitionCols) {
                if (this.partitionValues != null) {
                    this.rbCtx.addPartitionColsToBatch(vrb, this.partitionValues);
                }
                this.addPartitionCols = false;
            }
            vrb.size = size;
            vrb.selectedInUse = false;
            for (int i = 0; i < this.rbCtx.getDataColumnCount(); ++i) {
                if (this.columnsToIncludeTruncated != null && (this.columnsToIncludeTruncated.length <= i || !this.columnsToIncludeTruncated[i])) continue;
                ColumnVector cv = vrb.cols[i];
                cv.noNulls = false;
                cv.isRepeating = true;
                cv.isNull[0] = true;
            }
        }
    }

    public static class DummyInputSplit
    extends FileSplit {
        private DummyInputSplit() {
        }

        public DummyInputSplit(String path) {
            super(new Path(path, "null"), 0L, 1L, (String[])null);
        }
    }
}

