/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;

class ASTBuilder {
    ASTNode curr;

    ASTBuilder() {
    }

    static ASTBuilder construct(int tokenType, String text) {
        ASTBuilder b = new ASTBuilder();
        b.curr = ASTBuilder.createAST(tokenType, text);
        return b;
    }

    static ASTNode createAST(int tokenType, String text) {
        return (ASTNode)ParseDriver.adaptor.create(tokenType, text);
    }

    static ASTNode destNode() {
        return ASTBuilder.construct(726, "TOK_DESTINATION").add(ASTBuilder.construct(727, "TOK_DIR").add(963, "TOK_TMP_FILE")).node();
    }

    static ASTNode table(TableScan scan) {
        RelOptHiveTable hTbl = (RelOptHiveTable)scan.getTable();
        ASTBuilder b = ASTBuilder.construct(954, "TOK_TABREF").add(ASTBuilder.construct(953, "TOK_TABNAME").add(26, hTbl.getHiveTableMD().getDbName()).add(26, hTbl.getHiveTableMD().getTableName()));
        if (((HiveTableScan)scan).isInsideView()) {
            b.add(ASTBuilder.construct(938, "TOK_TABLEPROPERTIES").add(ASTBuilder.construct(940, "TOK_TABLEPROPLIST").add(ASTBuilder.construct(939, "TOK_TABLEPROPERTY").add(332, "\"insideView\"").add(332, "\"TRUE\""))));
        }
        b.add(26, ((HiveTableScan)scan).getTableAlias());
        return b.node();
    }

    static ASTNode join(ASTNode left, ASTNode right, JoinRelType joinType, ASTNode cond, boolean semiJoin) {
        ASTBuilder b = null;
        switch (joinType) {
            case INNER: {
                if (semiJoin) {
                    b = ASTBuilder.construct(794, "TOK_LEFTSEMIJOIN");
                    break;
                }
                b = ASTBuilder.construct(790, "TOK_JOIN");
                break;
            }
            case LEFT: {
                b = ASTBuilder.construct(793, "TOK_LEFTOUTERJOIN");
                break;
            }
            case RIGHT: {
                b = ASTBuilder.construct(873, "TOK_RIGHTOUTERJOIN");
                break;
            }
            case FULL: {
                b = ASTBuilder.construct(749, "TOK_FULLOUTERJOIN");
            }
        }
        b.add(left).add(right).add(cond);
        return b.node();
    }

    static ASTNode subQuery(ASTNode qry, String alias) {
        return ASTBuilder.construct(919, "TOK_SUBQUERY").add(qry).add(26, alias).node();
    }

    static ASTNode qualifiedName(String tableName, String colName) {
        ASTBuilder b = ASTBuilder.construct(17, ".").add(ASTBuilder.construct(950, "TOK_TABLE_OR_COL").add(26, tableName)).add(26, colName);
        return b.node();
    }

    static ASTNode unqualifiedName(String colName) {
        ASTBuilder b = ASTBuilder.construct(950, "TOK_TABLE_OR_COL").add(26, colName);
        return b.node();
    }

    static ASTNode where(ASTNode cond) {
        return ASTBuilder.construct(988, "TOK_WHERE").add(cond).node();
    }

    static ASTNode having(ASTNode cond) {
        return ASTBuilder.construct(762, "TOK_HAVING").add(cond).node();
    }

    static ASTNode limit(Object offset, Object limit) {
        return ASTBuilder.construct(797, "TOK_LIMIT").add(321, offset.toString()).add(321, limit.toString()).node();
    }

    static ASTNode selectExpr(ASTNode expr, String alias) {
        return ASTBuilder.construct(880, "TOK_SELEXPR").add(expr).add(26, alias).node();
    }

    static ASTNode literal(RexLiteral literal) {
        return ASTBuilder.literal(literal, false);
    }

    static ASTNode literal(RexLiteral literal, boolean useTypeQualInLiteral) {
        Object val = null;
        int type = 0;
        SqlTypeName sqlType = literal.getType().getSqlTypeName();
        switch (sqlType) {
            case BINARY: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                if (literal.getValue() != null) break;
                return ASTBuilder.construct(811, "TOK_NULL").node();
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DOUBLE: 
            case DECIMAL: 
            case FLOAT: 
            case REAL: 
            case VARCHAR: 
            case CHAR: 
            case BOOLEAN: {
                if (literal.getValue3() != null) break;
                return ASTBuilder.construct(811, "TOK_NULL").node();
            }
        }
        switch (sqlType) {
            case TINYINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "Y" : literal.getValue3();
                type = 334;
                break;
            }
            case SMALLINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "S" : literal.getValue3();
                type = 331;
                break;
            }
            case INTEGER: {
                val = literal.getValue3();
                type = 7;
                break;
            }
            case BIGINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "L" : literal.getValue3();
                type = 7;
                break;
            }
            case DOUBLE: {
                val = literal.getValue3() + "D";
                type = 321;
                break;
            }
            case DECIMAL: {
                val = literal.getValue3() + "BD";
                type = 18;
                break;
            }
            case FLOAT: 
            case REAL: {
                val = literal.getValue3();
                type = 321;
                break;
            }
            case VARCHAR: 
            case CHAR: {
                val = literal.getValue3();
                String escapedVal = BaseSemanticAnalyzer.escapeSQLString(String.valueOf(val));
                type = 332;
                val = "'" + escapedVal + "'";
                break;
            }
            case BOOLEAN: {
                val = literal.getValue3();
                type = (Boolean)val != false ? 281 : 112;
                break;
            }
            case DATE: {
                val = literal.getValue();
                type = 716;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                val = df.format(((Calendar)val).getTime());
                val = "'" + val + "'";
                break;
            }
            case TIME: 
            case TIMESTAMP: {
                val = literal.getValue();
                type = 961;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                val = df.format(((Calendar)val).getTime());
                val = "'" + val + "'";
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                type = 784;
                BigDecimal monthsBd = (BigDecimal)literal.getValue();
                HiveIntervalYearMonth intervalYearMonth = new HiveIntervalYearMonth(monthsBd.intValue());
                val = "'" + intervalYearMonth.toString() + "'";
                break;
            }
            case INTERVAL_DAY_TIME: {
                type = 777;
                BigDecimal millisBd = (BigDecimal)literal.getValue();
                BigDecimal secsBd = millisBd.divide(BigDecimal.valueOf(1000L));
                HiveIntervalDayTime intervalDayTime = new HiveIntervalDayTime(secsBd);
                val = "'" + intervalDayTime.toString() + "'";
                break;
            }
            case NULL: {
                type = 811;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Type: " + sqlType);
            }
        }
        return (ASTNode)ParseDriver.adaptor.create(type, String.valueOf(val));
    }

    ASTNode node() {
        return this.curr;
    }

    ASTBuilder add(int tokenType, String text) {
        ParseDriver.adaptor.addChild((Object)this.curr, (Object)ASTBuilder.createAST(tokenType, text));
        return this;
    }

    ASTBuilder add(ASTBuilder b) {
        ParseDriver.adaptor.addChild((Object)this.curr, (Object)b.curr);
        return this;
    }

    ASTBuilder add(ASTNode n) {
        if (n != null) {
            ParseDriver.adaptor.addChild((Object)this.curr, (Object)n);
        }
        return this;
    }
}

