/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.mapred.JobConf;

@Explain(displayName="Map Reduce", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class MapredWork
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private MapWork mapWork = new MapWork();
    private ReduceWork reduceWork = null;
    private boolean finalMapRed;

    @Explain(skipHeader=true, displayName="Map", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public MapWork getMapWork() {
        return this.mapWork;
    }

    public void setMapWork(MapWork mapWork) {
        this.mapWork = mapWork;
    }

    @Explain(skipHeader=true, displayName="Reduce", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public ReduceWork getReduceWork() {
        return this.reduceWork;
    }

    public void setReduceWork(ReduceWork reduceWork) {
        this.reduceWork = reduceWork;
    }

    public boolean isFinalMapRed() {
        return this.finalMapRed;
    }

    public void setFinalMapRed(boolean finalMapRed) {
        this.finalMapRed = finalMapRed;
    }

    public void configureJobConf(JobConf job) {
        this.mapWork.configureJobConf(job);
        if (this.reduceWork != null) {
            this.reduceWork.configureJobConf(job);
        }
    }

    public List<Operator<?>> getAllOperators() {
        ArrayList ops = new ArrayList();
        ops.addAll(this.mapWork.getAllOperators());
        if (this.reduceWork != null) {
            ops.addAll(this.reduceWork.getAllOperators());
        }
        return ops;
    }

    public Operator<?> getAnyOperator() {
        Operator<? extends OperatorDesc> result = this.mapWork.getAnyRootOperator();
        if (result != null) {
            return result;
        }
        return this.reduceWork != null ? this.reduceWork.getAnyRootOperator() : null;
    }
}

