/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.io.Text;
import org.apache.orc.BinaryColumnStatistics;
import org.apache.orc.BloomFilterIO;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.impl.BitFieldWriter;
import org.apache.orc.impl.ColumnStatisticsImpl;
import org.apache.orc.impl.DynamicIntArray;
import org.apache.orc.impl.IntegerWriter;
import org.apache.orc.impl.MemoryManager;
import org.apache.orc.impl.OutStream;
import org.apache.orc.impl.PositionRecorder;
import org.apache.orc.impl.PositionedOutputStream;
import org.apache.orc.impl.RunLengthByteWriter;
import org.apache.orc.impl.RunLengthIntegerWriter;
import org.apache.orc.impl.RunLengthIntegerWriterV2;
import org.apache.orc.impl.SerializationUtils;
import org.apache.orc.impl.SnappyCodec;
import org.apache.orc.impl.StreamName;
import org.apache.orc.impl.StringRedBlackTree;
import org.apache.orc.impl.ZlibCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterImpl
implements Writer,
MemoryManager.Callback {
    private static final Logger LOG = LoggerFactory.getLogger(WriterImpl.class);
    private static final int HDFS_BUFFER_SIZE = 262144;
    private static final int MIN_ROW_INDEX_STRIDE = 1000;
    private static final int COLUMN_COUNT_THRESHOLD = 1000;
    private final FileSystem fs;
    private final Path path;
    private final long defaultStripeSize;
    private long adjustedStripeSize;
    private final int rowIndexStride;
    private final CompressionKind compress;
    private final CompressionCodec codec;
    private final boolean addBlockPadding;
    private final int bufferSize;
    private final long blockSize;
    private final double paddingTolerance;
    private final TypeDescription schema;
    private final Map<StreamName, BufferedStream> streams = new TreeMap<StreamName, BufferedStream>();
    private FSDataOutputStream rawWriter = null;
    private OutStream writer = null;
    private CodedOutputStream protobufWriter = null;
    private long headerLength;
    private int columnCount;
    private long rowCount = 0L;
    private long rowsInStripe = 0L;
    private long rawDataSize = 0L;
    private int rowsInIndex = 0;
    private int stripesAtLastFlush = -1;
    private final List<OrcProto.StripeInformation> stripes = new ArrayList<OrcProto.StripeInformation>();
    private final Map<String, ByteString> userMetadata = new TreeMap<String, ByteString>();
    private final StreamFactory streamFactory = new StreamFactory();
    private final TreeWriter treeWriter;
    private final boolean buildIndex;
    private final MemoryManager memoryManager;
    private final OrcFile.Version version;
    private final Configuration conf;
    private final OrcFile.WriterCallback callback;
    private final OrcFile.WriterContext callbackContext;
    private final OrcFile.EncodingStrategy encodingStrategy;
    private final OrcFile.CompressionStrategy compressionStrategy;
    private final boolean[] bloomFilterColumns;
    private final double bloomFilterFpp;
    private boolean writeTimeZone;
    public static long MILLIS_PER_DAY = 86400000L;
    public static long NANOS_PER_MILLI = 1000000L;
    public static final int MILLIS_PER_SECOND = 1000;
    static final int NANOS_PER_SECOND = 1000000000;
    public static final String BASE_TIMESTAMP_STRING = "2015-01-01 00:00:00";

    public WriterImpl(FileSystem fs, Path path, OrcFile.WriterOptions opts) throws IOException {
        this.fs = fs;
        this.path = path;
        this.conf = opts.getConfiguration();
        this.callback = opts.getCallback();
        this.schema = opts.getSchema();
        this.callbackContext = this.callback != null ? new OrcFile.WriterContext(){

            @Override
            public Writer getWriter() {
                return WriterImpl.this;
            }
        } : null;
        this.adjustedStripeSize = opts.getStripeSize();
        this.defaultStripeSize = opts.getStripeSize();
        this.version = opts.getVersion();
        this.encodingStrategy = opts.getEncodingStrategy();
        this.compressionStrategy = opts.getCompressionStrategy();
        this.addBlockPadding = opts.getBlockPadding();
        this.blockSize = opts.getBlockSize();
        this.paddingTolerance = opts.getPaddingTolerance();
        this.compress = opts.getCompress();
        this.rowIndexStride = opts.getRowIndexStride();
        this.memoryManager = opts.getMemoryManager();
        this.buildIndex = this.rowIndexStride > 0;
        this.codec = WriterImpl.createCodec(this.compress);
        int numColumns = this.schema.getMaximumId() + 1;
        this.bufferSize = opts.isEnforceBufferSize() ? opts.getBufferSize() : WriterImpl.getEstimatedBufferSize(this.defaultStripeSize, numColumns, opts.getBufferSize());
        this.bloomFilterColumns = this.version == OrcFile.Version.V_0_11 ? new boolean[this.schema.getMaximumId() + 1] : OrcUtils.includeColumns(opts.getBloomFilterColumns(), this.schema);
        this.bloomFilterFpp = opts.getBloomFilterFpp();
        this.treeWriter = WriterImpl.createTreeWriter(this.schema, this.streamFactory, false);
        if (this.buildIndex && this.rowIndexStride < 1000) {
            throw new IllegalArgumentException("Row stride must be at least 1000");
        }
        this.memoryManager.addWriter(path, opts.getStripeSize(), this);
        LOG.info("ORC writer created for path: {} with stripeSize: {} blockSize: {} compression: {} bufferSize: {}", new Object[]{path, this.defaultStripeSize, this.blockSize, this.compress, this.bufferSize});
    }

    @VisibleForTesting
    public static int getEstimatedBufferSize(long stripeSize, int numColumns, int bs) {
        int estBufferSize = (int)(stripeSize / (long)(20 * numColumns));
        return (estBufferSize = WriterImpl.getClosestBufferSize(estBufferSize)) > bs ? bs : estBufferSize;
    }

    private static int getClosestBufferSize(int estBufferSize) {
        int kb4 = 4096;
        int kb8 = 8192;
        int kb16 = 16384;
        int kb32 = 32768;
        int kb64 = 65536;
        int kb128 = 131072;
        int kb256 = 262144;
        if (estBufferSize <= 4096) {
            return 4096;
        }
        if (estBufferSize > 4096 && estBufferSize <= 8192) {
            return 8192;
        }
        if (estBufferSize > 8192 && estBufferSize <= 16384) {
            return 16384;
        }
        if (estBufferSize > 16384 && estBufferSize <= 32768) {
            return 32768;
        }
        if (estBufferSize > 32768 && estBufferSize <= 65536) {
            return 65536;
        }
        if (estBufferSize > 65536 && estBufferSize <= 131072) {
            return 131072;
        }
        return 262144;
    }

    public static CompressionCodec createCodec(CompressionKind kind) {
        switch (kind) {
            case NONE: {
                return null;
            }
            case ZLIB: {
                return new ZlibCodec();
            }
            case SNAPPY: {
                return new SnappyCodec();
            }
            case LZO: {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    if (loader == null) {
                        loader = WriterImpl.class.getClassLoader();
                    }
                    Class<?> lzo = loader.loadClass("org.apache.hadoop.hive.ql.io.orc.LzoCodec");
                    return (CompressionCodec)lzo.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("LZO is not available.", e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Problem initializing LZO", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Insufficient access to LZO", e);
                }
            }
        }
        throw new IllegalArgumentException("Unknown compression codec: " + (Object)((Object)kind));
    }

    @Override
    public boolean checkMemory(double newScale) throws IOException {
        long limit = Math.round((double)this.adjustedStripeSize * newScale);
        long size = this.estimateStripeSize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ORC writer " + this.path + " size = " + size + " limit = " + limit);
        }
        if (size > limit) {
            this.flushStripe();
            return true;
        }
        return false;
    }

    private static TreeWriter createTreeWriter(TypeDescription schema, StreamFactory streamFactory, boolean nullable) throws IOException {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return new BooleanTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case BYTE: {
                return new ByteTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case SHORT: 
            case INT: 
            case LONG: {
                return new IntegerTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case FLOAT: {
                return new FloatTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case DOUBLE: {
                return new DoubleTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case STRING: {
                return new StringTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case CHAR: {
                return new CharTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case VARCHAR: {
                return new VarcharTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case BINARY: {
                return new BinaryTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case TIMESTAMP: {
                return new TimestampTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case DATE: {
                return new DateTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case DECIMAL: {
                return new DecimalTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case STRUCT: {
                return new StructTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case MAP: {
                return new MapTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case LIST: {
                return new ListTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
            case UNION: {
                return new UnionTreeWriter(streamFactory.getNextColumnId(), schema, streamFactory, nullable);
            }
        }
        throw new IllegalArgumentException("Bad category: " + (Object)((Object)schema.getCategory()));
    }

    private static void writeTypes(OrcProto.Footer.Builder builder, TypeDescription schema) {
        OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
        List<TypeDescription> children = schema.getChildren();
        switch (schema.getCategory()) {
            case BOOLEAN: {
                type.setKind(OrcProto.Type.Kind.BOOLEAN);
                break;
            }
            case BYTE: {
                type.setKind(OrcProto.Type.Kind.BYTE);
                break;
            }
            case SHORT: {
                type.setKind(OrcProto.Type.Kind.SHORT);
                break;
            }
            case INT: {
                type.setKind(OrcProto.Type.Kind.INT);
                break;
            }
            case LONG: {
                type.setKind(OrcProto.Type.Kind.LONG);
                break;
            }
            case FLOAT: {
                type.setKind(OrcProto.Type.Kind.FLOAT);
                break;
            }
            case DOUBLE: {
                type.setKind(OrcProto.Type.Kind.DOUBLE);
                break;
            }
            case STRING: {
                type.setKind(OrcProto.Type.Kind.STRING);
                break;
            }
            case CHAR: {
                type.setKind(OrcProto.Type.Kind.CHAR);
                type.setMaximumLength(schema.getMaxLength());
                break;
            }
            case VARCHAR: {
                type.setKind(OrcProto.Type.Kind.VARCHAR);
                type.setMaximumLength(schema.getMaxLength());
                break;
            }
            case BINARY: {
                type.setKind(OrcProto.Type.Kind.BINARY);
                break;
            }
            case TIMESTAMP: {
                type.setKind(OrcProto.Type.Kind.TIMESTAMP);
                break;
            }
            case DATE: {
                type.setKind(OrcProto.Type.Kind.DATE);
                break;
            }
            case DECIMAL: {
                type.setKind(OrcProto.Type.Kind.DECIMAL);
                type.setPrecision(schema.getPrecision());
                type.setScale(schema.getScale());
                break;
            }
            case LIST: {
                type.setKind(OrcProto.Type.Kind.LIST);
                type.addSubtypes(children.get(0).getId());
                break;
            }
            case MAP: {
                type.setKind(OrcProto.Type.Kind.MAP);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                break;
            }
            case STRUCT: {
                type.setKind(OrcProto.Type.Kind.STRUCT);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                for (String field : schema.getFieldNames()) {
                    type.addFieldNames(field);
                }
                break;
            }
            case UNION: {
                type.setKind(OrcProto.Type.Kind.UNION);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + (Object)((Object)schema.getCategory()));
            }
        }
        builder.addTypes(type);
        if (children != null) {
            for (TypeDescription child : children) {
                WriterImpl.writeTypes(builder, child);
            }
        }
    }

    @VisibleForTesting
    public FSDataOutputStream getStream() throws IOException {
        if (this.rawWriter == null) {
            this.rawWriter = this.fs.create(this.path, false, 262144, this.fs.getDefaultReplication(this.path), this.blockSize);
            this.rawWriter.writeBytes("ORC");
            this.headerLength = this.rawWriter.getPos();
            this.writer = new OutStream("metadata", this.bufferSize, this.codec, new DirectStream(this.rawWriter));
            this.protobufWriter = CodedOutputStream.newInstance(this.writer);
        }
        return this.rawWriter;
    }

    private void createRowIndexEntry() throws IOException {
        this.treeWriter.createRowIndexEntry();
        this.rowsInIndex = 0;
    }

    private void flushStripe() throws IOException {
        this.getStream();
        if (this.buildIndex && this.rowsInIndex != 0) {
            this.createRowIndexEntry();
        }
        if (this.rowsInStripe != 0L) {
            if (this.callback != null) {
                this.callback.preStripeWrite(this.callbackContext);
            }
            int requiredIndexEntries = this.rowIndexStride == 0 ? 0 : (int)((this.rowsInStripe + (long)this.rowIndexStride - 1L) / (long)this.rowIndexStride);
            OrcProto.StripeFooter.Builder builder = OrcProto.StripeFooter.newBuilder();
            this.treeWriter.writeStripe(builder, requiredIndexEntries);
            long indexSize = 0L;
            long dataSize = 0L;
            for (Map.Entry<StreamName, BufferedStream> pair : this.streams.entrySet()) {
                BufferedStream stream = pair.getValue();
                if (stream.isSuppressed()) continue;
                stream.flush();
                StreamName name = pair.getKey();
                long streamSize = pair.getValue().getOutputSize();
                builder.addStreams(OrcProto.Stream.newBuilder().setColumn(name.getColumn()).setKind(name.getKind()).setLength(streamSize));
                if (StreamName.Area.INDEX == name.getArea()) {
                    indexSize += streamSize;
                    continue;
                }
                dataSize += streamSize;
            }
            OrcProto.StripeFooter footer = builder.build();
            long start = this.rawWriter.getPos();
            long currentStripeSize = indexSize + dataSize + (long)footer.getSerializedSize();
            long available = this.blockSize - start % this.blockSize;
            long overflow = currentStripeSize - this.adjustedStripeSize;
            float availRatio = (float)available / (float)this.defaultStripeSize;
            if (availRatio > 0.0f && availRatio < 1.0f && (double)availRatio > this.paddingTolerance) {
                double correction = overflow > 0L ? (double)overflow / (double)this.adjustedStripeSize : 0.0;
                correction = correction > this.paddingTolerance ? this.paddingTolerance : correction;
                this.adjustedStripeSize = (long)((1.0 - correction) * (double)(availRatio * (float)this.defaultStripeSize));
            } else if ((double)availRatio >= 1.0) {
                this.adjustedStripeSize = this.defaultStripeSize;
            }
            if ((double)availRatio < this.paddingTolerance && this.addBlockPadding) {
                long padding = this.blockSize - start % this.blockSize;
                byte[] pad = new byte[(int)Math.min(262144L, padding)];
                LOG.info(String.format("Padding ORC by %d bytes (<=  %.2f * %d)", padding, Float.valueOf(availRatio), this.defaultStripeSize));
                start += padding;
                while (padding > 0L) {
                    int writeLen = (int)Math.min(padding, (long)pad.length);
                    this.rawWriter.write(pad, 0, writeLen);
                    padding -= (long)writeLen;
                }
                this.adjustedStripeSize = this.defaultStripeSize;
            } else if (currentStripeSize < this.blockSize && start % this.blockSize + currentStripeSize > this.blockSize) {
                this.adjustedStripeSize = this.defaultStripeSize;
            }
            for (Map.Entry<StreamName, BufferedStream> pair : this.streams.entrySet()) {
                BufferedStream stream = pair.getValue();
                if (!stream.isSuppressed()) {
                    stream.spillTo((OutputStream)this.rawWriter);
                }
                stream.clear();
            }
            footer.writeTo(this.protobufWriter);
            this.protobufWriter.flush();
            this.writer.flush();
            long footerLength = this.rawWriter.getPos() - start - dataSize - indexSize;
            OrcProto.StripeInformation dirEntry = OrcProto.StripeInformation.newBuilder().setOffset(start).setNumberOfRows(this.rowsInStripe).setIndexLength(indexSize).setDataLength(dataSize).setFooterLength(footerLength).build();
            this.stripes.add(dirEntry);
            this.rowCount += this.rowsInStripe;
            this.rowsInStripe = 0L;
        }
    }

    private long computeRawDataSize() {
        return this.getRawDataSize(this.treeWriter, this.schema);
    }

    private long getRawDataSize(TreeWriter child, TypeDescription schema) {
        long total = 0L;
        long numVals = child.fileStatistics.getNumberOfValues();
        switch (schema.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case FLOAT: {
                return numVals * (long)JavaDataModel.get().primitive1();
            }
            case LONG: 
            case DOUBLE: {
                return numVals * (long)JavaDataModel.get().primitive2();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                StringColumnStatistics scs = (StringColumnStatistics)((Object)child.fileStatistics);
                numVals = numVals == 0L ? 1L : numVals;
                int avgStringLen = (int)(scs.getSum() / numVals);
                return numVals * (long)JavaDataModel.get().lengthForStringOfLength(avgStringLen);
            }
            case DECIMAL: {
                return numVals * (long)JavaDataModel.get().lengthOfDecimal();
            }
            case DATE: {
                return numVals * (long)JavaDataModel.get().lengthOfDate();
            }
            case BINARY: {
                BinaryColumnStatistics bcs = (BinaryColumnStatistics)((Object)child.fileStatistics);
                return bcs.getSum();
            }
            case TIMESTAMP: {
                return numVals * (long)JavaDataModel.get().lengthOfTimestamp();
            }
            case STRUCT: 
            case MAP: 
            case LIST: 
            case UNION: {
                TreeWriter[] childWriters = child.getChildrenWriters();
                List<TypeDescription> childTypes = schema.getChildren();
                for (int i = 0; i < childWriters.length; ++i) {
                    total += this.getRawDataSize(childWriters[i], childTypes.get(i));
                }
                break;
            }
            default: {
                LOG.debug("Unknown object inspector category.");
            }
        }
        return total;
    }

    private OrcProto.CompressionKind writeCompressionKind(CompressionKind kind) {
        switch (kind) {
            case NONE: {
                return OrcProto.CompressionKind.NONE;
            }
            case ZLIB: {
                return OrcProto.CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return OrcProto.CompressionKind.SNAPPY;
            }
            case LZO: {
                return OrcProto.CompressionKind.LZO;
            }
        }
        throw new IllegalArgumentException("Unknown compression " + (Object)((Object)kind));
    }

    private void writeFileStatistics(OrcProto.Footer.Builder builder, TreeWriter writer) throws IOException {
        builder.addStatistics(writer.fileStatistics.serialize());
        for (TreeWriter child : writer.getChildrenWriters()) {
            this.writeFileStatistics(builder, child);
        }
    }

    private int writeMetadata() throws IOException {
        this.getStream();
        OrcProto.Metadata.Builder builder = OrcProto.Metadata.newBuilder();
        for (OrcProto.StripeStatistics.Builder ssb : this.treeWriter.stripeStatsBuilders) {
            builder.addStripeStats(ssb.build());
        }
        long startPosn = this.rawWriter.getPos();
        OrcProto.Metadata metadata = builder.build();
        metadata.writeTo(this.protobufWriter);
        this.protobufWriter.flush();
        this.writer.flush();
        return (int)(this.rawWriter.getPos() - startPosn);
    }

    private int writeFooter(long bodyLength) throws IOException {
        this.getStream();
        OrcProto.Footer.Builder builder = OrcProto.Footer.newBuilder();
        builder.setContentLength(bodyLength);
        builder.setHeaderLength(this.headerLength);
        builder.setNumberOfRows(this.rowCount);
        builder.setRowIndexStride(this.rowIndexStride);
        this.rawDataSize = this.computeRawDataSize();
        WriterImpl.writeTypes(builder, this.schema);
        for (OrcProto.StripeInformation stripeInformation : this.stripes) {
            builder.addStripes(stripeInformation);
        }
        this.writeFileStatistics(builder, this.treeWriter);
        for (Map.Entry entry : this.userMetadata.entrySet()) {
            builder.addMetadata(OrcProto.UserMetadataItem.newBuilder().setName((String)entry.getKey()).setValue((ByteString)entry.getValue()));
        }
        long startPosn = this.rawWriter.getPos();
        OrcProto.Footer footer = builder.build();
        footer.writeTo(this.protobufWriter);
        this.protobufWriter.flush();
        this.writer.flush();
        return (int)(this.rawWriter.getPos() - startPosn);
    }

    private int writePostScript(int footerLength, int metadataLength) throws IOException {
        OrcProto.PostScript.Builder builder = OrcProto.PostScript.newBuilder().setCompression(this.writeCompressionKind(this.compress)).setFooterLength(footerLength).setMetadataLength(metadataLength).setMagic("ORC").addVersion(this.version.getMajor()).addVersion(this.version.getMinor()).setWriterVersion(OrcFile.CURRENT_WRITER.getId());
        if (this.compress != CompressionKind.NONE) {
            builder.setCompressionBlockSize(this.bufferSize);
        }
        OrcProto.PostScript ps = builder.build();
        long startPosn = this.rawWriter.getPos();
        ps.writeTo((OutputStream)this.rawWriter);
        long length = this.rawWriter.getPos() - startPosn;
        if (length > 255L) {
            throw new IllegalArgumentException("PostScript too large at " + length);
        }
        return (int)length;
    }

    private long estimateStripeSize() {
        long result = 0L;
        for (BufferedStream stream : this.streams.values()) {
            result += stream.getBufferSize();
        }
        return result += this.treeWriter.estimateMemory();
    }

    @Override
    public TypeDescription getSchema() {
        return this.schema;
    }

    @Override
    public void addUserMetadata(String name, ByteBuffer value) {
        this.userMetadata.put(name, ByteString.copyFrom(value));
    }

    @Override
    public void addRowBatch(VectorizedRowBatch batch) throws IOException {
        if (this.buildIndex) {
            int posn = 0;
            while (posn < batch.size) {
                int chunkSize = Math.min(batch.size - posn, this.rowIndexStride - this.rowsInIndex);
                this.treeWriter.writeRootBatch(batch, posn, chunkSize);
                posn += chunkSize;
                this.rowsInIndex += chunkSize;
                this.rowsInStripe += (long)chunkSize;
                if (this.rowsInIndex < this.rowIndexStride) continue;
                this.createRowIndexEntry();
            }
        } else {
            this.rowsInStripe += (long)batch.size;
            this.treeWriter.writeRootBatch(batch, 0, batch.size);
        }
        this.memoryManager.addedRow(batch.size);
    }

    @Override
    public void close() throws IOException {
        if (this.callback != null) {
            this.callback.preFooterWrite(this.callbackContext);
        }
        this.memoryManager.removeWriter(this.path);
        this.flushStripe();
        int metadataLength = this.writeMetadata();
        int footerLength = this.writeFooter(this.rawWriter.getPos() - (long)metadataLength);
        this.rawWriter.writeByte(this.writePostScript(footerLength, metadataLength));
        this.rawWriter.close();
    }

    @Override
    public long getRawDataSize() {
        return this.rawDataSize;
    }

    @Override
    public long getNumberOfRows() {
        return this.rowCount;
    }

    @Override
    public long writeIntermediateFooter() throws IOException {
        this.flushStripe();
        if (this.stripesAtLastFlush != this.stripes.size()) {
            if (this.callback != null) {
                this.callback.preFooterWrite(this.callbackContext);
            }
            int metaLength = this.writeMetadata();
            int footLength = this.writeFooter(this.rawWriter.getPos() - (long)metaLength);
            this.rawWriter.writeByte(this.writePostScript(footLength, metaLength));
            this.stripesAtLastFlush = this.stripes.size();
            this.rawWriter.hflush();
        }
        return this.rawWriter.getPos();
    }

    @Override
    public void appendStripe(byte[] stripe, int offset, int length, StripeInformation stripeInfo, OrcProto.StripeStatistics stripeStatistics) throws IOException {
        Preconditions.checkArgument(stripe != null, "Stripe must not be null");
        Preconditions.checkArgument(length <= stripe.length, "Specified length must not be greater specified array length");
        Preconditions.checkArgument(stripeInfo != null, "Stripe information must not be null");
        Preconditions.checkArgument(stripeStatistics != null, "Stripe statistics must not be null");
        this.getStream();
        long start = this.rawWriter.getPos();
        long availBlockSpace = this.blockSize - start % this.blockSize;
        if ((long)length < this.blockSize && (long)length > availBlockSpace && this.addBlockPadding) {
            byte[] pad = new byte[(int)Math.min(262144L, availBlockSpace)];
            LOG.info(String.format("Padding ORC by %d bytes while merging..", availBlockSpace));
            start += availBlockSpace;
            while (availBlockSpace > 0L) {
                int writeLen = (int)Math.min(availBlockSpace, (long)pad.length);
                this.rawWriter.write(pad, 0, writeLen);
                availBlockSpace -= (long)writeLen;
            }
        }
        this.rawWriter.write(stripe);
        this.rowsInStripe = stripeStatistics.getColStats(0).getNumberOfValues();
        this.rowCount += this.rowsInStripe;
        this.treeWriter.stripeStatsBuilders.add(stripeStatistics.toBuilder());
        this.updateFileStatistics(stripeStatistics);
        OrcProto.StripeInformation dirEntry = OrcProto.StripeInformation.newBuilder().setOffset(start).setNumberOfRows(this.rowsInStripe).setIndexLength(stripeInfo.getIndexLength()).setDataLength(stripeInfo.getDataLength()).setFooterLength(stripeInfo.getFooterLength()).build();
        this.stripes.add(dirEntry);
        this.rowsInStripe = 0L;
    }

    private void updateFileStatistics(OrcProto.StripeStatistics stripeStatistics) {
        List<OrcProto.ColumnStatistics> cs = stripeStatistics.getColStatsList();
        List<TreeWriter> allWriters = this.getAllColumnTreeWriters(this.treeWriter);
        for (int i = 0; i < allWriters.size(); ++i) {
            allWriters.get(i).fileStatistics.merge(ColumnStatisticsImpl.deserialize(cs.get(i)));
        }
    }

    private List<TreeWriter> getAllColumnTreeWriters(TreeWriter rootTreeWriter) {
        ArrayList<TreeWriter> result = Lists.newArrayList();
        this.getAllColumnTreeWritersImpl(rootTreeWriter, result);
        return result;
    }

    private void getAllColumnTreeWritersImpl(TreeWriter tw, List<TreeWriter> result) {
        result.add(tw);
        for (TreeWriter child : tw.childrenWriters) {
            this.getAllColumnTreeWritersImpl(child, result);
        }
    }

    @Override
    public void appendUserMetadata(List<OrcProto.UserMetadataItem> userMetadata) {
        if (userMetadata != null) {
            for (OrcProto.UserMetadataItem item : userMetadata) {
                this.userMetadata.put(item.getName(), item.getValue());
            }
        }
    }

    private static class UnionTreeWriter
    extends TreeWriter {
        private final RunLengthByteWriter tags;

        UnionTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            List<TypeDescription> children = schema.getChildren();
            this.childrenWriters = new TreeWriter[children.size()];
            for (int i = 0; i < this.childrenWriters.length; ++i) {
                this.childrenWriters[i] = WriterImpl.createTreeWriter(children.get(i), writer, true);
            }
            this.tags = new RunLengthByteWriter(writer.createStream(columnId, OrcProto.Stream.Kind.DATA));
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            super.writeBatch(vector, offset, length);
            UnionColumnVector vec = (UnionColumnVector)vector;
            if (vector.isRepeating) {
                if (vector.noNulls || !vector.isNull[0]) {
                    byte tag = (byte)vec.tags[0];
                    for (int i = 0; i < length; ++i) {
                        this.tags.write(tag);
                    }
                    if (this.createBloomFilter) {
                        this.bloomFilter.addLong(tag);
                    }
                    this.childrenWriters[tag].writeBatch(vec.fields[tag], offset, length);
                }
            } else {
                int[] currentStart = new int[vec.fields.length];
                int[] currentLength = new int[vec.fields.length];
                for (int i = 0; i < length; ++i) {
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    byte tag = (byte)vec.tags[offset + i];
                    this.tags.write(tag);
                    if (currentLength[tag] == 0) {
                        currentStart[tag] = i + offset;
                        currentLength[tag] = 1;
                        continue;
                    }
                    if (currentStart[tag] + currentLength[tag] == i + offset) {
                        byte by = tag;
                        currentLength[by] = currentLength[by] + 1;
                        continue;
                    }
                    this.childrenWriters[tag].writeBatch(vec.fields[tag], currentStart[tag], currentLength[tag]);
                    currentStart[tag] = i + offset;
                    currentLength[tag] = 1;
                }
                for (int tag = 0; tag < currentStart.length; ++tag) {
                    if (currentLength[tag] == 0) continue;
                    this.childrenWriters[tag].writeBatch(vec.fields[tag], currentStart[tag], currentLength[tag]);
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.tags.flush();
            for (TreeWriter child : this.childrenWriters) {
                child.writeStripe(builder, requiredIndexEntries);
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.tags.getPosition(recorder);
        }
    }

    private static class MapTreeWriter
    extends TreeWriter {
        private final IntegerWriter lengths;
        private final boolean isDirectV2;

        MapTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.childrenWriters = new TreeWriter[2];
            List<TypeDescription> children = schema.getChildren();
            this.childrenWriters[0] = WriterImpl.createTreeWriter(children.get(0), writer, true);
            this.childrenWriters[1] = WriterImpl.createTreeWriter(children.get(1), writer, true);
            this.lengths = this.createIntegerWriter(writer.createStream(columnId, OrcProto.Stream.Kind.LENGTH), false, this.isDirectV2, writer);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            super.writeBatch(vector, offset, length);
            MapColumnVector vec = (MapColumnVector)vector;
            if (vector.isRepeating) {
                if (vector.noNulls || !vector.isNull[0]) {
                    int childOffset = (int)vec.offsets[0];
                    int childLength = (int)vec.lengths[0];
                    for (int i = 0; i < length; ++i) {
                        this.lengths.write(childLength);
                        this.childrenWriters[0].writeBatch(vec.keys, childOffset, childLength);
                        this.childrenWriters[1].writeBatch(vec.values, childOffset, childLength);
                    }
                    if (this.createBloomFilter) {
                        this.bloomFilter.addLong(childLength);
                    }
                }
            } else {
                int currentOffset = 0;
                int currentLength = 0;
                for (int i = 0; i < length; ++i) {
                    if (vec.isNull[i + offset]) continue;
                    int nextLength = (int)vec.lengths[offset + i];
                    int nextOffset = (int)vec.offsets[offset + i];
                    this.lengths.write(nextLength);
                    if (currentLength == 0) {
                        currentOffset = nextOffset;
                        currentLength = nextLength;
                        continue;
                    }
                    if (currentOffset + currentLength != nextOffset) {
                        this.childrenWriters[0].writeBatch(vec.keys, currentOffset, currentLength);
                        this.childrenWriters[1].writeBatch(vec.values, currentOffset, currentLength);
                        currentOffset = nextOffset;
                        currentLength = nextLength;
                        continue;
                    }
                    currentLength += nextLength;
                }
                if (currentLength != 0) {
                    this.childrenWriters[0].writeBatch(vec.keys, currentOffset, currentLength);
                    this.childrenWriters[1].writeBatch(vec.values, currentOffset, currentLength);
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.lengths.flush();
            for (TreeWriter child : this.childrenWriters) {
                child.writeStripe(builder, requiredIndexEntries);
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.lengths.getPosition(recorder);
        }
    }

    private static class ListTreeWriter
    extends TreeWriter {
        private final IntegerWriter lengths;
        private final boolean isDirectV2;

        ListTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.childrenWriters = new TreeWriter[1];
            this.childrenWriters[0] = WriterImpl.createTreeWriter(schema.getChildren().get(0), writer, true);
            this.lengths = this.createIntegerWriter(writer.createStream(columnId, OrcProto.Stream.Kind.LENGTH), false, this.isDirectV2, writer);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            super.writeBatch(vector, offset, length);
            ListColumnVector vec = (ListColumnVector)vector;
            if (vector.isRepeating) {
                if (vector.noNulls || !vector.isNull[0]) {
                    int childOffset = (int)vec.offsets[0];
                    int childLength = (int)vec.lengths[0];
                    for (int i = 0; i < length; ++i) {
                        this.lengths.write(childLength);
                        this.childrenWriters[0].writeBatch(vec.child, childOffset, childLength);
                    }
                    if (this.createBloomFilter) {
                        this.bloomFilter.addLong(childLength);
                    }
                }
            } else {
                int currentOffset = 0;
                int currentLength = 0;
                for (int i = 0; i < length; ++i) {
                    if (vec.isNull[i + offset]) continue;
                    int nextLength = (int)vec.lengths[offset + i];
                    int nextOffset = (int)vec.offsets[offset + i];
                    this.lengths.write(nextLength);
                    if (currentLength == 0) {
                        currentOffset = nextOffset;
                        currentLength = nextLength;
                        continue;
                    }
                    if (currentOffset + currentLength != nextOffset) {
                        this.childrenWriters[0].writeBatch(vec.child, currentOffset, currentLength);
                        currentOffset = nextOffset;
                        currentLength = nextLength;
                        continue;
                    }
                    currentLength += nextLength;
                }
                if (currentLength != 0) {
                    this.childrenWriters[0].writeBatch(vec.child, currentOffset, currentLength);
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.lengths.flush();
            for (TreeWriter child : this.childrenWriters) {
                child.writeStripe(builder, requiredIndexEntries);
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.lengths.getPosition(recorder);
        }
    }

    private static class StructTreeWriter
    extends TreeWriter {
        StructTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            List<TypeDescription> children = schema.getChildren();
            this.childrenWriters = new TreeWriter[children.size()];
            for (int i = 0; i < this.childrenWriters.length; ++i) {
                this.childrenWriters[i] = WriterImpl.createTreeWriter(children.get(i), writer, true);
            }
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void writeRootBatch(VectorizedRowBatch batch, int offset, int length) throws IOException {
            this.indexStatistics.increment(length);
            for (int i = 0; i < this.childrenWriters.length; ++i) {
                this.childrenWriters[i].writeBatch(batch.cols[i], offset, length);
            }
        }

        private static void writeFields(StructColumnVector vector, TreeWriter[] childrenWriters, int offset, int length) throws IOException {
            for (int field = 0; field < childrenWriters.length; ++field) {
                childrenWriters[field].writeBatch(vector.fields[field], offset, length);
            }
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            super.writeBatch(vector, offset, length);
            StructColumnVector vec = (StructColumnVector)vector;
            if (vector.isRepeating) {
                if (vector.noNulls || !vector.isNull[0]) {
                    StructTreeWriter.writeFields(vec, this.childrenWriters, offset, length);
                }
            } else if (vector.noNulls) {
                StructTreeWriter.writeFields(vec, this.childrenWriters, offset, length);
            } else {
                int currentRun = 0;
                boolean started = false;
                for (int i = 0; i < length; ++i) {
                    if (!vec.isNull[i + offset]) {
                        if (started) continue;
                        started = true;
                        currentRun = i;
                        continue;
                    }
                    if (!started) continue;
                    started = false;
                    StructTreeWriter.writeFields(vec, this.childrenWriters, offset + currentRun, i - currentRun);
                }
                if (started) {
                    StructTreeWriter.writeFields(vec, this.childrenWriters, offset + currentRun, length - currentRun);
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            for (TreeWriter child : this.childrenWriters) {
                child.writeStripe(builder, requiredIndexEntries);
            }
            this.recordPosition(this.rowIndexPosition);
        }
    }

    private static class DecimalTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream valueStream;
        private final IntegerWriter scaleStream;
        private final boolean isDirectV2;

        DecimalTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.valueStream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.scaleStream = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.SECONDARY), true, this.isDirectV2, writer);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            block4: {
                DecimalColumnVector vec;
                block3: {
                    super.writeBatch(vector, offset, length);
                    vec = (DecimalColumnVector)vector;
                    if (!vector.isRepeating) break block3;
                    if (!vector.noNulls && vector.isNull[0]) break block4;
                    HiveDecimal value = vec.vector[0].getHiveDecimal();
                    this.indexStatistics.updateDecimal(value);
                    if (this.createBloomFilter) {
                        this.bloomFilter.addString(value.toString());
                    }
                    for (int i = 0; i < length; ++i) {
                        SerializationUtils.writeBigInteger(this.valueStream, value.unscaledValue());
                        this.scaleStream.write(value.scale());
                    }
                    break block4;
                }
                for (int i = 0; i < length; ++i) {
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    HiveDecimal value = vec.vector[i + offset].getHiveDecimal();
                    SerializationUtils.writeBigInteger(this.valueStream, value.unscaledValue());
                    this.scaleStream.write(value.scale());
                    this.indexStatistics.updateDecimal(value);
                    if (!this.createBloomFilter) continue;
                    this.bloomFilter.addString(value.toString());
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.valueStream.flush();
            this.scaleStream.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.valueStream.getPosition(recorder);
            this.scaleStream.getPosition(recorder);
        }
    }

    private static class DateTreeWriter
    extends TreeWriter {
        private final IntegerWriter writer;
        private final boolean isDirectV2;

        DateTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            OutStream out = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.writer = this.createIntegerWriter(out, true, this.isDirectV2, writer);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            block4: {
                LongColumnVector vec;
                block3: {
                    super.writeBatch(vector, offset, length);
                    vec = (LongColumnVector)vector;
                    if (!vector.isRepeating) break block3;
                    if (!vector.noNulls && vector.isNull[0]) break block4;
                    int value = (int)vec.vector[0];
                    this.indexStatistics.updateDate(value);
                    if (this.createBloomFilter) {
                        this.bloomFilter.addLong(value);
                    }
                    for (int i = 0; i < length; ++i) {
                        this.writer.write(value);
                    }
                    break block4;
                }
                for (int i = 0; i < length; ++i) {
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    int value = (int)vec.vector[i + offset];
                    this.writer.write(value);
                    this.indexStatistics.updateDate(value);
                    if (!this.createBloomFilter) continue;
                    this.bloomFilter.addLong(value);
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.writer.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.writer.getPosition(recorder);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }
    }

    private static class TimestampTreeWriter
    extends TreeWriter {
        private final IntegerWriter seconds;
        private final IntegerWriter nanos;
        private final boolean isDirectV2;
        private final long base_timestamp;

        TimestampTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.seconds = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.DATA), true, this.isDirectV2, writer);
            this.nanos = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.SECONDARY), false, this.isDirectV2, writer);
            this.recordPosition(this.rowIndexPosition);
            this.base_timestamp = Timestamp.valueOf(WriterImpl.BASE_TIMESTAMP_STRING).getTime() / 1000L;
            writer.useWriterTimeZone(true);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            block4: {
                TimestampColumnVector vec;
                block3: {
                    super.writeBatch(vector, offset, length);
                    vec = (TimestampColumnVector)vector;
                    if (!vector.isRepeating) break block3;
                    if (!vector.noNulls && vector.isNull[0]) break block4;
                    Timestamp val = vec.asScratchTimestamp(0);
                    long millis = val.getTime();
                    this.indexStatistics.updateTimestamp(millis);
                    if (this.createBloomFilter) {
                        this.bloomFilter.addLong(millis);
                    }
                    long secs = millis / 1000L - this.base_timestamp;
                    long nano = TimestampTreeWriter.formatNanos(val.getNanos());
                    for (int i = 0; i < length; ++i) {
                        this.seconds.write(secs);
                        this.nanos.write(nano);
                    }
                    break block4;
                }
                for (int i = 0; i < length; ++i) {
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    Timestamp val = vec.asScratchTimestamp(i + offset);
                    long millis = val.getTime();
                    long secs = millis / 1000L - this.base_timestamp;
                    this.seconds.write(secs);
                    this.nanos.write(TimestampTreeWriter.formatNanos(val.getNanos()));
                    this.indexStatistics.updateTimestamp(millis);
                    if (!this.createBloomFilter) continue;
                    this.bloomFilter.addLong(millis);
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.seconds.flush();
            this.nanos.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        private static long formatNanos(int nanos) {
            int trailingZeros;
            if (nanos == 0) {
                return 0L;
            }
            if (nanos % 100 != 0) {
                return (long)nanos << 3;
            }
            nanos /= 100;
            for (trailingZeros = 1; nanos % 10 == 0 && trailingZeros < 7; ++trailingZeros) {
                nanos /= 10;
            }
            return (long)nanos << 3 | (long)trailingZeros;
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.seconds.getPosition(recorder);
            this.nanos.getPosition(recorder);
        }
    }

    private static class BinaryTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream stream;
        private final IntegerWriter length;
        private boolean isDirectV2 = true;

        BinaryTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            this.stream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.length = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.LENGTH), false, this.isDirectV2, writer);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            block3: {
                BytesColumnVector vec;
                block2: {
                    super.writeBatch(vector, offset, length);
                    vec = (BytesColumnVector)vector;
                    if (!vector.isRepeating) break block2;
                    if (!vector.noNulls && vector.isNull[0]) break block3;
                    for (int i = 0; i < length; ++i) {
                        this.stream.write(vec.vector[0], vec.start[0], vec.length[0]);
                        this.length.write(vec.length[0]);
                    }
                    this.indexStatistics.updateBinary(vec.vector[0], vec.start[0], vec.length[0], length);
                    if (!this.createBloomFilter) break block3;
                    this.bloomFilter.addBytes(vec.vector[0], vec.start[0], vec.length[0]);
                    break block3;
                }
                for (int i = 0; i < length; ++i) {
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    this.stream.write(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i]);
                    this.length.write(vec.length[offset + i]);
                    this.indexStatistics.updateBinary(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i], 1);
                    if (!this.createBloomFilter) continue;
                    this.bloomFilter.addBytes(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i]);
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.stream.flush();
            this.length.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.stream.getPosition(recorder);
            this.length.getPosition(recorder);
        }
    }

    private static class VarcharTreeWriter
    extends StringBaseTreeWriter {
        private final int maxLength;

        VarcharTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            this.maxLength = schema.getMaxLength();
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            block8: {
                BytesColumnVector vec;
                block7: {
                    super.writeBatch(vector, offset, length);
                    vec = (BytesColumnVector)vector;
                    if (!vector.isRepeating) break block7;
                    if (!vector.noNulls && vector.isNull[0]) break block8;
                    int itemLength = Math.min(vec.length[0], this.maxLength);
                    if (this.useDictionaryEncoding) {
                        int id = this.dictionary.add(vec.vector[0], vec.start[0], itemLength);
                        for (int i = 0; i < length; ++i) {
                            this.rows.add(id);
                        }
                    } else {
                        for (int i = 0; i < length; ++i) {
                            this.directStreamOutput.write(vec.vector[0], vec.start[0], itemLength);
                            this.directLengthOutput.write(itemLength);
                        }
                    }
                    this.indexStatistics.updateString(vec.vector[0], vec.start[0], itemLength, length);
                    if (!this.createBloomFilter) break block8;
                    this.bloomFilter.addBytes(vec.vector[0], vec.start[0], itemLength);
                    break block8;
                }
                for (int i = 0; i < length; ++i) {
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    int itemLength = Math.min(vec.length[offset + i], this.maxLength);
                    if (this.useDictionaryEncoding) {
                        this.rows.add(this.dictionary.add(vec.vector[offset + i], vec.start[offset + i], itemLength));
                    } else {
                        this.directStreamOutput.write(vec.vector[offset + i], vec.start[offset + i], itemLength);
                        this.directLengthOutput.write(itemLength);
                    }
                    this.indexStatistics.updateString(vec.vector[offset + i], vec.start[offset + i], itemLength, 1);
                    if (!this.createBloomFilter) continue;
                    this.bloomFilter.addBytes(vec.vector[offset + i], vec.start[offset + i], itemLength);
                }
            }
        }
    }

    private static class CharTreeWriter
    extends StringBaseTreeWriter {
        private final int itemLength;
        private final byte[] padding;

        CharTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            this.itemLength = schema.getMaxLength();
            this.padding = new byte[this.itemLength];
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            block12: {
                BytesColumnVector vec;
                block11: {
                    int ptrOffset;
                    byte[] ptr;
                    super.writeBatch(vector, offset, length);
                    vec = (BytesColumnVector)vector;
                    if (!vector.isRepeating) break block11;
                    if (!vector.noNulls && vector.isNull[0]) break block12;
                    if (vec.length[0] >= this.itemLength) {
                        ptr = vec.vector[0];
                        ptrOffset = vec.start[0];
                    } else {
                        ptr = this.padding;
                        ptrOffset = 0;
                        System.arraycopy(vec.vector[0], vec.start[0], ptr, 0, vec.length[0]);
                        Arrays.fill(ptr, vec.length[0], this.itemLength, (byte)32);
                    }
                    if (this.useDictionaryEncoding) {
                        int id = this.dictionary.add(ptr, ptrOffset, this.itemLength);
                        for (int i = 0; i < length; ++i) {
                            this.rows.add(id);
                        }
                    } else {
                        for (int i = 0; i < length; ++i) {
                            this.directStreamOutput.write(ptr, ptrOffset, this.itemLength);
                            this.directLengthOutput.write(this.itemLength);
                        }
                    }
                    this.indexStatistics.updateString(ptr, ptrOffset, this.itemLength, length);
                    if (!this.createBloomFilter) break block12;
                    this.bloomFilter.addBytes(ptr, ptrOffset, this.itemLength);
                    break block12;
                }
                for (int i = 0; i < length; ++i) {
                    int ptrOffset;
                    byte[] ptr;
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    if (vec.length[offset + i] >= this.itemLength) {
                        ptr = vec.vector[offset + i];
                        ptrOffset = vec.start[offset + i];
                    } else {
                        ptr = this.padding;
                        ptrOffset = 0;
                        System.arraycopy(vec.vector[offset + i], vec.start[offset + i], ptr, 0, vec.length[offset + i]);
                        Arrays.fill(ptr, vec.length[offset + i], this.itemLength, (byte)32);
                    }
                    if (this.useDictionaryEncoding) {
                        this.rows.add(this.dictionary.add(ptr, ptrOffset, this.itemLength));
                    } else {
                        this.directStreamOutput.write(ptr, ptrOffset, this.itemLength);
                        this.directLengthOutput.write(this.itemLength);
                    }
                    this.indexStatistics.updateString(ptr, ptrOffset, this.itemLength, 1);
                    if (!this.createBloomFilter) continue;
                    this.bloomFilter.addBytes(ptr, ptrOffset, this.itemLength);
                }
            }
        }
    }

    private static class StringTreeWriter
    extends StringBaseTreeWriter {
        StringTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            block8: {
                BytesColumnVector vec;
                block7: {
                    super.writeBatch(vector, offset, length);
                    vec = (BytesColumnVector)vector;
                    if (!vector.isRepeating) break block7;
                    if (!vector.noNulls && vector.isNull[0]) break block8;
                    if (this.useDictionaryEncoding) {
                        int id = this.dictionary.add(vec.vector[0], vec.start[0], vec.length[0]);
                        for (int i = 0; i < length; ++i) {
                            this.rows.add(id);
                        }
                    } else {
                        for (int i = 0; i < length; ++i) {
                            this.directStreamOutput.write(vec.vector[0], vec.start[0], vec.length[0]);
                            this.directLengthOutput.write(vec.length[0]);
                        }
                    }
                    this.indexStatistics.updateString(vec.vector[0], vec.start[0], vec.length[0], length);
                    if (!this.createBloomFilter) break block8;
                    this.bloomFilter.addBytes(vec.vector[0], vec.start[0], vec.length[0]);
                    break block8;
                }
                for (int i = 0; i < length; ++i) {
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    if (this.useDictionaryEncoding) {
                        this.rows.add(this.dictionary.add(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i]));
                    } else {
                        this.directStreamOutput.write(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i]);
                        this.directLengthOutput.write(vec.length[offset + i]);
                    }
                    this.indexStatistics.updateString(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i], 1);
                    if (!this.createBloomFilter) continue;
                    this.bloomFilter.addBytes(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i]);
                }
            }
        }
    }

    private static abstract class StringBaseTreeWriter
    extends TreeWriter {
        private static final int INITIAL_DICTIONARY_SIZE = 4096;
        private final OutStream stringOutput;
        private final IntegerWriter lengthOutput;
        private final IntegerWriter rowOutput;
        protected final StringRedBlackTree dictionary = new StringRedBlackTree(4096);
        protected final DynamicIntArray rows = new DynamicIntArray();
        protected final PositionedOutputStream directStreamOutput;
        protected final IntegerWriter directLengthOutput;
        private final List<OrcProto.RowIndexEntry> savedRowIndex = new ArrayList<OrcProto.RowIndexEntry>();
        private final boolean buildIndex;
        private final List<Long> rowIndexValueCount = new ArrayList<Long>();
        private final double dictionaryKeySizeThreshold;
        protected boolean useDictionaryEncoding = true;
        private boolean isDirectV2 = true;
        private boolean doneDictionaryCheck;
        private final boolean strideDictionaryCheck;

        StringBaseTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.stringOutput = writer.createStream(this.id, OrcProto.Stream.Kind.DICTIONARY_DATA);
            this.lengthOutput = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.LENGTH), false, this.isDirectV2, writer);
            this.rowOutput = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.DATA), false, this.isDirectV2, writer);
            this.recordPosition(this.rowIndexPosition);
            this.rowIndexValueCount.add(0L);
            this.buildIndex = writer.buildIndex();
            this.directStreamOutput = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.directLengthOutput = this.createIntegerWriter(writer.createStream(this.id, OrcProto.Stream.Kind.LENGTH), false, this.isDirectV2, writer);
            Configuration conf = writer.getConfiguration();
            this.dictionaryKeySizeThreshold = OrcConf.DICTIONARY_KEY_SIZE_THRESHOLD.getDouble(conf);
            this.strideDictionaryCheck = OrcConf.ROW_INDEX_STRIDE_DICTIONARY_CHECK.getBoolean(conf);
            this.doneDictionaryCheck = false;
        }

        private boolean checkDictionaryEncoding() {
            if (!this.doneDictionaryCheck) {
                float ratio = this.rows.size() > 0 ? (float)this.dictionary.size() / (float)this.rows.size() : 0.0f;
                this.useDictionaryEncoding = !this.isDirectV2 || (double)ratio <= this.dictionaryKeySizeThreshold;
                this.doneDictionaryCheck = true;
            }
            return this.useDictionaryEncoding;
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            this.checkDictionaryEncoding();
            if (this.useDictionaryEncoding) {
                this.flushDictionary();
            } else {
                if (this.rows.size() > 0) {
                    this.flushDictionary();
                }
                this.stringOutput.suppress();
            }
            super.writeStripe(builder, requiredIndexEntries);
            this.stringOutput.flush();
            this.lengthOutput.flush();
            this.rowOutput.flush();
            this.directStreamOutput.flush();
            this.directLengthOutput.flush();
            this.dictionary.clear();
            this.savedRowIndex.clear();
            this.rowIndexValueCount.clear();
            this.recordPosition(this.rowIndexPosition);
            this.rowIndexValueCount.add(0L);
            if (!this.useDictionaryEncoding) {
                this.recordDirectStreamPosition();
            }
        }

        private void flushDictionary() throws IOException {
            final int[] dumpOrder = new int[this.dictionary.size()];
            if (this.useDictionaryEncoding) {
                this.dictionary.visit(new StringRedBlackTree.Visitor(){
                    private int currentId = 0;

                    @Override
                    public void visit(StringRedBlackTree.VisitorContext context) throws IOException {
                        context.writeBytes(StringBaseTreeWriter.this.stringOutput);
                        StringBaseTreeWriter.this.lengthOutput.write(context.getLength());
                        dumpOrder[context.getOriginalPosition()] = this.currentId++;
                    }
                });
            } else {
                this.stringOutput.suppress();
            }
            int length = this.rows.size();
            int rowIndexEntry = 0;
            OrcProto.RowIndex.Builder rowIndex = this.getRowIndex();
            Text text = new Text();
            for (int i = 0; i <= length; ++i) {
                if (this.buildIndex) {
                    while ((long)i == this.rowIndexValueCount.get(rowIndexEntry) && rowIndexEntry < this.savedRowIndex.size()) {
                        OrcProto.RowIndexEntry.Builder base = this.savedRowIndex.get(rowIndexEntry++).toBuilder();
                        if (this.useDictionaryEncoding) {
                            this.rowOutput.getPosition(new RowIndexPositionRecorder(base));
                        } else {
                            RowIndexPositionRecorder posn = new RowIndexPositionRecorder(base);
                            this.directStreamOutput.getPosition(posn);
                            this.directLengthOutput.getPosition(posn);
                        }
                        rowIndex.addEntry(base.build());
                    }
                }
                if (i == length) continue;
                if (this.useDictionaryEncoding) {
                    this.rowOutput.write(dumpOrder[this.rows.get(i)]);
                    continue;
                }
                this.dictionary.getText(text, this.rows.get(i));
                this.directStreamOutput.write(text.getBytes(), 0, text.getLength());
                this.directLengthOutput.write(text.getLength());
            }
            this.rows.clear();
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.useDictionaryEncoding) {
                if (this.isDirectV2) {
                    return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DICTIONARY_V2).setDictionarySize(this.dictionary.size()).build();
                }
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DICTIONARY).setDictionarySize(this.dictionary.size()).build();
            }
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void createRowIndexEntry() throws IOException {
            this.getStripeStatistics().merge(this.indexStatistics);
            OrcProto.RowIndexEntry.Builder rowIndexEntry = this.getRowIndexEntry();
            rowIndexEntry.setStatistics(this.indexStatistics.serialize());
            this.indexStatistics.reset();
            OrcProto.RowIndexEntry base = rowIndexEntry.build();
            this.savedRowIndex.add(base);
            rowIndexEntry.clear();
            this.addBloomFilterEntry();
            this.recordPosition(this.rowIndexPosition);
            this.rowIndexValueCount.add(Long.valueOf(this.rows.size()));
            if (this.strideDictionaryCheck) {
                this.checkDictionaryEncoding();
            }
            if (!this.useDictionaryEncoding) {
                if (this.rows.size() > 0) {
                    this.flushDictionary();
                    this.recordDirectStreamPosition();
                } else {
                    this.recordDirectStreamPosition();
                    this.getRowIndex().addEntry(base);
                }
            }
        }

        private void recordDirectStreamPosition() throws IOException {
            this.directStreamOutput.getPosition(this.rowIndexPosition);
            this.directLengthOutput.getPosition(this.rowIndexPosition);
        }

        @Override
        long estimateMemory() {
            return (long)this.rows.getSizeInBytes() + this.dictionary.getSizeInBytes();
        }
    }

    private static class DoubleTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream stream;
        private final SerializationUtils utils;

        DoubleTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            this.stream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.utils = new SerializationUtils();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            block4: {
                DoubleColumnVector vec;
                block3: {
                    super.writeBatch(vector, offset, length);
                    vec = (DoubleColumnVector)vector;
                    if (!vector.isRepeating) break block3;
                    if (!vector.noNulls && vector.isNull[0]) break block4;
                    double value = vec.vector[0];
                    this.indexStatistics.updateDouble(value);
                    if (this.createBloomFilter) {
                        this.bloomFilter.addDouble(value);
                    }
                    for (int i = 0; i < length; ++i) {
                        this.utils.writeDouble(this.stream, value);
                    }
                    break block4;
                }
                for (int i = 0; i < length; ++i) {
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    double value = vec.vector[i + offset];
                    this.utils.writeDouble(this.stream, value);
                    this.indexStatistics.updateDouble(value);
                    if (!this.createBloomFilter) continue;
                    this.bloomFilter.addDouble(value);
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.stream.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.stream.getPosition(recorder);
        }
    }

    private static class FloatTreeWriter
    extends TreeWriter {
        private final PositionedOutputStream stream;
        private final SerializationUtils utils;

        FloatTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            this.stream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.utils = new SerializationUtils();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            block4: {
                DoubleColumnVector vec;
                block3: {
                    super.writeBatch(vector, offset, length);
                    vec = (DoubleColumnVector)vector;
                    if (!vector.isRepeating) break block3;
                    if (!vector.noNulls && vector.isNull[0]) break block4;
                    float value = (float)vec.vector[0];
                    this.indexStatistics.updateDouble(value);
                    if (this.createBloomFilter) {
                        this.bloomFilter.addDouble(value);
                    }
                    for (int i = 0; i < length; ++i) {
                        this.utils.writeFloat(this.stream, value);
                    }
                    break block4;
                }
                for (int i = 0; i < length; ++i) {
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    float value = (float)vec.vector[i + offset];
                    this.utils.writeFloat(this.stream, value);
                    this.indexStatistics.updateDouble(value);
                    if (!this.createBloomFilter) continue;
                    this.bloomFilter.addDouble(value);
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.stream.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.stream.getPosition(recorder);
        }
    }

    private static class IntegerTreeWriter
    extends TreeWriter {
        private final IntegerWriter writer;
        private boolean isDirectV2 = true;

        IntegerTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            OutStream out = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.isDirectV2 = this.isNewWriteFormat(writer);
            this.writer = this.createIntegerWriter(out, true, this.isDirectV2, writer);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        OrcProto.ColumnEncoding getEncoding() {
            if (this.isDirectV2) {
                return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2).build();
            }
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            block4: {
                LongColumnVector vec;
                block3: {
                    super.writeBatch(vector, offset, length);
                    vec = (LongColumnVector)vector;
                    if (!vector.isRepeating) break block3;
                    if (!vector.noNulls && vector.isNull[0]) break block4;
                    long value = vec.vector[0];
                    this.indexStatistics.updateInteger(value, length);
                    if (this.createBloomFilter) {
                        this.bloomFilter.addLong(value);
                    }
                    for (int i = 0; i < length; ++i) {
                        this.writer.write(value);
                    }
                    break block4;
                }
                for (int i = 0; i < length; ++i) {
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    long value = vec.vector[i + offset];
                    this.writer.write(value);
                    this.indexStatistics.updateInteger(value, 1);
                    if (!this.createBloomFilter) continue;
                    this.bloomFilter.addLong(value);
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.writer.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.writer.getPosition(recorder);
        }
    }

    private static class ByteTreeWriter
    extends TreeWriter {
        private final RunLengthByteWriter writer;

        ByteTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            this.writer = new RunLengthByteWriter(writer.createStream(this.id, OrcProto.Stream.Kind.DATA));
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            block4: {
                LongColumnVector vec;
                block3: {
                    super.writeBatch(vector, offset, length);
                    vec = (LongColumnVector)vector;
                    if (!vector.isRepeating) break block3;
                    if (!vector.noNulls && vector.isNull[0]) break block4;
                    byte value = (byte)vec.vector[0];
                    this.indexStatistics.updateInteger(value, length);
                    if (this.createBloomFilter) {
                        this.bloomFilter.addLong(value);
                    }
                    for (int i = 0; i < length; ++i) {
                        this.writer.write(value);
                    }
                    break block4;
                }
                for (int i = 0; i < length; ++i) {
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    byte value = (byte)vec.vector[i + offset];
                    this.writer.write(value);
                    this.indexStatistics.updateInteger(value, 1);
                    if (!this.createBloomFilter) continue;
                    this.bloomFilter.addLong(value);
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.writer.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.writer.getPosition(recorder);
        }
    }

    private static class BooleanTreeWriter
    extends TreeWriter {
        private final BitFieldWriter writer;

        BooleanTreeWriter(int columnId, TypeDescription schema, StreamFactory writer, boolean nullable) throws IOException {
            super(columnId, schema, writer, nullable);
            OutStream out = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
            this.writer = new BitFieldWriter(out, 1);
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            block3: {
                LongColumnVector vec;
                block2: {
                    super.writeBatch(vector, offset, length);
                    vec = (LongColumnVector)vector;
                    if (!vector.isRepeating) break block2;
                    if (!vector.noNulls && vector.isNull[0]) break block3;
                    int value = vec.vector[0] == 0L ? 0 : 1;
                    this.indexStatistics.updateBoolean(value != 0, length);
                    for (int i = 0; i < length; ++i) {
                        this.writer.write(value);
                    }
                    break block3;
                }
                for (int i = 0; i < length; ++i) {
                    if (!vec.noNulls && vec.isNull[i + offset]) continue;
                    int value = vec.vector[i + offset] == 0L ? 0 : 1;
                    this.writer.write(value);
                    this.indexStatistics.updateBoolean(value != 0, 1);
                }
            }
        }

        @Override
        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            super.writeStripe(builder, requiredIndexEntries);
            this.writer.flush();
            this.recordPosition(this.rowIndexPosition);
        }

        @Override
        void recordPosition(PositionRecorder recorder) throws IOException {
            super.recordPosition(recorder);
            this.writer.getPosition(recorder);
        }
    }

    private static abstract class TreeWriter {
        protected final int id;
        protected final BitFieldWriter isPresent;
        private final boolean isCompressed;
        protected final ColumnStatisticsImpl indexStatistics;
        protected final ColumnStatisticsImpl stripeColStatistics;
        private final ColumnStatisticsImpl fileStatistics;
        protected TreeWriter[] childrenWriters;
        protected final RowIndexPositionRecorder rowIndexPosition;
        private final OrcProto.RowIndex.Builder rowIndex;
        private final OrcProto.RowIndexEntry.Builder rowIndexEntry;
        private final PositionedOutputStream rowIndexStream;
        private final PositionedOutputStream bloomFilterStream;
        protected final BloomFilterIO bloomFilter;
        protected final boolean createBloomFilter;
        private final OrcProto.BloomFilterIndex.Builder bloomFilterIndex;
        private final OrcProto.BloomFilter.Builder bloomFilterEntry;
        private boolean foundNulls;
        private OutStream isPresentOutStream;
        private final List<OrcProto.StripeStatistics.Builder> stripeStatsBuilders;
        private final StreamFactory streamFactory;

        TreeWriter(int columnId, TypeDescription schema, StreamFactory streamFactory, boolean nullable) throws IOException {
            this.streamFactory = streamFactory;
            this.isCompressed = streamFactory.isCompressed();
            this.id = columnId;
            if (nullable) {
                this.isPresentOutStream = streamFactory.createStream(this.id, OrcProto.Stream.Kind.PRESENT);
                this.isPresent = new BitFieldWriter(this.isPresentOutStream, 1);
            } else {
                this.isPresent = null;
            }
            this.foundNulls = false;
            this.createBloomFilter = streamFactory.getBloomFilterColumns()[columnId];
            this.indexStatistics = ColumnStatisticsImpl.create(schema);
            this.stripeColStatistics = ColumnStatisticsImpl.create(schema);
            this.fileStatistics = ColumnStatisticsImpl.create(schema);
            this.childrenWriters = new TreeWriter[0];
            this.rowIndex = OrcProto.RowIndex.newBuilder();
            this.rowIndexEntry = OrcProto.RowIndexEntry.newBuilder();
            this.rowIndexPosition = new RowIndexPositionRecorder(this.rowIndexEntry);
            this.stripeStatsBuilders = Lists.newArrayList();
            this.rowIndexStream = streamFactory.buildIndex() ? streamFactory.createStream(this.id, OrcProto.Stream.Kind.ROW_INDEX) : null;
            if (this.createBloomFilter) {
                this.bloomFilterEntry = OrcProto.BloomFilter.newBuilder();
                this.bloomFilterIndex = OrcProto.BloomFilterIndex.newBuilder();
                this.bloomFilterStream = streamFactory.createStream(this.id, OrcProto.Stream.Kind.BLOOM_FILTER);
                this.bloomFilter = new BloomFilterIO(streamFactory.getRowIndexStride(), streamFactory.getBloomFilterFPP());
            } else {
                this.bloomFilterEntry = null;
                this.bloomFilterIndex = null;
                this.bloomFilterStream = null;
                this.bloomFilter = null;
            }
        }

        protected OrcProto.RowIndex.Builder getRowIndex() {
            return this.rowIndex;
        }

        protected ColumnStatisticsImpl getStripeStatistics() {
            return this.stripeColStatistics;
        }

        protected OrcProto.RowIndexEntry.Builder getRowIndexEntry() {
            return this.rowIndexEntry;
        }

        IntegerWriter createIntegerWriter(PositionedOutputStream output, boolean signed, boolean isDirectV2, StreamFactory writer) {
            if (isDirectV2) {
                boolean alignedBitpacking = false;
                if (writer.getEncodingStrategy().equals((Object)OrcFile.EncodingStrategy.SPEED)) {
                    alignedBitpacking = true;
                }
                return new RunLengthIntegerWriterV2(output, signed, alignedBitpacking);
            }
            return new RunLengthIntegerWriter(output, signed);
        }

        boolean isNewWriteFormat(StreamFactory writer) {
            return writer.getVersion() != OrcFile.Version.V_0_11;
        }

        void writeRootBatch(VectorizedRowBatch batch, int offset, int length) throws IOException {
            this.writeBatch(batch.cols[0], offset, length);
        }

        void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
            if (vector.noNulls) {
                this.indexStatistics.increment(length);
                if (this.isPresent != null) {
                    for (int i = 0; i < length; ++i) {
                        this.isPresent.write(1);
                    }
                }
            } else if (vector.isRepeating) {
                boolean isNull = vector.isNull[0];
                if (this.isPresent != null) {
                    for (int i = 0; i < length; ++i) {
                        this.isPresent.write(isNull ? 0 : 1);
                    }
                }
                if (isNull) {
                    this.foundNulls = true;
                    this.indexStatistics.setNull();
                } else {
                    this.indexStatistics.increment(length);
                }
            } else {
                int nonNullCount = 0;
                for (int i = 0; i < length; ++i) {
                    boolean isNull = vector.isNull[i + offset];
                    if (!isNull) {
                        ++nonNullCount;
                    }
                    if (this.isPresent == null) continue;
                    this.isPresent.write(isNull ? 0 : 1);
                }
                this.indexStatistics.increment(nonNullCount);
                if (nonNullCount != length) {
                    this.foundNulls = true;
                    this.indexStatistics.setNull();
                }
            }
        }

        private void removeIsPresentPositions() {
            for (int i = 0; i < this.rowIndex.getEntryCount(); ++i) {
                OrcProto.RowIndexEntry.Builder entry = this.rowIndex.getEntryBuilder(i);
                List<Long> positions = entry.getPositionsList();
                positions = positions.subList(this.isCompressed ? 4 : 3, positions.size());
                entry.clearPositions();
                entry.addAllPositions(positions);
            }
        }

        void writeStripe(OrcProto.StripeFooter.Builder builder, int requiredIndexEntries) throws IOException {
            if (this.isPresent != null) {
                this.isPresent.flush();
                if (!this.foundNulls) {
                    this.isPresentOutStream.suppress();
                    if (this.rowIndexStream != null) {
                        this.removeIsPresentPositions();
                    }
                }
            }
            OrcProto.StripeStatistics.Builder stripeStatsBuilder = OrcProto.StripeStatistics.newBuilder();
            this.writeStripeStatistics(stripeStatsBuilder, this);
            this.stripeStatsBuilders.add(stripeStatsBuilder);
            this.foundNulls = false;
            builder.addColumns(this.getEncoding());
            if (this.streamFactory.hasWriterTimeZone()) {
                builder.setWriterTimezone(TimeZone.getDefault().getID());
            }
            if (this.rowIndexStream != null) {
                if (this.rowIndex.getEntryCount() != requiredIndexEntries) {
                    throw new IllegalArgumentException("Column has wrong number of index entries found: " + this.rowIndex.getEntryCount() + " expected: " + requiredIndexEntries);
                }
                this.rowIndex.build().writeTo(this.rowIndexStream);
                this.rowIndexStream.flush();
            }
            this.rowIndex.clear();
            this.rowIndexEntry.clear();
            if (this.bloomFilterStream != null) {
                this.bloomFilterIndex.build().writeTo(this.bloomFilterStream);
                this.bloomFilterStream.flush();
                this.bloomFilterIndex.clear();
                this.bloomFilterEntry.clear();
            }
        }

        private void writeStripeStatistics(OrcProto.StripeStatistics.Builder builder, TreeWriter treeWriter) {
            treeWriter.fileStatistics.merge(treeWriter.stripeColStatistics);
            builder.addColStats(treeWriter.stripeColStatistics.serialize().build());
            treeWriter.stripeColStatistics.reset();
            for (TreeWriter child : treeWriter.getChildrenWriters()) {
                this.writeStripeStatistics(builder, child);
            }
        }

        TreeWriter[] getChildrenWriters() {
            return this.childrenWriters;
        }

        OrcProto.ColumnEncoding getEncoding() {
            return OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build();
        }

        void createRowIndexEntry() throws IOException {
            this.stripeColStatistics.merge(this.indexStatistics);
            this.rowIndexEntry.setStatistics(this.indexStatistics.serialize());
            this.indexStatistics.reset();
            this.rowIndex.addEntry(this.rowIndexEntry);
            this.rowIndexEntry.clear();
            this.addBloomFilterEntry();
            this.recordPosition(this.rowIndexPosition);
            for (TreeWriter child : this.childrenWriters) {
                child.createRowIndexEntry();
            }
        }

        void addBloomFilterEntry() {
            if (this.createBloomFilter) {
                this.bloomFilterEntry.setNumHashFunctions(this.bloomFilter.getNumHashFunctions());
                this.bloomFilterEntry.addAllBitset(Longs.asList(this.bloomFilter.getBitSet()));
                this.bloomFilterIndex.addBloomFilter(this.bloomFilterEntry.build());
                this.bloomFilter.reset();
                this.bloomFilterEntry.clear();
            }
        }

        void recordPosition(PositionRecorder recorder) throws IOException {
            if (this.isPresent != null) {
                this.isPresent.getPosition(recorder);
            }
        }

        long estimateMemory() {
            long result = 0L;
            for (TreeWriter child : this.childrenWriters) {
                result += child.estimateMemory();
            }
            return result;
        }
    }

    private class StreamFactory {
        private StreamFactory() {
        }

        public OutStream createStream(int column, OrcProto.Stream.Kind kind) throws IOException {
            EnumSet<CompressionCodec.Modifier> modifiers;
            StreamName name = new StreamName(column, kind);
            switch (kind) {
                case BLOOM_FILTER: 
                case DATA: 
                case DICTIONARY_DATA: {
                    if (this.getCompressionStrategy() == OrcFile.CompressionStrategy.SPEED) {
                        modifiers = EnumSet.of(CompressionCodec.Modifier.FAST, CompressionCodec.Modifier.TEXT);
                        break;
                    }
                    modifiers = EnumSet.of(CompressionCodec.Modifier.DEFAULT, CompressionCodec.Modifier.TEXT);
                    break;
                }
                case LENGTH: 
                case DICTIONARY_COUNT: 
                case PRESENT: 
                case ROW_INDEX: 
                case SECONDARY: {
                    modifiers = EnumSet.of(CompressionCodec.Modifier.FASTEST, CompressionCodec.Modifier.BINARY);
                    break;
                }
                default: {
                    LOG.warn("Missing ORC compression modifiers for " + kind);
                    modifiers = null;
                }
            }
            BufferedStream result = (BufferedStream)WriterImpl.this.streams.get(name);
            if (result == null) {
                result = new BufferedStream(name.toString(), WriterImpl.this.bufferSize, WriterImpl.this.codec == null ? WriterImpl.this.codec : WriterImpl.this.codec.modify(modifiers));
                WriterImpl.this.streams.put(name, result);
            }
            return result.outStream;
        }

        public int getNextColumnId() {
            return WriterImpl.this.columnCount++;
        }

        public int getRowIndexStride() {
            return WriterImpl.this.rowIndexStride;
        }

        public boolean buildIndex() {
            return WriterImpl.this.buildIndex;
        }

        public boolean isCompressed() {
            return WriterImpl.this.codec != null;
        }

        public OrcFile.EncodingStrategy getEncodingStrategy() {
            return WriterImpl.this.encodingStrategy;
        }

        public OrcFile.CompressionStrategy getCompressionStrategy() {
            return WriterImpl.this.compressionStrategy;
        }

        public boolean[] getBloomFilterColumns() {
            return WriterImpl.this.bloomFilterColumns;
        }

        public double getBloomFilterFPP() {
            return WriterImpl.this.bloomFilterFpp;
        }

        public Configuration getConfiguration() {
            return WriterImpl.this.conf;
        }

        public OrcFile.Version getVersion() {
            return WriterImpl.this.version;
        }

        public void useWriterTimeZone(boolean val) {
            WriterImpl.this.writeTimeZone = val;
        }

        public boolean hasWriterTimeZone() {
            return WriterImpl.this.writeTimeZone;
        }
    }

    private static class RowIndexPositionRecorder
    implements PositionRecorder {
        private final OrcProto.RowIndexEntry.Builder builder;

        RowIndexPositionRecorder(OrcProto.RowIndexEntry.Builder builder) {
            this.builder = builder;
        }

        @Override
        public void addPosition(long position) {
            this.builder.addPositions(position);
        }
    }

    private class DirectStream
    implements OutStream.OutputReceiver {
        private final FSDataOutputStream output;

        DirectStream(FSDataOutputStream output) {
            this.output = output;
        }

        @Override
        public void output(ByteBuffer buffer) throws IOException {
            this.output.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }
    }

    private class BufferedStream
    implements OutStream.OutputReceiver {
        private final OutStream outStream;
        private final List<ByteBuffer> output = new ArrayList<ByteBuffer>();

        BufferedStream(String name, int bufferSize, CompressionCodec codec) throws IOException {
            this.outStream = new OutStream(name, bufferSize, codec, this);
        }

        @Override
        public void output(ByteBuffer buffer) {
            this.output.add(buffer);
        }

        public long getBufferSize() {
            long result = 0L;
            for (ByteBuffer buf : this.output) {
                result += (long)buf.capacity();
            }
            return this.outStream.getBufferSize() + result;
        }

        public void flush() throws IOException {
            this.outStream.flush();
        }

        public void clear() throws IOException {
            this.outStream.clear();
            this.output.clear();
        }

        public boolean isSuppressed() {
            return this.outStream.isSuppressed();
        }

        public long getOutputSize() {
            long result = 0L;
            for (ByteBuffer buffer : this.output) {
                result += (long)buffer.remaining();
            }
            return result;
        }

        void spillTo(OutputStream out) throws IOException {
            for (ByteBuffer buffer : this.output) {
                out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            }
        }

        public String toString() {
            return this.outStream.toString();
        }
    }
}

