/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.jcr.RepositoryException;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.InMemoryDataStore;
import org.apache.jackrabbit.core.data.RandomInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestCaseBase
extends TestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(TestCaseBase.class);
    private static final String TEST_DIR = "target/temp";
    public static final String CONFIG = "config";
    protected String config;
    protected boolean memoryBackend = true;
    protected boolean noCache;
    protected int dataLength = 123456;
    protected String dataStoreDir;
    protected CachingDataStore ds;
    protected Random randomGen = new Random();

    protected void setUp() throws Exception {
        this.dataStoreDir = "target/temp-" + String.valueOf(this.randomGen.nextInt(9999)) + "-" + String.valueOf(this.randomGen.nextInt(9999));
        File directory = new File(this.dataStoreDir);
        if (directory.exists()) {
            boolean delSuccessFul = FileUtils.deleteQuietly((File)directory);
            int retry = 2;
            for (int count = 0; !delSuccessFul && count <= retry; ++count) {
                delSuccessFul = FileUtils.deleteQuietly((File)new File(this.dataStoreDir));
            }
            LOG.info("setup : directory [" + this.dataStoreDir + "] deleted [" + delSuccessFul + "]");
        }
    }

    protected void tearDown() {
        boolean delSuccessFul = FileUtils.deleteQuietly((File)new File(this.dataStoreDir));
        int retry = 2;
        for (int count = 0; !delSuccessFul && count <= retry; ++count) {
            delSuccessFul = FileUtils.deleteQuietly((File)new File(this.dataStoreDir));
        }
        LOG.info("tearDown : directory [" + this.dataStoreDir + "] deleted [" + delSuccessFul + "]");
    }

    public void testAddRecord() {
        try {
            long start = System.currentTimeMillis();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#addRecord, testDir=" + this.dataStoreDir);
            this.doAddRecordTest();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#addRecord finished, time taken = [" + (System.currentTimeMillis() - start) + "]ms");
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestCaseBase.fail((String)e.getMessage());
        }
    }

    public void testGetRecord() {
        try {
            long start = System.currentTimeMillis();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testGetRecord, testDir=" + this.dataStoreDir);
            this.doGetRecordTest();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testGetRecord finished, time taken = [" + (System.currentTimeMillis() - start) + "]ms");
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
        }
    }

    public void testGetAllIdentifiers() {
        try {
            long start = System.currentTimeMillis();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testGetAllIdentifiers, testDir=" + this.dataStoreDir);
            this.doGetAllIdentifiersTest();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testGetAllIdentifiers finished, time taken = [" + (System.currentTimeMillis() - start) + "]ms");
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestCaseBase.fail((String)e.getMessage());
        }
    }

    public void testUpdateLastModifiedOnAccess() {
        try {
            long start = System.currentTimeMillis();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testUpdateLastModifiedOnAccess, testDir=" + this.dataStoreDir);
            this.doUpdateLastModifiedOnAccessTest();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testUpdateLastModifiedOnAccess finished, time taken = [" + (System.currentTimeMillis() - start) + "]ms");
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
        }
    }

    public void testDeleteRecord() {
        try {
            long start = System.currentTimeMillis();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testDeleteRecord, testDir=" + this.dataStoreDir);
            this.doDeleteRecordTest();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testDeleteRecord finished, time taken = [" + (System.currentTimeMillis() - start) + "]ms");
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestCaseBase.fail((String)e.getMessage());
        }
    }

    public void testDeleteAllOlderThan() {
        try {
            long start = System.currentTimeMillis();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testDeleteAllOlderThan, testDir=" + this.dataStoreDir);
            this.doDeleteAllOlderThan();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testDeleteAllOlderThan finished, time taken = [" + (System.currentTimeMillis() - start) + "]ms");
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestCaseBase.fail((String)e.getMessage());
        }
    }

    public void testReference() {
        try {
            long start = System.currentTimeMillis();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testReference, testDir=" + this.dataStoreDir);
            this.doReferenceTest();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testReference finished, time taken = [" + (System.currentTimeMillis() - start) + "]ms");
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestCaseBase.fail((String)e.getMessage());
        }
    }

    public void testSingleThread() {
        try {
            long start = System.currentTimeMillis();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testSingleThread, testDir=" + this.dataStoreDir);
            this.doTestSingleThread();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testSingleThread finished, time taken = [" + (System.currentTimeMillis() - start) + "]ms");
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestCaseBase.fail((String)e.getMessage());
        }
    }

    public void testMultiThreaded() {
        try {
            long start = System.currentTimeMillis();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testMultiThreaded, testDir=" + this.dataStoreDir);
            this.doTestMultiThreaded();
            LOG.info("Testcase: " + ((Object)((Object)this)).getClass().getName() + "#testMultiThreaded finished, time taken = [" + (System.currentTimeMillis() - start) + "]ms");
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestCaseBase.fail((String)e.getMessage());
        }
    }

    protected CachingDataStore createDataStore() throws RepositoryException {
        this.ds = new InMemoryDataStore();
        this.ds.setConfig(this.config);
        if (this.noCache) {
            this.ds.setCacheSize(0L);
        }
        this.ds.init(this.dataStoreDir);
        return this.ds;
    }

    protected void doAddRecordTest() throws Exception {
        this.ds = this.createDataStore();
        byte[] data = new byte[this.dataLength];
        this.randomGen.nextBytes(data);
        DataRecord rec = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        TestCaseBase.assertEquals((long)data.length, (long)rec.getLength());
        this.assertRecord(data, rec);
        this.ds.close();
    }

    protected void doGetRecordTest() throws Exception {
        this.ds = this.createDataStore();
        byte[] data = new byte[this.dataLength];
        this.randomGen.nextBytes(data);
        DataRecord rec = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        rec = this.ds.getRecord(rec.getIdentifier());
        TestCaseBase.assertEquals((long)data.length, (long)rec.getLength());
        this.assertRecord(data, rec);
        this.ds.close();
    }

    protected void doDeleteRecordTest() throws Exception {
        this.ds = this.createDataStore();
        Random random = this.randomGen;
        byte[] data1 = new byte[this.dataLength];
        random.nextBytes(data1);
        DataRecord rec1 = this.ds.addRecord((InputStream)new ByteArrayInputStream(data1));
        byte[] data2 = new byte[this.dataLength];
        random.nextBytes(data2);
        DataRecord rec2 = this.ds.addRecord((InputStream)new ByteArrayInputStream(data2));
        byte[] data3 = new byte[this.dataLength];
        random.nextBytes(data3);
        DataRecord rec3 = this.ds.addRecord((InputStream)new ByteArrayInputStream(data3));
        this.ds.deleteRecord(rec2.getIdentifier());
        TestCaseBase.assertNull((String)"rec2 should be null", (Object)this.ds.getRecordIfStored(rec2.getIdentifier()));
        this.assertEquals(new ByteArrayInputStream(data1), this.ds.getRecord(rec1.getIdentifier()).getStream());
        this.assertEquals(new ByteArrayInputStream(data3), this.ds.getRecord(rec3.getIdentifier()).getStream());
        this.ds.close();
    }

    protected void doGetAllIdentifiersTest() throws Exception {
        this.ds = this.createDataStore();
        ArrayList<DataIdentifier> list = new ArrayList<DataIdentifier>();
        Random random = this.randomGen;
        byte[] data = new byte[this.dataLength];
        random.nextBytes(data);
        DataRecord rec = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        list.add(rec.getIdentifier());
        data = new byte[this.dataLength];
        random.nextBytes(data);
        rec = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        list.add(rec.getIdentifier());
        data = new byte[this.dataLength];
        random.nextBytes(data);
        rec = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        list.add(rec.getIdentifier());
        Iterator itr = this.ds.getAllIdentifiers();
        while (itr.hasNext()) {
            TestCaseBase.assertTrue((String)"record found on list", (boolean)list.remove(itr.next()));
        }
        TestCaseBase.assertEquals((int)0, (int)list.size());
        this.ds.close();
    }

    protected void doUpdateLastModifiedOnAccessTest() throws Exception {
        this.ds = this.createDataStore();
        Random random = this.randomGen;
        byte[] data = new byte[this.dataLength];
        random.nextBytes(data);
        DataRecord rec1 = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        data = new byte[this.dataLength];
        random.nextBytes(data);
        DataRecord rec2 = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        LOG.debug("rec2 timestamp=" + rec2.getLastModified());
        this.sleep(6000L);
        long updateTime = System.currentTimeMillis();
        LOG.debug("updateTime=" + updateTime);
        this.ds.updateModifiedDateOnAccess(updateTime);
        this.sleep(100L);
        data = new byte[this.dataLength];
        random.nextBytes(data);
        DataRecord rec3 = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        data = new byte[this.dataLength];
        random.nextBytes(data);
        DataRecord rec4 = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        rec1 = this.ds.getRecord(rec1.getIdentifier());
        TestCaseBase.assertEquals((String)"rec1 touched", (boolean)true, (this.ds.getLastModified(rec1.getIdentifier()) > updateTime ? 1 : 0) != 0);
        LOG.debug("rec2 timestamp=" + rec2.getLastModified());
        TestCaseBase.assertEquals((String)"rec2 not touched", (boolean)true, (this.ds.getLastModified(rec2.getIdentifier()) < updateTime ? 1 : 0) != 0);
        TestCaseBase.assertEquals((String)"rec3 touched", (boolean)true, (this.ds.getLastModified(rec3.getIdentifier()) > updateTime ? 1 : 0) != 0);
        TestCaseBase.assertEquals((String)"rec4 touched", (boolean)true, (this.ds.getLastModified(rec4.getIdentifier()) > updateTime ? 1 : 0) != 0);
        this.ds.close();
    }

    protected void doDeleteAllOlderThan() throws Exception {
        this.ds = this.createDataStore();
        Random random = this.randomGen;
        byte[] data = new byte[this.dataLength];
        random.nextBytes(data);
        DataRecord rec1 = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        data = new byte[this.dataLength];
        random.nextBytes(data);
        DataRecord rec2 = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        this.sleep(10000L);
        long updateTime = System.currentTimeMillis();
        this.ds.updateModifiedDateOnAccess(updateTime);
        this.sleep(100L);
        data = new byte[this.dataLength];
        random.nextBytes(data);
        DataRecord rec3 = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        data = new byte[this.dataLength];
        random.nextBytes(data);
        DataRecord rec4 = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        rec1 = this.ds.getRecord(rec1.getIdentifier());
        this.ds.clearInUse();
        TestCaseBase.assertEquals((String)"only rec2 should be deleted", (int)1, (int)this.ds.deleteAllOlderThan(updateTime));
        TestCaseBase.assertNull((String)"rec2 should be null", (Object)this.ds.getRecordIfStored(rec2.getIdentifier()));
        Iterator itr = this.ds.getAllIdentifiers();
        ArrayList<DataIdentifier> list = new ArrayList<DataIdentifier>();
        list.add(rec1.getIdentifier());
        list.add(rec3.getIdentifier());
        list.add(rec4.getIdentifier());
        while (itr.hasNext()) {
            TestCaseBase.assertTrue((String)"record found on list", (boolean)list.remove(itr.next()));
        }
        TestCaseBase.assertEquals((String)"touched records found", (int)0, (int)list.size());
        TestCaseBase.assertEquals((String)"rec1 touched", (boolean)true, (this.ds.getLastModified(rec1.getIdentifier()) > updateTime ? 1 : 0) != 0);
        TestCaseBase.assertEquals((String)"rec3 touched", (boolean)true, (this.ds.getLastModified(rec3.getIdentifier()) > updateTime ? 1 : 0) != 0);
        TestCaseBase.assertEquals((String)"rec4 touched", (boolean)true, (this.ds.getLastModified(rec4.getIdentifier()) > updateTime ? 1 : 0) != 0);
        this.ds.close();
    }

    public void doReferenceTest() throws Exception {
        this.ds = this.createDataStore();
        this.ds.setSecret("12345");
        byte[] data = new byte[this.dataLength];
        this.randomGen.nextBytes(data);
        DataRecord record = this.ds.addRecord((InputStream)new ByteArrayInputStream(data));
        String reference = record.getReference();
        this.assertReference(data, reference, (DataStore)this.ds);
        this.ds.close();
    }

    protected void doTestSingleThread() throws Exception {
        this.ds = this.createDataStore();
        this.doTestMultiThreaded((DataStore)this.ds, 1);
        this.ds.close();
    }

    protected void doTestMultiThreaded() throws Exception {
        this.ds = this.createDataStore();
        this.doTestMultiThreaded((DataStore)this.ds, 4);
        this.ds.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertRecord(byte[] expected, DataRecord record) throws DataStoreException, IOException {
        InputStream stream = record.getStream();
        try {
            for (int i = 0; i < expected.length; ++i) {
                TestCaseBase.assertEquals((int)(expected[i] & 0xFF), (int)stream.read());
            }
            TestCaseBase.assertEquals((int)-1, (int)stream.read());
        }
        finally {
            stream.close();
        }
    }

    protected void doTestMultiThreaded(final DataStore ds, int threadCount) throws Exception {
        int i;
        final Exception[] exception = new Exception[1];
        Thread[] threads = new Thread[threadCount];
        for (i = 0; i < threadCount; ++i) {
            Thread t;
            final int x = i;
            threads[i] = t = new Thread(){

                @Override
                public void run() {
                    try {
                        TestCaseBase.this.doTest(ds, x);
                    }
                    catch (Exception e) {
                        exception[0] = e;
                    }
                }
            };
            t.start();
        }
        for (i = 0; i < threadCount; ++i) {
            threads[i].join();
        }
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    void doTest(DataStore ds, int offset) throws Exception {
        DataRecord rec;
        ArrayList<DataRecord> list = new ArrayList<DataRecord>();
        HashMap<DataRecord, Integer> map = new HashMap<DataRecord, Integer>();
        for (int i = 0; i < 10; ++i) {
            int size = 100000 - i * 100;
            RandomInputStream in = new RandomInputStream(size + offset, size);
            rec = ds.addRecord((InputStream)in);
            list.add(rec);
            map.put(rec, new Integer(size));
        }
        Random random = new Random(1L);
        for (int i = 0; i < list.size(); ++i) {
            int pos = random.nextInt(list.size());
            rec = (DataRecord)list.get(pos);
            int size = (Integer)map.get(rec);
            rec = ds.getRecord(rec.getIdentifier());
            TestCaseBase.assertEquals((long)size, (long)rec.getLength());
            RandomInputStream expected = new RandomInputStream(size + offset, size);
            InputStream in = rec.getStream();
            byte[] buffer = new byte[1];
            in.read(buffer);
            in = new SequenceInputStream(new ByteArrayInputStream(buffer), in);
            if (random.nextBoolean()) {
                in = this.readInputStreamRandomly(in, random);
            }
            this.assertEquals(expected, in);
        }
    }

    InputStream readInputStreamRandomly(InputStream in, Random random) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8000];
        while (true) {
            int len;
            if (random.nextBoolean()) {
                int x = in.read();
                if (x < 0) break;
                out.write(x);
                continue;
            }
            if (random.nextBoolean()) {
                int l = in.read(buffer);
                if (l < 0) break;
                out.write(buffer, 0, l);
                continue;
            }
            int offset = random.nextInt(buffer.length / 2);
            int l = in.read(buffer, offset, len = random.nextInt(buffer.length / 2));
            if (l < 0) break;
            out.write(buffer, offset, l);
        }
        in.close();
        return new ByteArrayInputStream(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertEquals(InputStream a, InputStream b) throws IOException {
        try {
            TestCaseBase.assertTrue((String)"binary not equal", (boolean)IOUtils.contentEquals((InputStream)a, (InputStream)b));
        }
        finally {
            try {
                a.close();
            }
            catch (Exception ignore) {}
            try {
                b.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertReference(byte[] expected, String reference, DataStore store) throws Exception {
        DataRecord record = store.getRecordFromReference(reference);
        TestCaseBase.assertNotNull((Object)record);
        TestCaseBase.assertEquals((long)expected.length, (long)record.getLength());
        InputStream stream = record.getStream();
        try {
            TestCaseBase.assertTrue((String)"binary not equal", (boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream(expected), (InputStream)stream));
        }
        finally {
            stream.close();
        }
    }

    protected void sleep(long duration) {
        long expected = System.currentTimeMillis() + duration;
        while (System.currentTimeMillis() < expected) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ie) {}
        }
    }
}

