/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.io.InputStream;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.docker.domain.Config;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.ContainerSummary;
import org.jclouds.docker.domain.HostConfig;
import org.jclouds.docker.domain.Image;
import org.jclouds.docker.domain.Resource;
import org.jclouds.docker.domain.StatusCode;
import org.jclouds.docker.options.AttachOptions;
import org.jclouds.docker.options.CommitOptions;
import org.jclouds.docker.options.ListContainerOptions;
import org.jclouds.docker.options.RemoveContainerOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.binders.BindToJsonPayload;

@Consumes(value={"application/json"})
@Path(value="/v{jclouds.api-version}")
public interface ContainerApi {
    @Named(value="containers:list")
    @GET
    @Path(value="/containers/json")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<ContainerSummary> listContainers();

    @Named(value="containers:list")
    @GET
    @Path(value="/containers/json")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<ContainerSummary> listContainers(ListContainerOptions var1);

    @Named(value="container:create")
    @POST
    @Path(value="/containers/create")
    public Container createContainer(@QueryParam(value="name") String var1, @BinderParam(value=BindToJsonPayload.class) Config var2);

    @Named(value="container:inspect")
    @GET
    @Path(value="/containers/{id}/json")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Container inspectContainer(@PathParam(value="id") String var1);

    @Named(value="container:delete")
    @DELETE
    @Path(value="/containers/{id}")
    public void removeContainer(@PathParam(value="id") String var1);

    @Named(value="container:delete")
    @DELETE
    @Path(value="/containers/{id}")
    public void removeContainer(@PathParam(value="id") String var1, RemoveContainerOptions var2);

    @Named(value="container:start")
    @POST
    @Path(value="/containers/{id}/start")
    public void startContainer(@PathParam(value="id") String var1);

    @Named(value="container:start")
    @POST
    @Path(value="/containers/{id}/start")
    public void startContainer(@PathParam(value="id") String var1, @BinderParam(value=BindToJsonPayload.class) HostConfig var2);

    @Named(value="container:stop")
    @POST
    @Path(value="/containers/{id}/stop")
    public void stopContainer(@PathParam(value="id") String var1);

    @Named(value="container:stop")
    @POST
    @Path(value="/containers/{id}/stop")
    public void stopContainer(@PathParam(value="id") String var1, @QueryParam(value="t") int var2);

    @Named(value="container:commit")
    @POST
    @Path(value="/commit")
    public Image commit();

    @Named(value="container:commit")
    @POST
    @Path(value="/commit")
    public Image commit(CommitOptions var1);

    @Named(value="container:pause")
    @POST
    @Path(value="/containers/{id}/pause")
    public void pause(@PathParam(value="id") String var1);

    @Named(value="container:unpause")
    @POST
    @Path(value="/containers/{id}/unpause")
    public void unpause(@PathParam(value="id") String var1);

    @Named(value="container:attach")
    @POST
    @Path(value="/containers/{id}/attach")
    public InputStream attach(@PathParam(value="id") String var1);

    @Named(value="container:attach")
    @POST
    @Path(value="/containers/{id}/attach")
    public InputStream attach(@PathParam(value="id") String var1, AttachOptions var2);

    @Named(value="container:wait")
    @POST
    @Path(value="/containers/{id}/wait")
    public StatusCode wait(@PathParam(value="id") String var1);

    @Named(value="container:restart")
    @POST
    @Path(value="/containers/{id}/restart")
    public void restart(@PathParam(value="id") String var1);

    @Named(value="container:restart")
    @POST
    @Path(value="/containers/{id}/restart")
    public void restart(@PathParam(value="id") String var1, @QueryParam(value="t") int var2);

    @Named(value="container:kill")
    @POST
    @Path(value="/containers/{id}/kill")
    public void kill(@PathParam(value="id") String var1);

    @Named(value="container:kill")
    @POST
    @Path(value="/containers/{id}/kill")
    public void kill(@PathParam(value="id") String var1, @QueryParam(value="signal") int var2);

    @Named(value="container:kill")
    @POST
    @Path(value="/containers/{id}/kill")
    public void kill(@PathParam(value="id") String var1, @QueryParam(value="signal") String var2);

    @Named(value="container:copy")
    @POST
    @Path(value="/containers/{id}/copy")
    public InputStream copy(@PathParam(value="id") String var1, @BinderParam(value=BindToJsonPayload.class) Resource var2);
}

