/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Atomics;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.SlashEncodedIds;
import org.jclouds.googlecomputeengine.domain.internal.NetworkAndAddressRange;
import org.jclouds.googlecomputeengine.options.FirewallOptions;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.googlecomputeengine.predicates.NetworkFirewallPredicates;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.util.Predicates2;

public class GoogleComputeEngineSecurityGroupExtension
implements SecurityGroupExtension {
    protected final Supplier<String> userProject;
    protected final GroupNamingConvention.Factory namingConvention;
    protected final LoadingCache<NetworkAndAddressRange, Network> networkCreator;
    protected final Function<Network, SecurityGroup> groupConverter;
    protected final GoogleComputeEngineApi api;
    protected final Predicate<AtomicReference<Operation>> operationDonePredicate;
    protected final long operationCompleteCheckInterval;
    protected final long operationCompleteCheckTimeout;

    @Inject
    public GoogleComputeEngineSecurityGroupExtension(GoogleComputeEngineApi api, @UserProject Supplier<String> userProject, GroupNamingConvention.Factory namingConvention, LoadingCache<NetworkAndAddressRange, Network> networkCreator, Function<Network, SecurityGroup> groupConverter, @Named(value="global") Predicate<AtomicReference<Operation>> operationDonePredicate, @Named(value="jclouds.google-compute-engine.operation-complete-interval") Long operationCompleteCheckInterval, @Named(value="jclouds.google-compute-engine.operation-complete-timeout") Long operationCompleteCheckTimeout) {
        this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.userProject = (Supplier)Preconditions.checkNotNull(userProject, (Object)"userProject");
        this.namingConvention = (GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention");
        this.networkCreator = (LoadingCache)Preconditions.checkNotNull(networkCreator, (Object)"networkCreator");
        this.groupConverter = (Function)Preconditions.checkNotNull(groupConverter, (Object)"groupConverter");
        this.operationCompleteCheckInterval = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckInterval, (Object)"operation completed check interval");
        this.operationCompleteCheckTimeout = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckTimeout, (Object)"operation completed check timeout");
        this.operationDonePredicate = (Predicate)Preconditions.checkNotNull(operationDonePredicate, (Object)"operationDonePredicate");
    }

    public Set<SecurityGroup> listSecurityGroups() {
        return this.api.getNetworkApiForProject((String)this.userProject.get()).list().concat().transform(this.groupConverter).toSet();
    }

    public Set<SecurityGroup> listSecurityGroupsInLocation(Location location) {
        return this.listSecurityGroups();
    }

    public Set<SecurityGroup> listSecurityGroupsForNode(String id) {
        SlashEncodedIds slashEncodedIds = SlashEncodedIds.fromSlashEncoded(id);
        Instance instance = this.api.getInstanceApiForProject((String)this.userProject.get()).getInZone(slashEncodedIds.getFirstId(), slashEncodedIds.getSecondId());
        if (instance == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Instance.NetworkInterface nwInterface : instance.getNetworkInterfaces()) {
            String networkUrl = nwInterface.getNetwork().getPath();
            Network nw = this.api.getNetworkApiForProject((String)this.userProject.get()).get(networkUrl.substring(networkUrl.lastIndexOf(47) + 1));
            SecurityGroup grp = this.groupForTagsInNetwork(nw, instance.getTags().getItems());
            if (grp == null) continue;
            builder.add((Object)grp);
        }
        return builder.build();
    }

    public SecurityGroup getSecurityGroupById(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Network network = this.api.getNetworkApiForProject((String)this.userProject.get()).get(id);
        if (network == null) {
            return null;
        }
        return (SecurityGroup)this.groupConverter.apply((Object)network);
    }

    public SecurityGroup createSecurityGroup(String name, Location location) {
        return this.createSecurityGroup(name);
    }

    public SecurityGroup createSecurityGroup(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        NetworkAndAddressRange nAr = new NetworkAndAddressRange(name, "10.0.0.0/8", null);
        Network nw = (Network)this.networkCreator.apply((Object)nAr);
        return (SecurityGroup)this.groupConverter.apply((Object)nw);
    }

    public boolean removeSecurityGroup(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        if (this.api.getNetworkApiForProject((String)this.userProject.get()).get(id) == null) {
            return false;
        }
        ListOptions options = new ListOptions.Builder().filter("network eq .*/" + id);
        FluentIterable fws = this.api.getFirewallApiForProject((String)this.userProject.get()).list(options).concat();
        for (Firewall fw : fws) {
            AtomicReference operation = Atomics.newReference((Object)this.api.getFirewallApiForProject((String)this.userProject.get()).delete(fw.getName()));
            Predicates2.retry(this.operationDonePredicate, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)operation);
            Preconditions.checkState((!((Operation)operation.get()).getHttpError().isPresent() ? 1 : 0) != 0, (Object)("Could not delete firewall, operation failed" + operation));
        }
        AtomicReference operation = Atomics.newReference((Object)this.api.getNetworkApiForProject((String)this.userProject.get()).delete(id));
        Predicates2.retry(this.operationDonePredicate, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)operation);
        Preconditions.checkState((!((Operation)operation.get()).getHttpError().isPresent() ? 1 : 0) != 0, (Object)("Could not create network, operation failed" + operation));
        return true;
    }

    public SecurityGroup addIpPermission(IpPermission ipPermission, SecurityGroup group) {
        Preconditions.checkNotNull((Object)group, (Object)"group");
        Preconditions.checkNotNull((Object)ipPermission, (Object)"ipPermission");
        Preconditions.checkNotNull((Object)(this.api.getNetworkApiForProject((String)this.userProject.get()).get(group.getId()) == null ? 1 : 0), (Object)"network for group is null");
        ListOptions options = new ListOptions.Builder().filter("network eq .*/" + group.getName());
        if (this.api.getFirewallApiForProject((String)this.userProject.get()).list(options).concat().anyMatch(NetworkFirewallPredicates.providesIpPermission(ipPermission))) {
            return group;
        }
        FirewallOptions fwOptions = new FirewallOptions();
        String uniqueFwName = this.namingConvention.createWithoutPrefix().uniqueNameForGroup(group.getName());
        fwOptions.name(uniqueFwName);
        fwOptions.network(group.getUri());
        if (!ipPermission.getGroupIds().isEmpty()) {
            fwOptions.sourceTags(ipPermission.getGroupIds());
        }
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            fwOptions.sourceRanges(ipPermission.getCidrBlocks());
        }
        Firewall.Rule.Builder ruleBuilder = Firewall.Rule.builder();
        ruleBuilder.IpProtocol(ipPermission.getIpProtocol());
        if (ipPermission.getFromPort() > 0) {
            if (ipPermission.getFromPort() == ipPermission.getToPort()) {
                ruleBuilder.addPort(ipPermission.getToPort());
            } else {
                ruleBuilder.addPortRange(ipPermission.getFromPort(), ipPermission.getToPort());
            }
        }
        fwOptions.addAllowedRule(ruleBuilder.build());
        AtomicReference operation = Atomics.newReference((Object)this.api.getFirewallApiForProject((String)this.userProject.get()).createInNetwork(uniqueFwName, group.getUri(), fwOptions));
        Predicates2.retry(this.operationDonePredicate, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)operation);
        Preconditions.checkState((!((Operation)operation.get()).getHttpError().isPresent() ? 1 : 0) != 0, (Object)("Could not create firewall, operation failed" + operation));
        return this.getSecurityGroupById(group.getId());
    }

    public SecurityGroup addIpPermission(IpProtocol protocol, int fromPort, int toPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> cidrBlocks, Iterable<String> groupIds, SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(fromPort);
        permBuilder.toPort(toPort);
        permBuilder.groupIds(groupIds);
        permBuilder.cidrBlocks(cidrBlocks);
        return this.addIpPermission(permBuilder.build(), group);
    }

    public SecurityGroup removeIpPermission(IpPermission ipPermission, SecurityGroup group) {
        Preconditions.checkNotNull((Object)group, (Object)"group");
        Preconditions.checkNotNull((Object)ipPermission, (Object)"ipPermission");
        Preconditions.checkNotNull((Object)(this.api.getNetworkApiForProject((String)this.userProject.get()).get(group.getId()) == null ? 1 : 0), (Object)"network for group is null");
        ListOptions options = new ListOptions.Builder().filter("network eq .*/" + group.getName());
        FluentIterable fws = this.api.getFirewallApiForProject((String)this.userProject.get()).list(options).concat();
        for (Firewall fw : fws) {
            if (!NetworkFirewallPredicates.equalsIpPermission(ipPermission).apply((Object)fw)) continue;
            AtomicReference operation = Atomics.newReference((Object)this.api.getFirewallApiForProject((String)this.userProject.get()).delete(fw.getName()));
            Predicates2.retry(this.operationDonePredicate, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)operation);
            Preconditions.checkState((!((Operation)operation.get()).getHttpError().isPresent() ? 1 : 0) != 0, (Object)("Could not delete firewall, operation failed" + operation));
        }
        return this.getSecurityGroupById(group.getId());
    }

    public SecurityGroup removeIpPermission(IpProtocol protocol, int fromPort, int toPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> cidrBlocks, Iterable<String> groupIds, SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(fromPort);
        permBuilder.toPort(toPort);
        permBuilder.groupIds(groupIds);
        permBuilder.cidrBlocks(cidrBlocks);
        return this.removeIpPermission(permBuilder.build(), group);
    }

    public boolean supportsTenantIdGroupNamePairs() {
        return false;
    }

    public boolean supportsTenantIdGroupIdPairs() {
        return false;
    }

    public boolean supportsGroupIds() {
        return true;
    }

    public boolean supportsPortRangesForGroups() {
        return true;
    }

    private SecurityGroup groupForTagsInNetwork(Network nw, final Set<String> tags) {
        ListOptions opts = new ListOptions.Builder().filter("network eq .*/" + nw.getName());
        ImmutableSet fws = this.api.getFirewallApiForProject((String)this.userProject.get()).list(opts).concat().filter((Predicate)new Predicate<Firewall>(){

            public boolean apply(Firewall input) {
                return Iterables.any(input.getTargetTags(), (Predicate)Predicates.in((Collection)tags)) || Predicates.equalTo((Object)0).apply((Object)input.getTargetTags().size());
            }
        }).toSet();
        if (fws.isEmpty()) {
            return null;
        }
        return (SecurityGroup)this.groupConverter.apply((Object)nw);
    }
}

