/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class FirewallToIpPermission
implements Function<Firewall, Iterable<IpPermission>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    public Iterable<IpPermission> apply(Firewall fw) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (Firewall.Rule rule : fw.getAllowed()) {
            if (!rule.getPorts().isEmpty()) {
                for (Range r : rule.getPorts().asRanges()) {
                    IpPermission.Builder builder = this.populateBuilder(fw, rule.getIpProtocol());
                    builder.fromPort(((Integer)r.lowerEndpoint()).intValue());
                    builder.toPort(((Integer)r.upperEndpoint()).intValue());
                    setBuilder.add((Object)builder.build());
                }
                continue;
            }
            setBuilder.add((Object)this.populateBuilder(fw, rule.getIpProtocol()).build());
        }
        return setBuilder.build();
    }

    private IpPermission.Builder populateBuilder(Firewall fw, IpProtocol protocol) {
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(protocol);
        if (!fw.getSourceRanges().isEmpty()) {
            builder.cidrBlocks(fw.getSourceRanges());
        }
        if (!fw.getSourceTags().isEmpty()) {
            builder.groupIds(fw.getSourceTags());
        }
        return builder;
    }
}

