/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.predicates.NodePredicates;

@Singleton
public class AllNodesInGroupTerminated
implements Predicate<String> {
    private final ComputeService computeService;

    @Inject
    public AllNodesInGroupTerminated(ComputeService computeService) {
        this.computeService = (ComputeService)Preconditions.checkNotNull((Object)computeService, (Object)"compute service");
    }

    public boolean apply(String groupName) {
        return Iterables.all((Iterable)Sets.filter((Set)this.computeService.listNodesDetailsMatching(NodePredicates.all()), (Predicate)NodePredicates.inGroup((String)groupName)), (Predicate)NodePredicates.TERMINATED);
    }
}

