/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.functions.FirewallTagNamingConvention;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.internal.NetworkAndAddressRange;
import org.jclouds.googlecomputeengine.features.FirewallApi;
import org.jclouds.googlecomputeengine.options.FirewallOptions;
import org.jclouds.util.Predicates2;

public class CreateNodesWithGroupEncodedIntoNameThenAddToSet
extends org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    public static final String EXTERIOR_RANGE = "0.0.0.0/0";
    public static final String DEFAULT_INTERNAL_NETWORK_RANGE = "10.0.0.0/8";
    private final GoogleComputeEngineApi api;
    private final Supplier<String> userProject;
    private final LoadingCache<NetworkAndAddressRange, Network> networkMap;
    private final Predicate<AtomicReference<Operation>> operationDonePredicate;
    private final long operationCompleteCheckInterval;
    private final long operationCompleteCheckTimeout;
    private final FirewallTagNamingConvention.Factory firewallTagNamingConvention;

    @Inject
    protected CreateNodesWithGroupEncodedIntoNameThenAddToSet(CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, GoogleComputeEngineApi api, @UserProject Supplier<String> userProject, @Named(value="global") Predicate<AtomicReference<Operation>> operationDonePredicate, @Named(value="jclouds.google-compute-engine.operation-complete-interval") Long operationCompleteCheckInterval, @Named(value="jclouds.google-compute-engine.operation-complete-timeout") Long operationCompleteCheckTimeout, LoadingCache<NetworkAndAddressRange, Network> networkMap, FirewallTagNamingConvention.Factory firewallTagNamingConvention) {
        super(addNodeWithGroupStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"google compute api");
        this.userProject = (Supplier)Preconditions.checkNotNull(userProject, (Object)"user project name");
        this.operationCompleteCheckInterval = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckInterval, (Object)"operation completed check interval");
        this.operationCompleteCheckTimeout = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckTimeout, (Object)"operation completed check timeout");
        this.operationDonePredicate = (Predicate)Preconditions.checkNotNull(operationDonePredicate, (Object)"operationDonePredicate");
        this.networkMap = (LoadingCache)Preconditions.checkNotNull(networkMap, (Object)"networkMap");
        this.firewallTagNamingConvention = (FirewallTagNamingConvention.Factory)Preconditions.checkNotNull((Object)firewallTagNamingConvention, (Object)"firewallTagNamingConvention");
    }

    public synchronized Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        String sharedResourceName = this.namingConvention.create().sharedNameForGroup(group);
        Template mutableTemplate = template.clone();
        GoogleComputeEngineTemplateOptions templateOptions = (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(mutableTemplate.getOptions()));
        assert (template.getOptions().equals((Object)templateOptions)) : "options didn't clone properly";
        Network network = this.getOrCreateNetwork(templateOptions, sharedResourceName);
        this.getOrCreateFirewalls(templateOptions, network, this.firewallTagNamingConvention.get(group));
        templateOptions.network(network.getSelfLink());
        templateOptions.userMetadata("jclouds-group", group);
        return super.execute(group, count, mutableTemplate, goodNodes, badNodes, customizationResponses);
    }

    private Network getOrCreateNetwork(GoogleComputeEngineTemplateOptions templateOptions, String sharedResourceName) {
        String networkName = (String)templateOptions.getNetworkName().or((Object)sharedResourceName);
        return (Network)this.networkMap.apply((Object)new NetworkAndAddressRange(networkName, DEFAULT_INTERNAL_NETWORK_RANGE, null));
    }

    private void getOrCreateFirewalls(GoogleComputeEngineTemplateOptions templateOptions, Network network, FirewallTagNamingConvention naming) {
        String projectName = (String)this.userProject.get();
        FirewallApi firewallApi = this.api.getFirewallApiForProject(projectName);
        HashSet operations = Sets.newHashSet();
        int[] arr$ = templateOptions.getInboundPorts();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer port = arr$[i$];
            String name = naming.name(port);
            Firewall firewall = firewallApi.get(name);
            if (firewall != null) continue;
            ImmutableSet rules = ImmutableSet.of((Object)Firewall.Rule.permitTcpRule(port), (Object)Firewall.Rule.permitUdpRule(port));
            FirewallOptions firewallOptions = new FirewallOptions().name(name).network(network.getSelfLink()).allowedRules((Set<Firewall.Rule>)rules).sourceTags(templateOptions.getTags()).sourceRanges((Set<String>)ImmutableSet.of((Object)DEFAULT_INTERNAL_NETWORK_RANGE, (Object)EXTERIOR_RANGE)).targetTags((Set<String>)ImmutableSet.of((Object)name));
            AtomicReference operation = Atomics.newReference((Object)firewallApi.createInNetwork(firewallOptions.getName(), network.getSelfLink(), firewallOptions));
            operations.add(operation);
        }
        for (AtomicReference operation : operations) {
            Predicates2.retry(this.operationDonePredicate, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)operation);
            Preconditions.checkState((!((Operation)operation.get()).getHttpError().isPresent() ? 1 : 0) != 0, (Object)("Could not create firewall, operation failed" + operation));
        }
    }
}

