/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import org.jclouds.googlecomputeengine.domain.Resource;

@Beta
public final class Address
extends Resource {
    private final String status;
    private final Optional<URI> user;
    private final URI region;
    private final String address;

    @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "status", "user", "region", "address"})
    private Address(String id, Date creationTimestamp, URI selfLink, String name, String description, String status, URI user, URI region, String address) {
        super(Resource.Kind.ADDRESS, id, creationTimestamp, selfLink, name, description);
        this.status = (String)Preconditions.checkNotNull((Object)status, (String)"status of %s", (Object[])new Object[]{name});
        this.user = Optional.fromNullable((Object)user);
        this.region = (URI)Preconditions.checkNotNull((Object)region, (String)"region of %s", (Object[])new Object[]{name});
        this.address = (String)Preconditions.checkNotNull((Object)address, (String)"address of %s", (Object[])new Object[]{name});
    }

    public String getStatus() {
        return this.status;
    }

    public Optional<URI> getUser() {
        return this.user;
    }

    public URI getRegion() {
        return this.region;
    }

    public String getAddress() {
        return this.address;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Address that = (Address)Address.class.cast(obj);
        return Objects.equal((Object)((Object)this.kind), (Object)((Object)that.kind)) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.region, (Object)that.region);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().omitNullValues().add("status", (Object)this.status).add("user", this.user.orNull()).add("region", (Object)this.region).add("address", (Object)this.address);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromAddress(this);
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private String status;
        private URI user;
        private URI region;
        private String address;

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder user(URI user) {
            this.user = user;
            return this;
        }

        public Builder region(URI region) {
            this.region = region;
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Address build() {
            return new Address(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.status, this.user, this.region, this.address);
        }

        public Builder fromAddress(Address in) {
            return ((Builder)super.fromResource(in)).status(in.getStatus()).user((URI)in.getUser().orNull()).region(in.getRegion()).address(in.getAddress());
        }
    }
}

