/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import org.jclouds.googlecomputeengine.domain.AbstractDisk;
import org.jclouds.googlecomputeengine.domain.Resource;

@Beta
public final class Disk
extends AbstractDisk {
    private final URI zone;

    @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "sizeGb", "zone", "status"})
    private Disk(String id, Date creationTimestamp, URI selfLink, String name, String description, Integer sizeGb, URI zone, String status) {
        super(Resource.Kind.DISK, id, creationTimestamp, selfLink, name, description, sizeGb, status);
        this.zone = (URI)Preconditions.checkNotNull((Object)zone, (String)"zone of %s", (Object[])new Object[]{name});
    }

    public URI getZone() {
        return this.zone;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Disk that = (Disk)Disk.class.cast(obj);
        return Objects.equal((Object)((Object)this.kind), (Object)((Object)that.kind)) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.zone, (Object)that.zone);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().omitNullValues().add("zone", (Object)this.zone);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder().fromDisk(this);
    }

    public static final class Builder
    extends AbstractDisk.Builder<Builder> {
        private URI zone;

        public Builder zone(URI zone) {
            this.zone = zone;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Disk build() {
            return new Disk(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.sizeGb, this.zone, this.status);
        }

        public Builder fromDisk(Disk in) {
            return ((Builder)super.fromAbstractDisk(in)).zone(in.getZone());
        }
    }
}

