/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import org.jclouds.googlecomputeengine.domain.Metadata;
import org.jclouds.googlecomputeengine.domain.Resource;
import org.jclouds.javax.annotation.Nullable;

@Beta
public class Instance
extends Resource {
    protected final Tags tags;
    protected final URI machineType;
    protected final Status status;
    protected final Optional<String> statusMessage;
    protected final URI zone;
    protected final Set<NetworkInterface> networkInterfaces;
    protected final Set<AttachedDisk> disks;
    protected final Metadata metadata;
    protected final Set<ServiceAccount> serviceAccounts;

    protected Instance(String id, Date creationTimestamp, URI selfLink, String name, String description, Tags tags, URI machineType, Status status, String statusMessage, URI zone, Set<NetworkInterface> networkInterfaces, Set<AttachedDisk> disks, Metadata metadata, Set<ServiceAccount> serviceAccounts) {
        super(Resource.Kind.INSTANCE, id, creationTimestamp, selfLink, name, description);
        this.tags = (Tags)Preconditions.checkNotNull((Object)tags, (Object)"tags");
        this.machineType = (URI)Preconditions.checkNotNull((Object)machineType, (String)"machineType of %s", (Object[])new Object[]{name});
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.statusMessage = Optional.fromNullable((Object)statusMessage);
        this.zone = (URI)Preconditions.checkNotNull((Object)zone, (String)"zone of %s", (Object[])new Object[]{name});
        this.networkInterfaces = networkInterfaces == null ? ImmutableSet.of() : networkInterfaces;
        this.disks = disks == null ? ImmutableSet.of() : disks;
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        this.serviceAccounts = serviceAccounts == null ? ImmutableSet.of() : serviceAccounts;
    }

    public Tags getTags() {
        return this.tags;
    }

    public URI getMachineType() {
        return this.machineType;
    }

    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public Optional<String> getStatusMessage() {
        return this.statusMessage;
    }

    public URI getZone() {
        return this.zone;
    }

    public Set<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public Set<AttachedDisk> getDisks() {
        return this.disks;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Set<ServiceAccount> getServiceAccounts() {
        return this.serviceAccounts;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Instance that = (Instance)Instance.class.cast(obj);
        return Objects.equal((Object)((Object)this.kind), (Object)((Object)that.kind)) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.zone, (Object)that.zone);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().omitNullValues().add("items", (Object)this.tags).add("machineType", (Object)this.machineType).add("status", (Object)this.status).add("statusMessage", this.statusMessage.orNull()).add("zone", (Object)this.zone).add("networkInterfaces", this.networkInterfaces).add("disks", this.disks).add("metadata", (Object)this.metadata).add("serviceAccounts", this.serviceAccounts);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromInstance(this);
    }

    public static final class ServiceAccount {
        private final String email;
        private final Set<String> scopes;

        @ConstructorProperties(value={"email", "scopes"})
        public ServiceAccount(String email, Set<String> scopes) {
            this.email = (String)Preconditions.checkNotNull((Object)email, (Object)"email");
            this.scopes = (Set)Preconditions.checkNotNull(scopes, (Object)"scopes");
        }

        public String getEmail() {
            return this.email;
        }

        public Set<String> getScopes() {
            return this.scopes;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.email, this.scopes});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceAccount that = (ServiceAccount)ServiceAccount.class.cast(obj);
            return Objects.equal((Object)this.email, (Object)that.email) && Objects.equal(this.scopes, that.scopes);
        }

        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).add("email", (Object)this.email).add("scopes", this.scopes);
        }

        public String toString() {
            return this.string().toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return ServiceAccount.builder().fromInstanceServiceAccount(this);
        }

        public static final class Builder {
            private String email;
            private ImmutableSet.Builder<String> scopes = ImmutableSet.builder();

            public Builder email(String email) {
                this.email = (String)Preconditions.checkNotNull((Object)email);
                return this;
            }

            public Builder addScopes(String scopes) {
                this.scopes.add((Object)scopes);
                return this;
            }

            public Builder scopes(Set<String> scopes) {
                this.scopes.addAll(scopes);
                return this;
            }

            public ServiceAccount build() {
                return new ServiceAccount(this.email, (Set<String>)this.scopes.build());
            }

            public Builder fromInstanceServiceAccount(ServiceAccount in) {
                return this.email(in.getEmail()).scopes(in.getScopes());
            }
        }
    }

    public static final class SerialPortOutput {
        private final Optional<String> selfLink;
        private final String contents;

        @ConstructorProperties(value={"selfLink", "contents"})
        public SerialPortOutput(String selfLink, String contents) {
            this.selfLink = Optional.fromNullable((Object)selfLink);
            this.contents = (String)Preconditions.checkNotNull((Object)contents, (Object)"contents");
        }

        public Optional<String> getSelfLink() {
            return this.selfLink;
        }

        public String getContents() {
            return this.contents;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.selfLink, this.contents});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SerialPortOutput that = (SerialPortOutput)SerialPortOutput.class.cast(obj);
            return Objects.equal(this.selfLink, that.selfLink);
        }

        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).add("selfLink", this.selfLink).add("contents", (Object)this.contents);
        }

        public String toString() {
            return this.string().toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return SerialPortOutput.builder().fromInstanceSerialPortOutput(this);
        }

        public static final class Builder {
            private String selfLink;
            private String contents;

            public Builder selfLink(String selfLink) {
                this.selfLink = (String)Preconditions.checkNotNull((Object)selfLink);
                return this;
            }

            public Builder contents(String contents) {
                this.contents = contents;
                return this;
            }

            public SerialPortOutput build() {
                return new SerialPortOutput(this.selfLink, this.contents);
            }

            public Builder fromInstanceSerialPortOutput(SerialPortOutput in) {
                return this.selfLink((String)in.getSelfLink().orNull()).contents(in.getContents());
            }
        }
    }

    public static final class NetworkInterface {
        private final String name;
        private final URI network;
        private final Optional<String> networkIP;
        private final Set<AccessConfig> accessConfigs;

        @ConstructorProperties(value={"name", "network", "networkIP", "accessConfigs"})
        private NetworkInterface(String name, URI network, String networkIP, Set<AccessConfig> accessConfigs) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.network = (URI)Preconditions.checkNotNull((Object)network, (Object)"network");
            this.networkIP = Optional.fromNullable((Object)networkIP);
            this.accessConfigs = accessConfigs == null ? ImmutableSet.of() : accessConfigs;
        }

        public String getName() {
            return this.name;
        }

        public URI getNetwork() {
            return this.network;
        }

        public Optional<String> getNetworkIP() {
            return this.networkIP;
        }

        public Set<AccessConfig> getAccessConfigs() {
            return this.accessConfigs;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.network, this.networkIP, this.accessConfigs});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkInterface that = (NetworkInterface)NetworkInterface.class.cast(obj);
            return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.network, (Object)that.network);
        }

        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("network", (Object)this.network).add("networkIP", this.networkIP).add("accessConfigs", this.accessConfigs);
        }

        public String toString() {
            return this.string().toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return NetworkInterface.builder().fromNetworkInterface(this);
        }

        public static final class AccessConfig {
            private Optional<String> name;
            private Type type;
            private Optional<String> natIP;

            @ConstructorProperties(value={"name", "type", "natIP"})
            private AccessConfig(String name, Type type, String natIP) {
                this.name = Optional.fromNullable((Object)name);
                this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
                this.natIP = Optional.fromNullable((Object)natIP);
            }

            public Optional<String> getName() {
                return this.name;
            }

            public Type getType() {
                return this.type;
            }

            @Nullable
            public Optional<String> getNatIP() {
                return this.natIP;
            }

            public int hashCode() {
                return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.natIP});
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                AccessConfig that = (AccessConfig)AccessConfig.class.cast(obj);
                return Objects.equal(this.name, that.name) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal(this.natIP, that.natIP);
            }

            protected Objects.ToStringHelper string() {
                return Objects.toStringHelper((Object)this).add("name", this.name).add("type", (Object)this.type).add("natIP", this.natIP);
            }

            public String toString() {
                return this.string().toString();
            }

            public static Builder builder() {
                return new Builder();
            }

            public Builder toBuilder() {
                return AccessConfig.builder().fromAccessConfig(this);
            }

            public static class Builder {
                private String name;
                private Type type;
                private String natIP;

                public Builder name(String name) {
                    this.name = name;
                    return this;
                }

                public Builder type(Type type) {
                    this.type = type;
                    return this;
                }

                public Builder natIP(String natIP) {
                    this.natIP = natIP;
                    return this;
                }

                public AccessConfig build() {
                    return new AccessConfig(this.name, this.type, this.natIP);
                }

                public Builder fromAccessConfig(AccessConfig in) {
                    return this.name((String)in.getName().orNull()).type(in.getType()).natIP((String)in.getNatIP().orNull());
                }
            }

            public static enum Type {
                ONE_TO_ONE_NAT;

            }
        }

        public static class Builder {
            private String name;
            private URI network;
            private String networkIP;
            private ImmutableSet.Builder<AccessConfig> accessConfigs = ImmutableSet.builder();

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder network(URI network) {
                this.network = network;
                return this;
            }

            public Builder networkIP(String networkIP) {
                this.networkIP = networkIP;
                return this;
            }

            public Builder addAccessConfig(AccessConfig accessConfig) {
                this.accessConfigs.add((Object)accessConfig);
                return this;
            }

            public Builder accessConfigs(Set<AccessConfig> accessConfigs) {
                this.accessConfigs = ImmutableSet.builder();
                this.accessConfigs.addAll(accessConfigs);
                return this;
            }

            public NetworkInterface build() {
                return new NetworkInterface(this.name, this.network, this.networkIP, (Set)this.accessConfigs.build());
            }

            public Builder fromNetworkInterface(NetworkInterface in) {
                return this.network(in.getNetwork()).networkIP((String)in.getNetworkIP().orNull()).accessConfigs(in.getAccessConfigs());
            }
        }
    }

    public static class PersistentAttachedDisk
    extends AttachedDisk {
        private final Mode mode;
        private final URI source;
        private final boolean deleteOnTerminate;
        private final Optional<String> deviceName;
        private final boolean boot;

        @ConstructorProperties(value={"mode", "source", "deviceName", "index", "deleteOnTerminate", "boot"})
        public PersistentAttachedDisk(Mode mode, URI source, String deviceName, Integer index, boolean deleteOnTerminate, boolean boot) {
            super(index);
            this.mode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode"));
            this.source = (URI)Preconditions.checkNotNull((Object)source, (Object)"source");
            this.deviceName = Optional.fromNullable((Object)deviceName);
            this.deleteOnTerminate = deleteOnTerminate;
            this.boot = boot;
        }

        @Override
        public boolean isPersistent() {
            return true;
        }

        public Mode getMode() {
            return this.mode;
        }

        public URI getSource() {
            return this.source;
        }

        public String getSourceDiskName() {
            return (String)Iterables.getLast((Iterable)Splitter.on((String)"/").split((CharSequence)this.source.toString()), null);
        }

        public Optional<String> getDeviceName() {
            return this.deviceName;
        }

        public boolean isDeleteOnTerminate() {
            return this.deleteOnTerminate;
        }

        public boolean isBoot() {
            return this.boot;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).add("boot", this.boot);
        }

        public static final class Builder {
            private Mode mode;
            private URI source;
            private String deviceName;
            private Integer index;
            private boolean deleteOnTerminate;
            private boolean boot;

            public Builder mode(Mode mode) {
                this.mode = mode;
                return this;
            }

            public Builder source(URI source) {
                this.source = source;
                return this;
            }

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder index(Integer index) {
                this.index = index;
                return this;
            }

            public Builder deleteOnTerminate(Boolean deleteOnTerminate) {
                this.deleteOnTerminate = deleteOnTerminate;
                return this;
            }

            public Builder boot(Boolean boot) {
                this.boot = boot;
                return this;
            }

            public PersistentAttachedDisk build() {
                return new PersistentAttachedDisk(this.mode, this.source, this.deviceName, this.index, this.deleteOnTerminate, this.boot);
            }

            public Builder fromPersistentAttachedDisk(PersistentAttachedDisk in) {
                return this.mode(in.getMode()).source(in.getSource()).deviceName((String)in.getDeviceName().orNull()).index(in.getIndex()).deleteOnTerminate(in.isDeleteOnTerminate()).boot(in.isBoot());
            }
        }

        public static enum Mode {
            READ_WRITE,
            READ_ONLY;

        }
    }

    public static class AttachedDisk {
        private final int index;

        public AttachedDisk(Integer index) {
            this.index = (Integer)Preconditions.checkNotNull((Object)index, (Object)"index");
        }

        public boolean isPersistent() {
            return false;
        }

        public int getIndex() {
            return this.index;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.index});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AttachedDisk that = (AttachedDisk)AttachedDisk.class.cast(obj);
            return Objects.equal((Object)this.index, (Object)that.index);
        }

        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).add("index", this.index);
        }

        public String toString() {
            return this.string().toString();
        }

        public static AttachedDisk ephemeralDiskAtIndex(Integer index) {
            return new AttachedDisk(index);
        }
    }

    public static class Tags {
        private final String fingerprint;
        private final Set<String> items;

        @ConstructorProperties(value={"fingerprint", "items"})
        public Tags(String fingerprint, @Nullable Set<String> items) {
            this.fingerprint = (String)Preconditions.checkNotNull((Object)fingerprint);
            this.items = items == null ? ImmutableSet.of() : items;
        }

        public Set<String> getItems() {
            return this.items;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.fingerprint, this.items});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Tags that = (Tags)Tags.class.cast(obj);
            return Objects.equal(this.items, that.items) && Objects.equal((Object)this.fingerprint, (Object)that.fingerprint);
        }

        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).add("items", this.items).add("fingerprint", (Object)this.fingerprint);
        }

        public static Builder builder() {
            return new Builder();
        }

        public String toString() {
            return this.string().toString();
        }

        public static final class Builder {
            private ImmutableSet.Builder<String> items = ImmutableSet.builder();
            private String fingerprint;

            public Builder addItem(String item) {
                this.items.add((Object)item);
                return this;
            }

            public Builder items(Set<String> items) {
                this.items.addAll(items);
                return this;
            }

            public Builder fingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
                return this;
            }

            public Tags build() {
                return new Tags(this.fingerprint, (Set<String>)this.items.build());
            }

            public Builder fromTags(Tags in) {
                return this.fingerprint(in.getFingerprint()).items(in.getItems());
            }
        }
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private Tags tags;
        private URI machineType;
        private Status status;
        private String statusMessage;
        private URI zone;
        private Metadata metadata;
        private ImmutableSet.Builder<NetworkInterface> networkInterfaces = ImmutableSet.builder();
        private ImmutableSet.Builder<AttachedDisk> disks = ImmutableSet.builder();
        private ImmutableSet.Builder<ServiceAccount> serviceAccounts = ImmutableSet.builder();

        public Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public Builder machineType(URI machineType) {
            this.machineType = machineType;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Builder zone(URI zone) {
            this.zone = zone;
            return this;
        }

        public Builder addNetworkInterface(NetworkInterface networkInterface) {
            this.networkInterfaces.add((Object)networkInterface);
            return this;
        }

        public Builder networkInterfaces(Set<NetworkInterface> networkInterfaces) {
            this.networkInterfaces.addAll(networkInterfaces);
            return this;
        }

        public Builder addDisk(AttachedDisk disk) {
            this.disks.add((Object)disk);
            return this;
        }

        public Builder disks(Set<AttachedDisk> disks) {
            this.disks.addAll(disks);
            return this;
        }

        public Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder addServiceAccount(ServiceAccount serviceAccount) {
            this.serviceAccounts.add((Object)serviceAccount);
            return this;
        }

        public Builder serviceAccounts(Set<ServiceAccount> serviceAccounts) {
            this.serviceAccounts.addAll(serviceAccounts);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.tags, this.machineType, this.status, this.statusMessage, this.zone, (Set<NetworkInterface>)this.networkInterfaces.build(), (Set<AttachedDisk>)this.disks.build(), this.metadata, (Set<ServiceAccount>)this.serviceAccounts.build());
        }

        public Builder fromInstance(Instance in) {
            return ((Builder)super.fromResource(in)).tags(in.getTags()).machineType(in.getMachineType()).status(in.getStatus()).statusMessage((String)in.getStatusMessage().orNull()).zone(in.getZone()).networkInterfaces(in.getNetworkInterfaces()).disks(in.getDisks()).metadata(in.getMetadata()).serviceAccounts(in.getServiceAccounts());
        }
    }

    public static enum Status {
        PROVISIONING,
        STAGING,
        RUNNING,
        STOPPING,
        STOPPED,
        TERMINATED;

    }
}

