/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;

@Beta
public class Resource {
    protected final Kind kind;
    protected final String id;
    protected final Optional<Date> creationTimestamp;
    protected final URI selfLink;
    protected final String name;
    protected final Optional<String> description;

    @ConstructorProperties(value={"kind", "id", "creationTimestamp", "selfLink", "name", "description"})
    protected Resource(Kind kind, String id, Date creationTimestamp, URI selfLink, String name, String description) {
        this.kind = (Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind), (Object)"kind"));
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.creationTimestamp = Optional.fromNullable((Object)creationTimestamp);
        this.selfLink = (URI)Preconditions.checkNotNull((Object)selfLink, (Object)"selfLink");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.description = Optional.fromNullable((Object)description);
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getId() {
        return this.id;
    }

    public Optional<Date> getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public URI getSelfLink() {
        return this.selfLink;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Optional<String> getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.kind, this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Resource that = (Resource)Resource.class.cast(obj);
        return Objects.equal((Object)((Object)this.kind), (Object)((Object)that.kind)) && Objects.equal((Object)this.name, (Object)that.name);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("kind", (Object)this.kind).add("id", (Object)this.id).add("name", (Object)this.name).add("creationTimestamp", this.creationTimestamp.orNull()).add("selfLink", (Object)this.selfLink).add("name", (Object)this.name).add("description", this.description.orNull());
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromResource(this);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Kind kind;
        protected String id;
        protected Date creationTimestamp;
        protected URI selfLink;
        protected String name;
        protected String description;

        protected abstract T self();

        protected T kind(Kind kind) {
            this.kind = kind;
            return this.self();
        }

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T creationTimestamp(Date creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this.self();
        }

        public T selfLink(URI selfLink) {
            this.selfLink = selfLink;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public Resource build() {
            return new Resource(this.kind, this.id, this.creationTimestamp, this.selfLink, this.name, this.description);
        }

        public T fromResource(Resource in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.kind(in.getKind())).id(in.getId())).creationTimestamp((Date)in.getCreationTimestamp().orNull())).selfLink(in.getSelfLink())).name(in.getName())).description((String)in.getDescription().orNull());
        }
    }

    public static enum Kind {
        ADDRESS,
        ADDRESS_LIST,
        DISK,
        DISK_LIST,
        FIREWALL,
        FIREWALL_LIST,
        IMAGE,
        IMAGE_LIST,
        OPERATION,
        OPERATION_LIST,
        INSTANCE,
        INSTANCE_LIST,
        MACHINE_TYPE,
        MACHINE_TYPE_LIST,
        PROJECT,
        NETWORK,
        NETWORK_LIST,
        REGION,
        REGION_LIST,
        ROUTE,
        ROUTE_LIST,
        SNAPSHOT,
        SNAPSHOT_LIST,
        ZONE,
        ZONE_LIST;


        public String value() {
            return Joiner.on((String)"#").join((Object)"compute", (Object)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name()), new Object[0]);
        }

        public String toString() {
            return this.value();
        }

        public static Kind fromValue(String kind) {
            return Kind.valueOf(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Iterables.getLast((Iterable)Splitter.on((String)"#").split((CharSequence)Preconditions.checkNotNull((Object)kind, (Object)"kind")))));
        }
    }
}

