/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.googlecomputeengine.domain.Resource;

@Beta
public final class Route
extends Resource {
    private final URI network;
    private final Set<String> tags;
    private final String destRange;
    private final Integer priority;
    private final Optional<URI> nextHopInstance;
    private final Optional<String> nextHopIp;
    private final Optional<URI> nextHopNetwork;
    private final Optional<URI> nextHopGateway;
    private final Set<Warning> warnings;

    @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "network", "tags", "destRange", "priority", "nextHopInstance", "nextHopIp", "nextHopNetwork", "nextHopGateway", "warnings"})
    private Route(String id, Date creationTimestamp, URI selfLink, String name, String description, URI network, Set<String> tags, String destRange, Integer priority, URI nextHopInstance, String nextHopIp, URI nextHopNetwork, URI nextHopGateway, Set<Warning> warnings) {
        super(Resource.Kind.ROUTE, id, creationTimestamp, selfLink, name, description);
        this.network = (URI)Preconditions.checkNotNull((Object)network, (String)"network for %name", (Object[])new Object[]{name});
        this.tags = tags == null ? ImmutableSet.of() : tags;
        this.destRange = (String)Preconditions.checkNotNull((Object)destRange, (String)"destination range for %name", (Object[])new Object[]{name});
        this.priority = (Integer)Preconditions.checkNotNull((Object)priority, (String)"priority of %name", (Object[])new Object[]{name});
        this.nextHopInstance = Optional.fromNullable((Object)nextHopInstance);
        this.nextHopIp = Optional.fromNullable((Object)nextHopIp);
        this.nextHopNetwork = Optional.fromNullable((Object)nextHopNetwork);
        this.nextHopGateway = Optional.fromNullable((Object)nextHopGateway);
        this.warnings = warnings == null ? ImmutableSet.of() : warnings;
    }

    public URI getNetwork() {
        return this.network;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public String getDestRange() {
        return this.destRange;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Optional<URI> getNextHopInstance() {
        return this.nextHopInstance;
    }

    public Optional<String> getNextHopIp() {
        return this.nextHopIp;
    }

    public Optional<URI> getNextHopNetwork() {
        return this.nextHopNetwork;
    }

    public Optional<URI> getNextHopGateway() {
        return this.nextHopGateway;
    }

    public Set<Warning> getWarnings() {
        return this.warnings;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("network", (Object)this.network).add("tags", this.tags).add("destRange", (Object)this.destRange).add("priority", (Object)this.priority).add("nextHopInstance", this.nextHopInstance.orNull()).add("nextHopIp", this.nextHopIp.orNull()).add("nextHopNetwork", this.nextHopNetwork.orNull()).add("nextHopGateway", this.nextHopGateway.orNull()).add("warnings", this.warnings);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromRoute(this);
    }

    public static class Warning {
        private final String code;
        private final Optional<String> message;
        private final Map<String, String> data;

        @ConstructorProperties(value={"code", "message", "data"})
        public Warning(String code, String message, Map<String, String> data) {
            this.code = (String)Preconditions.checkNotNull((Object)code, (Object)"code");
            this.message = Optional.fromNullable((Object)message);
            this.data = data == null ? ImmutableMap.of() : data;
        }

        public String getCode() {
            return this.code;
        }

        public Optional<String> getMessage() {
            return this.message;
        }

        public Map<String, String> getData() {
            return this.data;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.code, this.message, this.data});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Warning that = (Warning)Warning.class.cast(obj);
            return Objects.equal((Object)this.code, (Object)that.code) && Objects.equal(this.message, that.message) && Objects.equal(this.data, that.data);
        }

        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).add("code", (Object)this.code).add("message", this.message).add("data", this.data);
        }

        public String toString() {
            return this.string().toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return Warning.builder().fromWarning(this);
        }

        public static final class Builder {
            private String code;
            private String message;
            private ImmutableMap.Builder<String, String> data = ImmutableMap.builder();

            public Builder code(String code) {
                this.code = code;
                return this;
            }

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Builder data(Map<String, String> data) {
                this.data = new ImmutableMap.Builder().putAll(data);
                return this;
            }

            public Builder addData(String key, String value) {
                this.data.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (String)"value of %s", (Object[])new Object[]{key}));
                return this;
            }

            public Warning build() {
                return new Warning(this.code, this.message, (Map<String, String>)this.data.build());
            }

            public Builder fromWarning(Warning in) {
                return this.code(in.getCode()).message((String)in.getMessage().orNull()).data(in.getData());
            }
        }
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private URI network;
        private ImmutableSet.Builder<String> tags = ImmutableSet.builder();
        private String destRange;
        private Integer priority;
        private URI nextHopInstance;
        private String nextHopIp;
        private URI nextHopNetwork;
        private URI nextHopGateway;
        private ImmutableSet.Builder<Warning> warnings = ImmutableSet.builder();

        public Builder network(URI network) {
            this.network = network;
            return this;
        }

        public Builder addTag(String tag) {
            this.tags.add((Object)tag);
            return this;
        }

        public Builder tags(Set<String> tags) {
            this.tags.addAll(tags);
            return this;
        }

        public Builder destRange(String destRange) {
            this.destRange = destRange;
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Builder nextHopInstance(URI nextHopInstance) {
            this.nextHopInstance = nextHopInstance;
            return this;
        }

        public Builder nextHopIp(String nextHopIp) {
            this.nextHopIp = nextHopIp;
            return this;
        }

        public Builder nextHopNetwork(URI nextHopNetwork) {
            this.nextHopNetwork = nextHopNetwork;
            return this;
        }

        public Builder nextHopGateway(URI nextHopGateway) {
            this.nextHopGateway = nextHopGateway;
            return this;
        }

        public Builder addWarning(Warning warning) {
            this.warnings.add((Object)warning);
            return this;
        }

        public Builder warnings(Set<Warning> warnings) {
            this.warnings.addAll(warnings);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Route build() {
            return new Route(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.network, (Set)this.tags.build(), this.destRange, this.priority, this.nextHopInstance, this.nextHopIp, this.nextHopNetwork, this.nextHopGateway, (Set)this.warnings.build());
        }

        public Builder fromRoute(Route in) {
            return ((Builder)super.fromResource(in)).network(in.getNetwork()).tags(in.getTags()).destRange(in.getDestRange()).priority(in.getPriority()).nextHopInstance((URI)in.getNextHopInstance().orNull()).nextHopIp((String)in.getNextHopIp().orNull()).nextHopNetwork((URI)in.getNextHopNetwork().orNull()).nextHopGateway((URI)in.getNextHopGateway().orNull()).warnings(in.getWarnings());
        }
    }
}

