/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.functions.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.functions.internal.BaseToPagedIterable;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;

public class ParseFirewalls
extends ParseJson<ListPage<Firewall>> {
    @Inject
    public ParseFirewalls(Json json) {
        super(json, (TypeLiteral)new TypeLiteral<ListPage<Firewall>>(){});
    }

    public static class ToPagedIterable
    extends BaseToPagedIterable<Firewall, ToPagedIterable> {
        private final GoogleComputeEngineApi api;

        @Inject
        protected ToPagedIterable(GoogleComputeEngineApi api) {
            this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        @Override
        protected Function<Object, IterableWithMarker<Firewall>> fetchNextPage(final String projectName, final ListOptions options) {
            return new Function<Object, IterableWithMarker<Firewall>>(){

                public IterableWithMarker<Firewall> apply(Object input) {
                    return ToPagedIterable.this.api.getFirewallApiForProject(projectName).listAtMarker(input.toString(), options);
                }
            };
        }
    }
}

