
package org.jclouds.aws.ec2.domain;

import org.jclouds.javax.annotation.Nullable;

 final class AutoValue_Route extends Route {

  private final String destinationCidrBlock;
  private final String gatewayId;
  private final Route.RouteState state;
  private final String origin;

  private AutoValue_Route(
      @Nullable String destinationCidrBlock,
      @Nullable String gatewayId,
      @Nullable Route.RouteState state,
      @Nullable String origin) {
    this.destinationCidrBlock = destinationCidrBlock;
    this.gatewayId = gatewayId;
    this.state = state;
    this.origin = origin;
  }

  @Nullable
  @Override
  public String destinationCidrBlock() {
    return destinationCidrBlock;
  }

  @Nullable
  @Override
  public String gatewayId() {
    return gatewayId;
  }

  @Nullable
  @Override
  public Route.RouteState state() {
    return state;
  }

  @Nullable
  @Override
  public String origin() {
    return origin;
  }

  @Override
  public String toString() {
    return "Route{"
        + "destinationCidrBlock=" + destinationCidrBlock + ", "
        + "gatewayId=" + gatewayId + ", "
        + "state=" + state + ", "
        + "origin=" + origin
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Route) {
      Route that = (Route) o;
      return ((this.destinationCidrBlock == null) ? (that.destinationCidrBlock() == null) : this.destinationCidrBlock.equals(that.destinationCidrBlock()))
           && ((this.gatewayId == null) ? (that.gatewayId() == null) : this.gatewayId.equals(that.gatewayId()))
           && ((this.state == null) ? (that.state() == null) : this.state.equals(that.state()))
           && ((this.origin == null) ? (that.origin() == null) : this.origin.equals(that.origin()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (destinationCidrBlock == null) ? 0 : this.destinationCidrBlock.hashCode();
    h *= 1000003;
    h ^= (gatewayId == null) ? 0 : this.gatewayId.hashCode();
    h *= 1000003;
    h ^= (state == null) ? 0 : this.state.hashCode();
    h *= 1000003;
    h ^= (origin == null) ? 0 : this.origin.hashCode();
    return h;
  }

  static final class Builder extends Route.Builder {
    private String destinationCidrBlock;
    private String gatewayId;
    private Route.RouteState state;
    private String origin;
    Builder() {
    }
    @Override
    public Route.Builder destinationCidrBlock(@Nullable String destinationCidrBlock) {
      this.destinationCidrBlock = destinationCidrBlock;
      return this;
    }
    @Override
    public Route.Builder gatewayId(@Nullable String gatewayId) {
      this.gatewayId = gatewayId;
      return this;
    }
    @Override
    public Route.Builder state(@Nullable Route.RouteState state) {
      this.state = state;
      return this;
    }
    @Override
    public Route.Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }
    @Override
    public Route build() {
      return new AutoValue_Route(
          this.destinationCidrBlock,
          this.gatewayId,
          this.state,
          this.origin);
    }
  }

}
