
package org.jclouds.aws.ec2.domain;

import java.util.Map;
import org.jclouds.javax.annotation.Nullable;

 final class AutoValue_VPC extends VPC {

  private final String id;
  private final VPC.State state;
  private final String cidrBlock;
  private final String dhcpOptionsId;
  private final VPC.InstanceTenancy instanceTenancy;
  private final Boolean isDefault;
  private final Map<String, String> tags;

  private AutoValue_VPC(
      @Nullable String id,
      @Nullable VPC.State state,
      @Nullable String cidrBlock,
      @Nullable String dhcpOptionsId,
      @Nullable VPC.InstanceTenancy instanceTenancy,
      @Nullable Boolean isDefault,
      @Nullable Map<String, String> tags) {
    this.id = id;
    this.state = state;
    this.cidrBlock = cidrBlock;
    this.dhcpOptionsId = dhcpOptionsId;
    this.instanceTenancy = instanceTenancy;
    this.isDefault = isDefault;
    this.tags = tags;
  }

  @Nullable
  @Override
  public String id() {
    return id;
  }

  @Nullable
  @Override
  public VPC.State state() {
    return state;
  }

  @Nullable
  @Override
  public String cidrBlock() {
    return cidrBlock;
  }

  @Nullable
  @Override
  public String dhcpOptionsId() {
    return dhcpOptionsId;
  }

  @Nullable
  @Override
  public VPC.InstanceTenancy instanceTenancy() {
    return instanceTenancy;
  }

  @Nullable
  @Override
  public Boolean isDefault() {
    return isDefault;
  }

  @Nullable
  @Override
  public Map<String, String> tags() {
    return tags;
  }

  @Override
  public String toString() {
    return "VPC{"
        + "id=" + id + ", "
        + "state=" + state + ", "
        + "cidrBlock=" + cidrBlock + ", "
        + "dhcpOptionsId=" + dhcpOptionsId + ", "
        + "instanceTenancy=" + instanceTenancy + ", "
        + "isDefault=" + isDefault + ", "
        + "tags=" + tags
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof VPC) {
      VPC that = (VPC) o;
      return ((this.id == null) ? (that.id() == null) : this.id.equals(that.id()))
           && ((this.state == null) ? (that.state() == null) : this.state.equals(that.state()))
           && ((this.cidrBlock == null) ? (that.cidrBlock() == null) : this.cidrBlock.equals(that.cidrBlock()))
           && ((this.dhcpOptionsId == null) ? (that.dhcpOptionsId() == null) : this.dhcpOptionsId.equals(that.dhcpOptionsId()))
           && ((this.instanceTenancy == null) ? (that.instanceTenancy() == null) : this.instanceTenancy.equals(that.instanceTenancy()))
           && ((this.isDefault == null) ? (that.isDefault() == null) : this.isDefault.equals(that.isDefault()))
           && ((this.tags == null) ? (that.tags() == null) : this.tags.equals(that.tags()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (id == null) ? 0 : this.id.hashCode();
    h *= 1000003;
    h ^= (state == null) ? 0 : this.state.hashCode();
    h *= 1000003;
    h ^= (cidrBlock == null) ? 0 : this.cidrBlock.hashCode();
    h *= 1000003;
    h ^= (dhcpOptionsId == null) ? 0 : this.dhcpOptionsId.hashCode();
    h *= 1000003;
    h ^= (instanceTenancy == null) ? 0 : this.instanceTenancy.hashCode();
    h *= 1000003;
    h ^= (isDefault == null) ? 0 : this.isDefault.hashCode();
    h *= 1000003;
    h ^= (tags == null) ? 0 : this.tags.hashCode();
    return h;
  }

  static final class Builder extends VPC.Builder {
    private String id;
    private VPC.State state;
    private String cidrBlock;
    private String dhcpOptionsId;
    private VPC.InstanceTenancy instanceTenancy;
    private Boolean isDefault;
    private Map<String, String> tags;
    Builder() {
    }
    @Override
    public VPC.Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }
    @Override
    @Nullable public String id() {
      return id;
    }
    @Override
    public VPC.Builder state(@Nullable VPC.State state) {
      this.state = state;
      return this;
    }
    @Override
    @Nullable public VPC.State state() {
      return state;
    }
    @Override
    public VPC.Builder cidrBlock(@Nullable String cidrBlock) {
      this.cidrBlock = cidrBlock;
      return this;
    }
    @Override
    @Nullable public String cidrBlock() {
      return cidrBlock;
    }
    @Override
    public VPC.Builder dhcpOptionsId(@Nullable String dhcpOptionsId) {
      this.dhcpOptionsId = dhcpOptionsId;
      return this;
    }
    @Override
    public VPC.Builder instanceTenancy(@Nullable VPC.InstanceTenancy instanceTenancy) {
      this.instanceTenancy = instanceTenancy;
      return this;
    }
    @Override
    @Nullable public VPC.InstanceTenancy instanceTenancy() {
      return instanceTenancy;
    }
    @Override
    public VPC.Builder isDefault(@Nullable Boolean isDefault) {
      this.isDefault = isDefault;
      return this;
    }
    @Override
    @Nullable public Boolean isDefault() {
      return isDefault;
    }
    @Override
    public VPC.Builder tags(@Nullable Map<String, String> tags) {
      this.tags = tags;
      return this;
    }
    @Override
    @Nullable public Map<String, String> tags() {
      return tags;
    }
    @Override
    VPC autoBuild() {
      return new AutoValue_VPC(
          this.id,
          this.state,
          this.cidrBlock,
          this.dhcpOptionsId,
          this.instanceTenancy,
          this.isDefault,
          this.tags);
    }
  }

}
