/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectUtils {
    private static final Logger log = LoggerFactory.getLogger(ConnectUtils.class);

    public static Long checkAndConvertTimestamp(Long timestamp) {
        if (timestamp == null || timestamp >= 0L) {
            return timestamp;
        }
        if (timestamp == -1L) {
            return null;
        }
        throw new InvalidRecordException(String.format("Invalid record timestamp %d", timestamp));
    }

    public static String lookupKafkaClusterId(WorkerConfig config) {
        log.info("Creating Kafka admin client");
        try (Admin adminClient = Admin.create((Map)config.originals());){
            String string = ConnectUtils.lookupKafkaClusterId(adminClient);
            return string;
        }
    }

    static String lookupKafkaClusterId(Admin adminClient) {
        log.debug("Looking up Kafka cluster ID");
        try {
            KafkaFuture clusterIdFuture = adminClient.describeCluster().clusterId();
            if (clusterIdFuture == null) {
                log.info("Kafka cluster version is too old to return cluster ID");
                return null;
            }
            log.debug("Fetching Kafka cluster ID");
            String kafkaClusterId = (String)clusterIdFuture.get();
            log.info("Kafka cluster ID: {}", (Object)kafkaClusterId);
            return kafkaClusterId;
        }
        catch (InterruptedException e) {
            throw new ConnectException("Unexpectedly interrupted when looking up Kafka cluster info", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ConnectException("Failed to connect to and describe Kafka cluster. Check worker's broker connection and security properties.", (Throwable)e);
        }
    }

    public static void addMetricsContextProperties(Map<String, Object> prop, WorkerConfig config, String clusterId) {
        prop.putAll(config.originalsWithPrefix("metrics.context.", false));
        prop.put("metrics.context.connect.kafka.cluster.id", clusterId);
        Object groupId = config.originals().get("group.id");
        if (groupId != null) {
            prop.put("metrics.context.connect.group.id", groupId);
        }
    }

    public static boolean isSinkConnector(Connector connector) {
        return SinkConnector.class.isAssignableFrom(connector.getClass());
    }

    public static boolean isSourceConnector(Connector connector) {
        return SourceConnector.class.isAssignableFrom(connector.getClass());
    }
}

