/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShutdownableThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ShutdownableThread.class);
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    public static volatile Thread.UncaughtExceptionHandler funcaughtExceptionHandler = null;

    public ShutdownableThread(String name) {
        this(name, true);
    }

    public ShutdownableThread(String name, boolean daemon) {
        super(name);
        this.setDaemon(daemon);
        if (funcaughtExceptionHandler != null) {
            this.setUncaughtExceptionHandler(funcaughtExceptionHandler);
        }
    }

    public abstract void execute();

    public boolean getRunning() {
        return this.isRunning.get();
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Error | RuntimeException e) {
            log.error("Thread {} exiting with uncaught exception: ", (Object)this.getName(), (Object)e);
            throw e;
        }
        finally {
            this.shutdownLatch.countDown();
        }
    }

    public void shutdown(long gracefulTimeout, TimeUnit unit) throws InterruptedException {
        boolean success = this.gracefulShutdown(gracefulTimeout, unit);
        if (!success) {
            this.forceShutdown();
        }
    }

    public boolean gracefulShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.startGracefulShutdown();
        return this.awaitShutdown(timeout, unit);
    }

    public void startGracefulShutdown() {
        log.info("Starting graceful shutdown of thread {}", (Object)this.getName());
        this.isRunning.set(false);
    }

    public boolean awaitShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        return this.shutdownLatch.await(timeout, unit);
    }

    public void forceShutdown() {
        log.info("Forcing shutdown of thread {}", (Object)this.getName());
        this.isRunning.set(false);
        this.interrupt();
    }
}

