/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.descriptor;

import java.io.Serializable;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Parameter
implements Serializable {
    final String name;
    final String alias;
    final String type;
    final boolean required;
    final boolean editable;
    final String description;
    final String since;
    final String deprecated;
    final String expression;
    final String defaultValue;

    Parameter(String name, String alias, String type, boolean required, boolean editable, String description, String since, String deprecated, String expression, String defaultValue) {
        this.name = name;
        this.alias = alias;
        this.type = type;
        this.required = required;
        this.editable = editable;
        this.description = description;
        this.since = since;
        this.deprecated = deprecated;
        this.expression = expression;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSince() {
        return this.since;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Nonnull
    public Builder with() {
        return Parameter.newBuilder(this);
    }

    @Nonnull
    public Parameter withName(String name) {
        return Parameter.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public Parameter withAlias(String alias) {
        return Parameter.newBuilder(this, true).alias(alias).build();
    }

    @Nonnull
    public Parameter withType(String type) {
        return Parameter.newBuilder(this, true).type(type).build();
    }

    @Nonnull
    public Parameter withRequired(boolean required) {
        return Parameter.newBuilder(this, true).required(required).build();
    }

    @Nonnull
    public Parameter withEditable(boolean editable) {
        return Parameter.newBuilder(this, true).editable(editable).build();
    }

    @Nonnull
    public Parameter withDescription(String description) {
        return Parameter.newBuilder(this, true).description(description).build();
    }

    @Nonnull
    public Parameter withSince(String since) {
        return Parameter.newBuilder(this, true).since(since).build();
    }

    @Nonnull
    public Parameter withDeprecated(String deprecated) {
        return Parameter.newBuilder(this, true).deprecated(deprecated).build();
    }

    @Nonnull
    public Parameter withExpression(String expression) {
        return Parameter.newBuilder(this, true).expression(expression).build();
    }

    @Nonnull
    public Parameter withDefaultValue(String defaultValue) {
        return Parameter.newBuilder(this, true).defaultValue(defaultValue).build();
    }

    @Nonnull
    public static Parameter newInstance() {
        return Parameter.newInstance(true);
    }

    @Nonnull
    public static Parameter newInstance(boolean withDefaults) {
        return Parameter.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Parameter.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Parameter from) {
        return Parameter.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Parameter from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Parameter base;
        String name;
        String alias;
        String type;
        Boolean required;
        Boolean editable;
        String description;
        String since;
        String deprecated;
        String expression;
        String defaultValue;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.required = false;
                this.editable = true;
            }
        }

        Builder(Parameter base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.alias = base.alias;
                this.type = base.type;
                this.required = base.required;
                this.editable = base.editable;
                this.description = base.description;
                this.since = base.since;
                this.deprecated = base.deprecated;
                this.expression = base.expression;
                this.defaultValue = base.defaultValue;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Nonnull
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        @Nonnull
        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @Nonnull
        public Builder editable(boolean editable) {
            this.editable = editable;
            return this;
        }

        @Nonnull
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder since(String since) {
            this.since = since;
            return this;
        }

        @Nonnull
        public Builder deprecated(String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        @Nonnull
        public Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        @Nonnull
        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Nonnull
        public Parameter build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.alias != null && this.alias != this.base.alias || this.type != null && this.type != this.base.type || this.required != null && this.required != this.base.required || this.editable != null && this.editable != this.base.editable || this.description != null && this.description != this.base.description || this.since != null && this.since != this.base.since || this.deprecated != null && this.deprecated != this.base.deprecated || this.expression != null && this.expression != this.base.expression || this.defaultValue != null && this.defaultValue != this.base.defaultValue)) {
                return this.base;
            }
            return new Parameter(this.name != null ? this.name : (this.base != null ? this.base.name : null), this.alias != null ? this.alias : (this.base != null ? this.base.alias : null), this.type != null ? this.type : (this.base != null ? this.base.type : null), this.required != null ? this.required : (this.base != null ? this.base.required : false), this.editable != null ? this.editable : (this.base != null ? this.base.editable : true), this.description != null ? this.description : (this.base != null ? this.base.description : null), this.since != null ? this.since : (this.base != null ? this.base.since : null), this.deprecated != null ? this.deprecated : (this.base != null ? this.base.deprecated : null), this.expression != null ? this.expression : (this.base != null ? this.base.expression : null), this.defaultValue != null ? this.defaultValue : (this.base != null ? this.base.defaultValue : null));
        }
    }
}

