/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.UnaryOperator;
import javax.tools.OptionChecker;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.plugin.compiler.ForkedCompiler;

public final class Options {
    final List<String> options = new ArrayList<String>();
    private final OptionChecker checker;
    private final Log logger;
    private String warning;

    Options(OptionChecker checker, Log logger) {
        this.checker = checker;
        this.logger = logger;
    }

    private static String strip(String value) {
        if (value != null && (value = value.strip()).isEmpty()) {
            return null;
        }
        return value;
    }

    public boolean addIfTrue(String option, boolean value) {
        if (value && this.checkNumberOfArguments(option, 0, true)) {
            this.options.add(option);
            return true;
        }
        return false;
    }

    public boolean addIfNonBlank(String option, String value) {
        if ((value = Options.strip(value)) != null && this.checkNumberOfArguments(option, 1, true)) {
            this.options.add(option);
            this.options.add(value);
            return true;
        }
        return false;
    }

    public boolean addComaSeparated(String option, String values, Collection<String> valids, UnaryOperator<String[]> filter) {
        if (values == null) {
            return false;
        }
        String[] split = values.split(",");
        int count = 0;
        for (String value : split) {
            if ((value = value.strip()).isEmpty()) continue;
            split[count++] = value.toLowerCase(Locale.US);
        }
        if (count == 0) {
            return false;
        }
        if (filter != null) {
            if (count != split.length) {
                split = Arrays.copyOfRange(split, 0, count);
            }
            if ((split = (String[])filter.apply(split)) == null) {
                return false;
            }
            count = split.length;
        }
        StringBuilder sb = new StringBuilder(option);
        for (int i = 0; i < count; ++i) {
            sb.append(i == 0 ? (char)':' : ',').append(split[i]);
        }
        String s = sb.toString();
        if (this.checkNumberOfArguments(s, 0, false)) {
            this.options.add(s);
            return true;
        }
        if (valids != null) {
            for (int i = 0; i < count; ++i) {
                String value;
                value = split[i];
                if (valids.contains(value)) continue;
                sb.setLength(0);
                sb.append(this.warning);
                sb.setLength(sb.length() - 1);
                sb.append(", because the specified ").append(option).append(" value '").append(value).append("' is unexpected. Legal values are: ");
                int j = 0;
                for (String valid : valids) {
                    if (j++ != 0) {
                        sb.append(", ");
                        if (j == valids.size()) {
                            sb.append("and ");
                        }
                    }
                    sb.append('\'').append(valid).append('\'');
                }
                this.warning = sb.append('.').toString();
                break;
            }
        }
        this.logger.warn((CharSequence)this.warning);
        this.warning = null;
        return false;
    }

    public boolean addMemoryValue(String option, String label, String value, boolean addDefaultUnit) {
        if ((value = Options.strip((String)value)) != null) {
            int length = ((String)value).length();
            for (int i = 0; i < length; ++i) {
                char c = ((String)value).charAt(i);
                if (c >= '0' && c <= '9') continue;
                if (i == length - 1 && ((c = Character.toUpperCase(c)) == 'K' || c == 'M' || c == 'G')) {
                    addDefaultUnit = false;
                    break;
                }
                this.logger.warn((CharSequence)("Invalid value for " + label + "=\"" + (String)value + "\". Ignoring this option."));
                return false;
            }
            if (addDefaultUnit) {
                value = (String)value + "M";
                this.logger.warn((CharSequence)("Value " + label + "=\"" + (String)value + "\" has been specified without unit. An explicit \"M\" unit symbol should be appended for avoiding ambiguity."));
            }
            if (this.checkNumberOfArguments((String)(option = (String)option + (String)value), 0, true)) {
                this.options.add((String)option);
                return true;
            }
        }
        return false;
    }

    private boolean checkNumberOfArguments(String option, int count, boolean immediate) {
        int expected = this.checker.isSupportedOption(option);
        if (expected == count) {
            this.warning = null;
            return true;
        }
        if (expected < 1) {
            if (this.checker instanceof ForkedCompiler) {
                return true;
            }
            this.warning = "The '" + option + "' option is not supported.";
        } else {
            this.warning = expected == 0 ? "The '" + option + "' option does not expect any argument." : (expected == 1 ? "The '" + option + "' option expects a single argument." : "The '" + option + "' option expects " + expected + " arguments.");
        }
        if (immediate) {
            this.logger.warn((CharSequence)this.warning);
            this.warning = null;
        }
        return false;
    }

    public void addUnchecked(Iterable<String> arguments) {
        if (arguments != null) {
            for (String arg : arguments) {
                if (arg == null || (arg = arg.strip()).isEmpty()) continue;
                this.options.add(arg);
            }
        }
    }

    @Deprecated(since="4.0.0")
    void addUnchecked(String arguments) {
        if (arguments != null) {
            this.addUnchecked(Arrays.asList(arguments.split(" ")));
        }
    }
}

