/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.filter.SimpleFilter;
import org.apache.maven.project.MavenProject;
import org.vafer.jdependency.Clazz;
import org.vafer.jdependency.Clazzpath;
import org.vafer.jdependency.ClazzpathUnit;

public class MinijarFilter
implements Filter {
    private Log log;
    private Set<Clazz> removable;
    private int classesKept;
    private int classesRemoved;

    MinijarFilter(int classesKept, int classesRemoved, Log log) {
        this.classesKept = classesKept;
        this.classesRemoved = classesRemoved;
        this.log = log;
    }

    public MinijarFilter(MavenProject project, Log log) throws IOException {
        this(project, log, Collections.emptyList(), Collections.emptySet());
    }

    public MinijarFilter(MavenProject project, Log log, Set<String> entryPoints) throws IOException {
        this(project, log, Collections.emptyList(), entryPoints);
    }

    public MinijarFilter(MavenProject project, Log log, List<SimpleFilter> simpleFilters, Set<String> entryPoints) throws IOException {
        this.log = log;
        File artifactFile = project.getArtifact().getFile();
        if (artifactFile != null) {
            Clazzpath cp = new Clazzpath();
            ClazzpathUnit artifactUnit = cp.addClazzpathUnit((InputStream)new FileInputStream(artifactFile), project.toString());
            for (Artifact dependency : project.getArtifacts()) {
                this.addDependencyToClasspath(cp, dependency);
            }
            this.removable = cp.getClazzes();
            if (this.removable.remove(new Clazz("module-info"))) {
                log.warn((CharSequence)("Removing module-info from " + artifactFile.getName()));
            }
            this.removePackages(artifactUnit);
            if (entryPoints.isEmpty()) {
                this.removable.removeAll(artifactUnit.getClazzes());
                this.removable.removeAll(artifactUnit.getTransitiveDependencies());
            } else {
                Set artifactUnitClazzes = artifactUnit.getClazzes();
                HashSet<Clazz> entryPointsToKeep = new HashSet<Clazz>();
                for (String string : entryPoints) {
                    Clazz entryPointFound = null;
                    for (Clazz clazz : artifactUnitClazzes) {
                        if (!clazz.getName().equals(string)) continue;
                        entryPointFound = clazz;
                        break;
                    }
                    if (entryPointFound == null) continue;
                    entryPointsToKeep.add(entryPointFound);
                }
                this.removable.removeAll(entryPointsToKeep);
                if (entryPointsToKeep.isEmpty()) {
                    this.removable.removeAll(artifactUnit.getTransitiveDependencies());
                } else {
                    for (Clazz clazz : entryPointsToKeep) {
                        this.removable.removeAll(clazz.getTransitiveDependencies());
                    }
                }
            }
            this.removeSpecificallyIncludedClasses(project, simpleFilters == null ? Collections.emptyList() : simpleFilters);
            this.removeServices(project, cp);
        }
    }

    private void removeServices(MavenProject project, Clazzpath cp) {
        boolean repeatScan;
        do {
            repeatScan = false;
            Set neededClasses = cp.getClazzes();
            neededClasses.removeAll(this.removable);
            try {
                for (String fileName : project.getRuntimeClasspathElements()) {
                    if (new File(fileName).isDirectory()) {
                        repeatScan |= this.removeServicesFromDir(cp, neededClasses, fileName);
                        continue;
                    }
                    repeatScan |= this.removeServicesFromJar(cp, neededClasses, fileName);
                }
            }
            catch (DependencyResolutionRequiredException e) {
                this.log.warn((CharSequence)e.getMessage());
            }
        } while (repeatScan);
    }

    private boolean removeServicesFromDir(Clazzpath cp, Set<Clazz> neededClasses, String fileName) {
        File servicesDir = new File(fileName, "META-INF/services/");
        if (!servicesDir.isDirectory()) {
            return false;
        }
        File[] serviceProviderConfigFiles = servicesDir.listFiles();
        if (serviceProviderConfigFiles == null || serviceProviderConfigFiles.length == 0) {
            return false;
        }
        boolean repeatScan = false;
        for (File serviceProviderConfigFile : serviceProviderConfigFiles) {
            String serviceClassName = serviceProviderConfigFile.getName();
            boolean isNeededClass = neededClasses.contains(cp.getClazz(serviceClassName));
            if (!isNeededClass) continue;
            try (BufferedReader configFileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(serviceProviderConfigFile), StandardCharsets.UTF_8));){
                repeatScan |= this.scanServiceProviderConfigFile(cp, configFileReader);
            }
            catch (IOException e) {
                this.log.warn((CharSequence)e.getMessage());
            }
        }
        return repeatScan;
    }

    private boolean removeServicesFromJar(Clazzpath cp, Set<Clazz> neededClasses, String fileName) {
        boolean repeatScan = false;
        try (JarFile jar = new JarFile(fileName);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String serviceClassName;
                boolean isNeededClass;
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().startsWith("META-INF/services/") || !(isNeededClass = neededClasses.contains(cp.getClazz(serviceClassName = jarEntry.getName().substring("META-INF/services/".length()))))) continue;
                try (BufferedReader configFileReader = new BufferedReader(new InputStreamReader(jar.getInputStream(jarEntry), StandardCharsets.UTF_8));){
                    repeatScan = this.scanServiceProviderConfigFile(cp, configFileReader);
                }
                catch (IOException e) {
                    this.log.warn((CharSequence)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("Not a JAR file candidate. Ignoring classpath element '" + fileName + "' (" + e + ")."));
        }
        return repeatScan;
    }

    private boolean scanServiceProviderConfigFile(Clazzpath cp, BufferedReader configFileReader) throws IOException {
        boolean serviceClassFound = false;
        String line = configFileReader.readLine();
        while (line != null) {
            Clazz clazz;
            String className = line.split("#", 2)[0].trim();
            if (!className.isEmpty() && (clazz = cp.getClazz(className)) != null && this.removable.contains(clazz)) {
                this.log.debug((CharSequence)(className + " was not removed because it is a service"));
                this.removeClass(clazz);
                serviceClassFound = true;
            }
            line = configFileReader.readLine();
        }
        return serviceClassFound;
    }

    private void removeClass(Clazz clazz) {
        this.removable.remove(clazz);
        this.removable.removeAll(clazz.getTransitiveDependencies());
    }

    private ClazzpathUnit addDependencyToClasspath(Clazzpath cp, Artifact dependency) throws IOException {
        ClazzpathUnit clazzpathUnit = null;
        try (FileInputStream is = new FileInputStream(dependency.getFile());){
            clazzpathUnit = cp.addClazzpathUnit((InputStream)is, dependency.toString());
        }
        catch (ZipException e) {
            this.log.warn((CharSequence)(dependency.getFile() + " could not be unpacked/read for minimization; dependency is probably malformed."));
            IOException ioe = new IOException("Dependency " + dependency + " in file " + dependency.getFile() + " could not be unpacked. File is probably corrupt", e);
            throw ioe;
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            this.log.warn((CharSequence)(dependency + " could not be analyzed for minimization; dependency is probably malformed."));
        }
        return clazzpathUnit;
    }

    private void removePackages(ClazzpathUnit artifactUnit) {
        HashSet<String> packageNames = new HashSet<String>();
        this.removePackages(artifactUnit.getClazzes(), packageNames);
        this.removePackages(artifactUnit.getTransitiveDependencies(), packageNames);
    }

    private void removePackages(Set<Clazz> clazzes, Set<String> packageNames) {
        for (Clazz clazz : clazzes) {
            String name = clazz.getName();
            while (name.contains(".")) {
                if (!packageNames.add(name = name.substring(0, name.lastIndexOf(46)))) continue;
                this.removable.remove(new Clazz(name + ".package-info"));
            }
        }
    }

    private void removeSpecificallyIncludedClasses(MavenProject project, List<SimpleFilter> simpleFilters) throws IOException {
        Clazzpath checkCp = new Clazzpath();
        for (Artifact dependency : project.getArtifacts()) {
            File jar = dependency.getFile();
            for (SimpleFilter simpleFilter : simpleFilters) {
                ClazzpathUnit depClazzpathUnit;
                if (!simpleFilter.canFilter(jar) || (depClazzpathUnit = this.addDependencyToClasspath(checkCp, dependency)) == null) continue;
                Set clazzes = depClazzpathUnit.getClazzes();
                for (Clazz clazz : new HashSet<Clazz>(this.removable)) {
                    if (!clazzes.contains(clazz) || !simpleFilter.isSpecificallyIncluded(clazz.getName().replace('.', '/'))) continue;
                    this.log.debug((CharSequence)(clazz.getName() + " not removed because it was specifically included"));
                    this.removeClass(clazz);
                }
            }
        }
    }

    @Override
    public boolean canFilter(File jar) {
        return true;
    }

    @Override
    public boolean isFiltered(String classFile) {
        String className = classFile.replace('/', '.').replaceFirst("\\.class$", "");
        Clazz clazz = new Clazz(className);
        if (this.removable != null && this.removable.contains(clazz)) {
            this.log.debug((CharSequence)("Removing " + className));
            ++this.classesRemoved;
            return true;
        }
        ++this.classesKept;
        return false;
    }

    @Override
    public void finished() {
        int classesTotal = this.classesRemoved + this.classesKept;
        if (classesTotal != 0) {
            this.log.info((CharSequence)("Minimized " + classesTotal + " -> " + this.classesKept + " (" + 100 * this.classesKept / classesTotal + "%)"));
        } else {
            this.log.info((CharSequence)("Minimized " + classesTotal + " -> " + this.classesKept));
        }
    }
}

