/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ClassAnalyzer;
import org.apache.maven.shared.dependency.analyzer.DependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;

public class DefaultProjectDependencyAnalyzer
implements ProjectDependencyAnalyzer {
    private ClassAnalyzer classAnalyzer;
    private DependencyAnalyzer dependencyAnalyzer;

    public ProjectDependencyAnalysis analyze(MavenProject project) throws ProjectDependencyAnalyzerException {
        try {
            Map artifactClassMap = this.buildArtifactClassMap(project);
            Set dependencyClasses = this.buildDependencyClasses(project);
            Set declaredArtifacts = this.buildDeclaredArtifacts(project);
            Set usedArtifacts = this.buildUsedArtifacts(artifactClassMap, dependencyClasses);
            LinkedHashSet usedDeclaredArtifacts = new LinkedHashSet(declaredArtifacts);
            usedDeclaredArtifacts.retainAll(usedArtifacts);
            Set usedUndeclaredArtifacts = new LinkedHashSet(usedArtifacts);
            usedUndeclaredArtifacts = this.removeAll(usedUndeclaredArtifacts, declaredArtifacts);
            Set unusedDeclaredArtifacts = new LinkedHashSet(declaredArtifacts);
            unusedDeclaredArtifacts = this.removeAll(unusedDeclaredArtifacts, usedArtifacts);
            return new ProjectDependencyAnalysis(usedDeclaredArtifacts, usedUndeclaredArtifacts, unusedDeclaredArtifacts);
        }
        catch (IOException exception) {
            throw new ProjectDependencyAnalyzerException("Cannot analyze dependencies", exception);
        }
    }

    private Set removeAll(Set start, Set remove) {
        LinkedHashSet<Artifact> results = new LinkedHashSet<Artifact>(start.size());
        Iterator iter = start.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            Iterator iter2 = remove.iterator();
            boolean found = false;
            while (iter2.hasNext()) {
                Artifact artifact2 = (Artifact)iter2.next();
                if (!artifact.getDependencyConflictId().equals(artifact2.getDependencyConflictId())) continue;
                found = true;
            }
            if (found) continue;
            results.add(artifact);
        }
        return results;
    }

    private Map buildArtifactClassMap(MavenProject project) throws IOException {
        LinkedHashMap<Artifact, Set> artifactClassMap = new LinkedHashMap<Artifact, Set>();
        Set dependencyArtifacts = project.getArtifacts();
        Iterator iterator = dependencyArtifacts.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            File file = artifact.getFile();
            if (file == null || !file.getName().endsWith(".jar")) continue;
            URL url = file.toURL();
            Set classes = this.classAnalyzer.analyze(url);
            artifactClassMap.put(artifact, classes);
        }
        return artifactClassMap;
    }

    private Set buildDependencyClasses(MavenProject project) throws IOException {
        HashSet dependencyClasses = new HashSet();
        String outputDirectory = project.getBuild().getOutputDirectory();
        dependencyClasses.addAll(this.buildDependencyClasses(outputDirectory));
        String testOutputDirectory = project.getBuild().getTestOutputDirectory();
        dependencyClasses.addAll(this.buildDependencyClasses(testOutputDirectory));
        return dependencyClasses;
    }

    private Set buildDependencyClasses(String path) throws IOException {
        URL url = new File(path).toURI().toURL();
        return this.dependencyAnalyzer.analyze(url);
    }

    private Set buildDeclaredArtifacts(MavenProject project) {
        Set declaredArtifacts = project.getDependencyArtifacts();
        if (declaredArtifacts == null) {
            declaredArtifacts = Collections.EMPTY_SET;
        }
        return declaredArtifacts;
    }

    private Set buildUsedArtifacts(Map artifactClassMap, Set dependencyClasses) {
        HashSet<Artifact> usedArtifacts = new HashSet<Artifact>();
        Iterator dependencyIterator = dependencyClasses.iterator();
        while (dependencyIterator.hasNext()) {
            String className = (String)dependencyIterator.next();
            Artifact artifact = this.findArtifactForClassName(artifactClassMap, className);
            if (artifact == null) continue;
            usedArtifacts.add(artifact);
        }
        return usedArtifacts;
    }

    private Artifact findArtifactForClassName(Map artifactClassMap, String className) {
        Iterator artifactIterator = artifactClassMap.keySet().iterator();
        while (artifactIterator.hasNext()) {
            Artifact artifact = (Artifact)artifactIterator.next();
            Set artifactClassNames = (Set)artifactClassMap.get(artifact);
            if (!artifactClassNames.contains(className)) continue;
            return artifact;
        }
        return null;
    }
}

