/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.privilege;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.privilege.PrivilegeChecker;
import org.apache.paimon.privilege.PrivilegedFileStore;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.query.LocalTableQuery;
import org.apache.paimon.table.sink.RowKeyExtractor;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.table.source.InnerStreamTableScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class PrivilegedFileStoreTable
implements FileStoreTable {
    private final FileStoreTable wrapped;
    private final PrivilegeChecker privilegeChecker;
    private final Identifier identifier;

    public PrivilegedFileStoreTable(FileStoreTable wrapped, PrivilegeChecker privilegeChecker, Identifier identifier) {
        this.wrapped = wrapped;
        this.privilegeChecker = privilegeChecker;
        this.identifier = identifier;
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newSnapshotReader();
    }

    @Override
    public SnapshotReader newSnapshotReader(String branchName) {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newSnapshotReader(branchName);
    }

    @Override
    public CoreOptions coreOptions() {
        return this.wrapped.coreOptions();
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.wrapped.snapshotManager();
    }

    @Override
    public TagManager tagManager() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.tagManager();
    }

    @Override
    public BranchManager branchManager() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.branchManager();
    }

    @Override
    public Path location() {
        return this.wrapped.location();
    }

    @Override
    public FileIO fileIO() {
        return this.wrapped.fileIO();
    }

    @Override
    public TableSchema schema() {
        return this.wrapped.schema();
    }

    @Override
    public FileStore<?> store() {
        return new PrivilegedFileStore(this.wrapped.store(), this.privilegeChecker, this.identifier);
    }

    @Override
    public BucketMode bucketMode() {
        return this.wrapped.bucketMode();
    }

    @Override
    public CatalogEnvironment catalogEnvironment() {
        return this.wrapped.catalogEnvironment();
    }

    @Override
    public Optional<Statistics> statistics() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.statistics();
    }

    @Override
    public FileStoreTable copy(Map<String, String> dynamicOptions) {
        return new PrivilegedFileStoreTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions), this.privilegeChecker, this.identifier);
    }

    @Override
    public FileStoreTable copy(TableSchema newTableSchema) {
        return new PrivilegedFileStoreTable(this.wrapped.copy(newTableSchema), this.privilegeChecker, this.identifier);
    }

    @Override
    public void rollbackTo(long snapshotId) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.rollbackTo(snapshotId);
    }

    @Override
    public void createTag(String tagName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createTag(tagName);
    }

    @Override
    public void createTag(String tagName, long fromSnapshotId) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createTag(tagName, fromSnapshotId);
    }

    @Override
    public void createTag(String tagName, Duration timeRetained) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createTag(tagName, timeRetained);
    }

    @Override
    public void createTag(String tagName, long fromSnapshotId, Duration timeRetained) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createTag(tagName, fromSnapshotId, timeRetained);
    }

    @Override
    public void deleteTag(String tagName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.deleteTag(tagName);
    }

    @Override
    public void rollbackTo(String tagName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.rollbackTo(tagName);
    }

    @Override
    public void createBranch(String branchName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createBranch(branchName);
    }

    @Override
    public void createBranch(String branchName, long snapshotId) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createBranch(branchName, snapshotId);
    }

    @Override
    public void createBranch(String branchName, String tagName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createBranch(branchName, tagName);
    }

    @Override
    public void deleteBranch(String branchName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.deleteBranch(branchName);
    }

    @Override
    public ExpireSnapshots newExpireSnapshots() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newExpireSnapshots();
    }

    @Override
    public ExpireSnapshots newExpireChangelog() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newExpireChangelog();
    }

    @Override
    public FileStoreTable copyWithoutTimeTravel(Map<String, String> dynamicOptions) {
        return new PrivilegedFileStoreTable(this.wrapped.copyWithoutTimeTravel(dynamicOptions), this.privilegeChecker, this.identifier);
    }

    @Override
    public FileStoreTable copyWithLatestSchema() {
        return new PrivilegedFileStoreTable(this.wrapped.copyWithLatestSchema(), this.privilegeChecker, this.identifier);
    }

    @Override
    public InnerTableScan newScan() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newScan();
    }

    @Override
    public InnerStreamTableScan newStreamScan() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newStreamScan();
    }

    @Override
    public InnerTableRead newRead() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newRead();
    }

    @Override
    public TableWriteImpl<?> newWrite(String commitUser) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newWrite(commitUser);
    }

    @Override
    public TableWriteImpl<?> newWrite(String commitUser, ManifestCacheFilter manifestFilter) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newWrite(commitUser, manifestFilter);
    }

    @Override
    public TableCommitImpl newCommit(String commitUser) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newCommit(commitUser);
    }

    @Override
    public TableCommitImpl newCommit(String commitUser, String branchName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newCommit(commitUser, branchName);
    }

    @Override
    public LocalTableQuery newLocalTableQuery() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newLocalTableQuery();
    }

    @Override
    public boolean supportStreamingReadOverwrite() {
        return this.wrapped.supportStreamingReadOverwrite();
    }

    @Override
    public RowKeyExtractor createRowKeyExtractor() {
        return this.wrapped.createRowKeyExtractor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegedFileStoreTable that = (PrivilegedFileStoreTable)o;
        return Objects.equals(this.wrapped, that.wrapped) && Objects.equals(this.privilegeChecker, that.privilegeChecker) && Objects.equals(this.identifier, that.identifier);
    }
}

