/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQInternalException;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.BasicMessageConsumer;
import org.apache.qpid.client.filter.JMSSelectorFilter;
import org.apache.qpid.protocol.AMQConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQQueueBrowser
implements QueueBrowser {
    private static final Logger _logger = LoggerFactory.getLogger(AMQQueueBrowser.class);
    private AtomicBoolean _isClosed = new AtomicBoolean();
    private final AMQSession _session;
    private final Queue _queue;
    private final ArrayList<BasicMessageConsumer> _consumers = new ArrayList();
    private final String _messageSelector;

    AMQQueueBrowser(AMQSession session, Queue queue, String messageSelector) throws JMSException {
        this._session = session;
        this._queue = queue;
        this._messageSelector = messageSelector == null || messageSelector.trim().length() == 0 ? null : messageSelector;
        this.validateQueue((AMQDestination)queue);
        if (this._messageSelector != null) {
            this.validateSelector(this._messageSelector);
        }
    }

    private void validateSelector(String messageSelector) throws InvalidSelectorException {
        try {
            new JMSSelectorFilter(messageSelector);
        }
        catch (AMQInternalException e) {
            throw new InvalidSelectorException(e.getMessage());
        }
    }

    private void validateQueue(AMQDestination queue) throws JMSException {
        try {
            this._session.sync();
        }
        catch (AMQException e) {
            if (e.getErrorCode() == AMQConstant.NOT_FOUND) {
                throw new InvalidDestinationException(e.getMessage());
            }
            JMSException jmsException = new JMSException(e.getMessage(), String.valueOf(e.getErrorCode().getCode()));
            jmsException.setLinkedException((Exception)((Object)e));
            throw jmsException;
        }
    }

    public Queue getQueue() throws JMSException {
        this.checkState();
        return this._queue;
    }

    private void checkState() throws JMSException {
        if (this._isClosed.get()) {
            throw new IllegalStateException("Queue Browser");
        }
        if (this._session.isClosed()) {
            throw new IllegalStateException("Session is closed");
        }
    }

    public String getMessageSelector() throws JMSException {
        this.checkState();
        return this._messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.checkState();
        if (!this._session.getAMQConnection().started()) {
            throw new IllegalStateException("Cannot enumerate message on the queue while the Connection is stopped");
        }
        BasicMessageConsumer consumer = (BasicMessageConsumer)this._session.createBrowserConsumer((Destination)this._queue, this._messageSelector, false);
        this._consumers.add(consumer);
        return new QueueBrowserEnumeration(consumer);
    }

    public void close() throws JMSException {
        for (BasicMessageConsumer consumer : this._consumers) {
            consumer.close();
        }
        this._consumers.clear();
    }

    private class QueueBrowserEnumeration
    implements Enumeration {
        private Message _nextMessage;
        private BasicMessageConsumer _consumer;

        public QueueBrowserEnumeration(BasicMessageConsumer consumer) throws JMSException {
            if (consumer != null) {
                this._consumer = consumer;
                this.prefetchMessage();
            }
            _logger.debug("QB:created with first element:" + this._nextMessage);
        }

        public boolean hasMoreElements() {
            _logger.debug("QB:hasMoreElements:" + (this._nextMessage != null));
            return this._nextMessage != null;
        }

        public Object nextElement() {
            Message msg = this._nextMessage;
            if (msg == null) {
                throw new NoSuchElementException("No messages");
            }
            try {
                _logger.debug("QB:nextElement about to receive");
                this.prefetchMessage();
                _logger.debug("QB:nextElement received:" + this._nextMessage);
            }
            catch (JMSException e) {
                _logger.warn("Exception caught while queue browsing", (Throwable)e);
                this._nextMessage = null;
                try {
                    this.closeConsumer();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            return msg;
        }

        private void prefetchMessage() throws JMSException {
            this._nextMessage = this._consumer.receiveBrowse();
            if (this._nextMessage == null) {
                this.closeConsumer();
            }
        }

        private void closeConsumer() throws JMSException {
            if (this._consumer != null) {
                BasicMessageConsumer consumer = this._consumer;
                this._consumer = null;
                consumer.close();
            }
        }
    }
}

