/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.io.EOFException;
import java.nio.ByteBuffer;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractBytesTypedMessage;
import org.apache.qpid.typedmessage.TypedBytesContentReader;
import org.apache.qpid.typedmessage.TypedBytesContentWriter;
import org.apache.qpid.typedmessage.TypedBytesFormatException;

public class JMSStreamMessage
extends AbstractBytesTypedMessage
implements StreamMessage {
    public static final String MIME_TYPE = "jms/stream-message";
    private TypedBytesContentReader _typedBytesContentReader;
    private TypedBytesContentWriter _typedBytesContentWriter;

    public JMSStreamMessage(AMQMessageDelegateFactory delegateFactory) {
        super(delegateFactory, false);
        this._typedBytesContentWriter = new TypedBytesContentWriter();
    }

    JMSStreamMessage(AMQMessageDelegateFactory delegateFactory, ByteBuffer data) throws AMQException {
        super(delegateFactory, data != null);
        this._typedBytesContentWriter = new TypedBytesContentWriter();
    }

    JMSStreamMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        super(delegate, data != null);
        this._typedBytesContentReader = new TypedBytesContentReader(data);
    }

    public void reset() {
        this.setReadable(true);
        if (this._typedBytesContentReader != null) {
            this._typedBytesContentReader.reset();
        } else if (this._typedBytesContentWriter != null) {
            this._typedBytesContentReader = new TypedBytesContentReader(this._typedBytesContentWriter.getData());
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this._typedBytesContentReader = null;
        this._typedBytesContentWriter = new TypedBytesContentWriter();
    }

    protected String getMimeType() {
        return MIME_TYPE;
    }

    public ByteBuffer getData() throws JMSException {
        return this._typedBytesContentWriter == null ? this._typedBytesContentReader.getData() : this._typedBytesContentWriter.getData();
    }

    public boolean readBoolean() throws JMSException {
        this.checkReadable();
        try {
            return this._typedBytesContentReader.readBoolean();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (TypedBytesFormatException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public byte readByte() throws JMSException {
        this.checkReadable();
        try {
            return this._typedBytesContentReader.readByte();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (TypedBytesFormatException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public short readShort() throws JMSException {
        this.checkReadable();
        try {
            return this._typedBytesContentReader.readShort();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (TypedBytesFormatException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public char readChar() throws JMSException {
        this.checkReadable();
        try {
            return this._typedBytesContentReader.readChar();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (TypedBytesFormatException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public int readInt() throws JMSException {
        this.checkReadable();
        try {
            return this._typedBytesContentReader.readInt();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (TypedBytesFormatException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public long readLong() throws JMSException {
        this.checkReadable();
        try {
            return this._typedBytesContentReader.readLong();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (TypedBytesFormatException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public float readFloat() throws JMSException {
        this.checkReadable();
        try {
            return this._typedBytesContentReader.readFloat();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (TypedBytesFormatException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public double readDouble() throws JMSException {
        this.checkReadable();
        try {
            return this._typedBytesContentReader.readDouble();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (TypedBytesFormatException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public String readString() throws JMSException {
        this.checkReadable();
        try {
            return this._typedBytesContentReader.readString();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (TypedBytesFormatException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public int readBytes(byte[] bytes) throws JMSException {
        if (bytes == null) {
            throw new IllegalArgumentException("Must provide non-null array to read into");
        }
        this.checkReadable();
        try {
            return this._typedBytesContentReader.readBytes(bytes);
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (TypedBytesFormatException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public Object readObject() throws JMSException {
        this.checkReadable();
        try {
            return this._typedBytesContentReader.readObject();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (TypedBytesFormatException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public void writeBoolean(boolean b) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeBoolean(b);
    }

    public void writeByte(byte b) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeByte(b);
    }

    public void writeShort(short i) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeShort(i);
    }

    public void writeChar(char c) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeChar(c);
    }

    public void writeInt(int i) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeInt(i);
    }

    public void writeLong(long l) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeLong(l);
    }

    public void writeFloat(float v) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeFloat(v);
    }

    public void writeDouble(double v) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeDouble(v);
    }

    public void writeString(String string) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeString(string);
    }

    public void writeBytes(byte[] bytes) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeBytes(bytes);
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws JMSException {
        this.checkWritable();
        this._typedBytesContentWriter.writeBytes(bytes, offset, length);
    }

    public void writeObject(Object object) throws JMSException {
        this.checkWritable();
        try {
            this._typedBytesContentWriter.writeObject(object);
        }
        catch (TypedBytesFormatException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }
}

