/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.security.sasl.SaslClientFactory;
import org.apache.qpid.client.security.JCAProvider;
import org.apache.qpid.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicSaslRegistrar {
    private static final Logger _logger = LoggerFactory.getLogger(DynamicSaslRegistrar.class);
    private static final String FILE_PROPERTY = "amq.dynamicsaslregistrar.properties";
    public static final String DEFAULT_RESOURCE_NAME = "org/apache/qpid/client/security/DynamicSaslRegistrar.properties";

    private DynamicSaslRegistrar() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProviderRegistrationResult registerSaslProviders() {
        _logger.debug("public static void registerSaslProviders(): called");
        ProviderRegistrationResult result = ProviderRegistrationResult.FAILED;
        String filename = System.getProperty(FILE_PROPERTY);
        InputStream is = FileUtils.openFileOrDefaultResource((String)filename, (String)DEFAULT_RESOURCE_NAME, (ClassLoader)DynamicSaslRegistrar.class.getClassLoader());
        try {
            Properties props = new Properties();
            props.load(is);
            _logger.debug("props = " + props);
            Map<String, Class<? extends SaslClientFactory>> factories = DynamicSaslRegistrar.parseProperties(props);
            if (factories.size() > 0) {
                JCAProvider qpidProvider = new JCAProvider(factories);
                if (Security.insertProviderAt(qpidProvider, 1) == -1) {
                    Provider registeredProvider = DynamicSaslRegistrar.findProvider("AMQSASLProvider-Client");
                    if (registeredProvider == null) {
                        result = ProviderRegistrationResult.FAILED;
                        _logger.error("Unable to load custom SASL providers.");
                    } else if (registeredProvider.equals(qpidProvider)) {
                        result = ProviderRegistrationResult.EQUAL_ALREADY_REGISTERED;
                        _logger.debug("Custom SASL provider is already registered with equal properties.");
                    } else {
                        result = ProviderRegistrationResult.DIFFERENT_ALREADY_REGISTERED;
                        _logger.warn("Custom SASL provider was already registered with different properties.");
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Custom SASL provider " + registeredProvider + " properties: " + new HashMap<Object, Object>(registeredProvider));
                        }
                    }
                } else {
                    result = ProviderRegistrationResult.SUCCEEDED;
                    _logger.info("Additional SASL providers successfully registered.");
                }
            } else {
                result = ProviderRegistrationResult.NO_SASL_FACTORIES;
                _logger.warn("No additional SASL factories found to register.");
            }
        }
        catch (IOException e) {
            result = ProviderRegistrationResult.FAILED;
            _logger.error("Error reading properties: " + e, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    _logger.error("Unable to close properties stream: " + e, (Throwable)e);
                }
            }
        }
        return result;
    }

    static Provider findProvider(String name) {
        Provider[] providers = Security.getProviders();
        Provider registeredProvider = null;
        for (Provider provider : providers) {
            if (!name.equals(provider.getName())) continue;
            registeredProvider = provider;
            break;
        }
        return registeredProvider;
    }

    private static Map<String, Class<? extends SaslClientFactory>> parseProperties(Properties props) {
        Enumeration<?> e = props.propertyNames();
        TreeMap<String, Class<? extends SaslClientFactory>> factoriesToRegister = new TreeMap<String, Class<? extends SaslClientFactory>>();
        while (e.hasMoreElements()) {
            String mechanism = (String)e.nextElement();
            String className = props.getProperty(mechanism);
            try {
                Class<?> clazz = Class.forName(className);
                if (!SaslClientFactory.class.isAssignableFrom(clazz)) {
                    _logger.error("Class " + clazz + " does not implement " + SaslClientFactory.class + " - skipping");
                    continue;
                }
                _logger.debug("Found class " + clazz.getName() + " for mechanism " + mechanism);
                factoriesToRegister.put(mechanism, clazz);
            }
            catch (Exception ex) {
                _logger.error("Error instantiating SaslClientFactory class " + className + " - skipping");
            }
        }
        return factoriesToRegister;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProviderRegistrationResult {
        SUCCEEDED,
        EQUAL_ALREADY_REGISTERED,
        DIFFERENT_ALREADY_REGISTERED,
        NO_SASL_FACTORIES,
        FAILED;

    }
}

