/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;

public class HeartbeatBody
implements AMQBody {
    public static final byte TYPE = 8;
    public static final AMQFrame FRAME = new HeartbeatBody().toFrame();

    public HeartbeatBody() {
    }

    public HeartbeatBody(DataInputStream buffer, long size) throws IOException {
        if (size > 0L) {
            buffer.skip(size);
        }
    }

    public byte getFrameType() {
        return 8;
    }

    public int getSize() {
        return 0;
    }

    public void writePayload(DataOutput buffer) {
    }

    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws AMQException {
        session.heartbeatBodyReceived(channelId, this);
    }

    protected void populateFromBuffer(DataInputStream buffer, long size) throws AMQFrameDecodingException, IOException {
        if (size > 0L) {
            buffer.skip(size);
        }
    }

    public AMQFrame toFrame() {
        return new AMQFrame(0, this);
    }
}

