/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ConnectionOpenBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class ConnectionOpenBodyImpl
extends AMQMethodBody_8_0
implements ConnectionOpenBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new ConnectionOpenBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 40;
    private final AMQShortString _virtualHost;
    private final AMQShortString _capabilities;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionOpenBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._virtualHost = this.readAMQShortString(buffer);
        this._capabilities = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public ConnectionOpenBodyImpl(AMQShortString virtualHost, AMQShortString capabilities, boolean insist) {
        this._virtualHost = virtualHost;
        this._capabilities = capabilities;
        byte bitfield0 = 0;
        if (insist) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    public int getClazz() {
        return 10;
    }

    public int getMethod() {
        return 40;
    }

    public final AMQShortString getVirtualHost() {
        return this._virtualHost;
    }

    public final AMQShortString getCapabilities() {
        return this._capabilities;
    }

    public final boolean getInsist() {
        return (this._bitfield0 & 1) != 0;
    }

    protected int getBodySize() {
        int size = 1;
        size += this.getSizeOf(this._virtualHost);
        return size += this.getSizeOf(this._capabilities);
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._virtualHost);
        this.writeAMQShortString(buffer, this._capabilities);
        this.writeBitfield(buffer, this._bitfield0);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchConnectionOpen(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionOpenBodyImpl: ");
        buf.append("virtualHost=");
        buf.append(this.getVirtualHost());
        buf.append(", ");
        buf.append("capabilities=");
        buf.append(this.getCapabilities());
        buf.append(", ");
        buf.append("insist=");
        buf.append(this.getInsist());
        buf.append("]");
        return buf.toString();
    }
}

