/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.StreamQosBody;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class StreamQosBodyImpl
extends AMQMethodBody_8_0
implements StreamQosBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new StreamQosBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 80;
    public static final int METHOD_ID = 10;
    private final long _prefetchSize;
    private final int _prefetchCount;
    private final long _consumeRate;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public StreamQosBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._prefetchSize = this.readUnsignedInteger(buffer);
        this._prefetchCount = this.readUnsignedShort(buffer);
        this._consumeRate = this.readUnsignedInteger(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public StreamQosBodyImpl(long prefetchSize, int prefetchCount, long consumeRate, boolean global) {
        this._prefetchSize = prefetchSize;
        this._prefetchCount = prefetchCount;
        this._consumeRate = consumeRate;
        byte bitfield0 = 0;
        if (global) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    public int getClazz() {
        return 80;
    }

    public int getMethod() {
        return 10;
    }

    public final long getPrefetchSize() {
        return this._prefetchSize;
    }

    public final int getPrefetchCount() {
        return this._prefetchCount;
    }

    public final long getConsumeRate() {
        return this._consumeRate;
    }

    public final boolean getGlobal() {
        return (this._bitfield0 & 1) != 0;
    }

    protected int getBodySize() {
        int size = 11;
        return size;
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedInteger(buffer, this._prefetchSize);
        this.writeUnsignedShort(buffer, this._prefetchCount);
        this.writeUnsignedInteger(buffer, this._consumeRate);
        this.writeBitfield(buffer, this._bitfield0);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchStreamQos(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[StreamQosBodyImpl: ");
        buf.append("prefetchSize=");
        buf.append(this.getPrefetchSize());
        buf.append(", ");
        buf.append("prefetchCount=");
        buf.append(this.getPrefetchCount());
        buf.append(", ");
        buf.append("consumeRate=");
        buf.append(this.getConsumeRate());
        buf.append(", ");
        buf.append("global=");
        buf.append(this.getGlobal());
        buf.append("]");
        return buf.toString();
    }
}

