/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionSecure
extends Method {
    public static final int TYPE = 259;
    private short packing_flags = 0;
    private byte[] challenge;

    @Override
    public final int getStructType() {
        return 259;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 0;
    }

    @Override
    public final boolean isConnectionControl() {
        return true;
    }

    public ConnectionSecure() {
    }

    public ConnectionSecure(byte[] challenge, Option ... _options) {
        if (challenge != null) {
            this.setChallenge(challenge);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.connectionSecure(context, this);
    }

    public final boolean hasChallenge() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ConnectionSecure clearChallenge() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.challenge = null;
        this.setDirty(true);
        return this;
    }

    public final byte[] getChallenge() {
        return this.challenge;
    }

    public final ConnectionSecure setChallenge(byte[] value) {
        this.challenge = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final ConnectionSecure challenge(byte[] value) {
        return this.setChallenge(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeVbin32(this.challenge);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.challenge = dec.readVbin32();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("challenge", this.getChallenge());
        }
        return result;
    }
}

