/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.ExecutionErrorCode;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionException
extends Method {
    public static final int TYPE = 771;
    private short packing_flags = 0;
    private ExecutionErrorCode errorCode;
    private int commandId;
    private short classCode;
    private short commandCode;
    private short fieldIndex;
    private String description;
    private Map<String, Object> errorInfo;

    @Override
    public final int getStructType() {
        return 771;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public ExecutionException() {
    }

    public ExecutionException(ExecutionErrorCode errorCode, int commandId, short classCode, short commandCode, short fieldIndex, String description, Map<String, Object> errorInfo, Option ... _options) {
        if (errorCode != null) {
            this.setErrorCode(errorCode);
        }
        this.setCommandId(commandId);
        this.setClassCode(classCode);
        this.setCommandCode(commandCode);
        this.setFieldIndex(fieldIndex);
        if (description != null) {
            this.setDescription(description);
        }
        if (errorInfo != null) {
            this.setErrorInfo(errorInfo);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.executionException(context, this);
    }

    public final boolean hasErrorCode() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ExecutionException clearErrorCode() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.errorCode = null;
        this.setDirty(true);
        return this;
    }

    public final ExecutionErrorCode getErrorCode() {
        return this.errorCode;
    }

    public final ExecutionException setErrorCode(ExecutionErrorCode value) {
        this.errorCode = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final ExecutionException errorCode(ExecutionErrorCode value) {
        return this.setErrorCode(value);
    }

    public final boolean hasCommandId() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ExecutionException clearCommandId() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.commandId = 0;
        this.setDirty(true);
        return this;
    }

    public final int getCommandId() {
        return this.commandId;
    }

    public final ExecutionException setCommandId(int value) {
        this.commandId = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final ExecutionException commandId(int value) {
        return this.setCommandId(value);
    }

    public final boolean hasClassCode() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final ExecutionException clearClassCode() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.classCode = 0;
        this.setDirty(true);
        return this;
    }

    public final short getClassCode() {
        return this.classCode;
    }

    public final ExecutionException setClassCode(short value) {
        this.classCode = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.setDirty(true);
        return this;
    }

    public final ExecutionException classCode(short value) {
        return this.setClassCode(value);
    }

    public final boolean hasCommandCode() {
        return (this.packing_flags & 0x800) != 0;
    }

    public final ExecutionException clearCommandCode() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFF7FF);
        this.commandCode = 0;
        this.setDirty(true);
        return this;
    }

    public final short getCommandCode() {
        return this.commandCode;
    }

    public final ExecutionException setCommandCode(short value) {
        this.commandCode = value;
        this.packing_flags = (short)(this.packing_flags | 0x800);
        this.setDirty(true);
        return this;
    }

    public final ExecutionException commandCode(short value) {
        return this.setCommandCode(value);
    }

    public final boolean hasFieldIndex() {
        return (this.packing_flags & 0x1000) != 0;
    }

    public final ExecutionException clearFieldIndex() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFEFFF);
        this.fieldIndex = 0;
        this.setDirty(true);
        return this;
    }

    public final short getFieldIndex() {
        return this.fieldIndex;
    }

    public final ExecutionException setFieldIndex(short value) {
        this.fieldIndex = value;
        this.packing_flags = (short)(this.packing_flags | 0x1000);
        this.setDirty(true);
        return this;
    }

    public final ExecutionException fieldIndex(short value) {
        return this.setFieldIndex(value);
    }

    public final boolean hasDescription() {
        return (this.packing_flags & 0x2000) != 0;
    }

    public final ExecutionException clearDescription() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFDFFF);
        this.description = null;
        this.setDirty(true);
        return this;
    }

    public final String getDescription() {
        return this.description;
    }

    public final ExecutionException setDescription(String value) {
        this.description = value;
        this.packing_flags = (short)(this.packing_flags | 0x2000);
        this.setDirty(true);
        return this;
    }

    public final ExecutionException description(String value) {
        return this.setDescription(value);
    }

    public final boolean hasErrorInfo() {
        return (this.packing_flags & 0x4000) != 0;
    }

    public final ExecutionException clearErrorInfo() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFBFFF);
        this.errorInfo = null;
        this.setDirty(true);
        return this;
    }

    public final Map<String, Object> getErrorInfo() {
        return this.errorInfo;
    }

    public final ExecutionException setErrorInfo(Map<String, Object> value) {
        this.errorInfo = value;
        this.packing_flags = (short)(this.packing_flags | 0x4000);
        this.setDirty(true);
        return this;
    }

    public final ExecutionException errorInfo(Map<String, Object> value) {
        return this.setErrorInfo(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeUint16(this.errorCode.getValue());
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeSequenceNo(this.commandId);
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeUint8(this.classCode);
        }
        if ((this.packing_flags & 0x800) != 0) {
            enc.writeUint8(this.commandCode);
        }
        if ((this.packing_flags & 0x1000) != 0) {
            enc.writeUint8(this.fieldIndex);
        }
        if ((this.packing_flags & 0x2000) != 0) {
            enc.writeStr16(this.description);
        }
        if ((this.packing_flags & 0x4000) != 0) {
            enc.writeMap(this.errorInfo);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.errorCode = ExecutionErrorCode.get(dec.readUint16());
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.commandId = dec.readSequenceNo();
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.classCode = dec.readUint8();
        }
        if ((this.packing_flags & 0x800) != 0) {
            this.commandCode = dec.readUint8();
        }
        if ((this.packing_flags & 0x1000) != 0) {
            this.fieldIndex = dec.readUint8();
        }
        if ((this.packing_flags & 0x2000) != 0) {
            this.description = dec.readStr16();
        }
        if ((this.packing_flags & 0x4000) != 0) {
            this.errorInfo = dec.readMap();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("errorCode", (Object)this.getErrorCode());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("commandId", this.getCommandId());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("classCode", this.getClassCode());
        }
        if ((this.packing_flags & 0x800) != 0) {
            result.put("commandCode", this.getCommandCode());
        }
        if ((this.packing_flags & 0x1000) != 0) {
            result.put("fieldIndex", this.getFieldIndex());
        }
        if ((this.packing_flags & 0x2000) != 0) {
            result.put("description", this.getDescription());
        }
        if ((this.packing_flags & 0x4000) != 0) {
            result.put("errorInfo", this.getErrorInfo());
        }
        return result;
    }
}

